/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.kml;

import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEData;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.BBoxInfo;
import org.eclipse.stem.ui.ge.kml.IKmlDisplay;
import org.eclipse.stem.ui.ge.kml.KmlDoc;
import org.eclipse.stem.ui.ge.kml.PlaceMark;
import org.eclipse.stem.ui.ge.kml.Polygon;
import org.eclipse.stem.ui.ge.kml.StemKml;
import org.eclipse.stem.ui.ge.kml.Style;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KmlDisplay
implements IKmlDisplay {
    public void init() {
    }

    @Override
    public void generatePolygons(String controlFileName, Map<String, GEData> geData, Aspect aspect) {
        int written = 0;
        KmlDoc kml = new KmlDoc();
        Document doc = kml.getDocument();
        Element root = kml.setRoot(null);
        Element document = kml.appendElement(root, "Document");
        Style[] styles = this.setupStyles(kml, document, aspect);
        int max = aspect.getRange().length;
        PlaceMark[] placeMark = new PlaceMark[max];
        Element[] multiGeometry = new Element[max];
        int j = 0;
        while (j < max) {
            placeMark[j] = new PlaceMark(doc);
            document.appendChild(placeMark[j].getElement());
            placeMark[j].setDescription("STEM map");
            placeMark[j].setName("STEM" + j);
            placeMark[j].setStyleUrl(styles[j]);
            multiGeometry[j] = doc.createElement("MultiGeometry");
            placeMark[j].appendChild(multiGeometry[j]);
            ++j;
        }
        Rectangle bboxView = BBoxInfo.getBBox();
        Iterator<Map.Entry<String, GEData>> it = geData.entrySet().iterator();
        boolean bboxFilter = GEPreferencePage.isBBOX();
        while (it.hasNext()) {
            int type = 0;
            Map.Entry<String, GEData> e = it.next();
            GEData data = e.getValue();
            String county = data.getName();
            type = bboxFilter && this.filter(data, bboxView) ? 0 : this.selectByValue(aspect, data);
            if (type <= 0) continue;
            int n = data.getNumAreas();
            int i = 0;
            while (i < n) {
                String coord = data.getCoordinatesAsString(i);
                Polygon polygon = new Polygon(doc);
                kml.appendText(polygon.getElement(), "name", county);
                polygon.setCoordinates(coord);
                multiGeometry[type].appendChild(polygon.getElement());
                ++i;
            }
            ++written;
        }
        GELog.debug(this, "write " + controlFileName + " with " + written + " entries.");
        kml.writeFile(controlFileName);
    }

    private boolean filter(GEData data, Rectangle bboxView) {
        boolean filtered = false;
        if (bboxView != null) {
            Rectangle bbox = data.getBBox();
            filtered = !BBoxInfo.testContainment(bbox, bboxView);
            return filtered;
        }
        return filtered;
    }

    private Style[] setupStyles(KmlDoc kml, Element document, Aspect aspect) {
        Document doc = kml.getDocument();
        int max = aspect.getRange().length;
        Style[] styles = new Style[max];
        int k = 0;
        while (k < max) {
            styles[k] = new Style(doc, "Style" + k);
            styles[k].setLineStyle(0.3);
            document.appendChild(styles[k].getElement());
            int oo = 0;
            int blue = 0;
            int red = 0;
            int green = 0;
            boolean outline = GEPreferencePage.isShowBorder();
            if (k == 0) {
                styles[0].setPolyStyle("0", outline);
            } else {
                blue = aspect.getBlue(k);
                red = aspect.getRed(k);
                green = aspect.getGreen(k);
                oo = aspect.getOpacity(k);
                String hex = String.valueOf(StemKml.getHex(oo)) + StemKml.getHex(blue) + StemKml.getHex(green) + StemKml.getHex(red);
                styles[k].setPolyStyle(hex, outline);
            }
            ++k;
        }
        return styles;
    }

    public int selectByValue(Aspect aspect, GEData geData) {
        double value;
        int type;
        block9: {
            String code;
            block8: {
                type = 0;
                code = aspect.getCode();
                Assert.isNotNull((Object)code, (String)"Aspect code is null");
                if (code != null) break block8;
                return 0;
            }
            Map<String, Double> map = geData.getValueMap();
            Assert.isNotNull(map, (String)"Aspect map is null");
            value = 0.0;
            if (map != null) {
                Double d = map.get(code);
                if (d != null) {
                    value = d;
                }
                break block9;
            }
            return 0;
        }
        try {
            double[] range = aspect.getRange();
            int i = 0;
            while (i < range.length) {
                if (value <= range[i]) {
                    type = i;
                    break;
                }
                ++i;
            }
        }
        catch (RuntimeException e1) {
            GELog.error("selectByValue", e1);
        }
        return type;
    }
}

