/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.trace;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.builder.trace.StorageAwareTrace;
import org.eclipse.xtext.builder.trace.TraceMarkers;
import org.eclipse.xtext.generator.trace.AbstractStatefulTraceRegion;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ILocationData;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceInformation;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.TraceNotFoundException;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;
import org.eclipse.xtext.util.TextRegionWithLineInformation;

@NonNullByDefault
public class FileBasedTraceInformation
implements ITraceInformation {
    public static final String TRACE_FILE_EXTENSION = "._trace";
    private static final Logger log = Logger.getLogger(StorageAwareTrace.class);
    @Inject
    private TraceRegionSerializer traceRegionSerializer;
    @Inject
    private Provider<StorageAwareTrace> traceToSourceProvider;
    @Inject
    private TraceMarkers traceMarkers;
    @Inject
    private IWorkspace workspace;
    @Inject
    private IStorage2UriMapper storage2UriMapper;

    @Nullable
    public ITrace getTraceToSource(final IStorage derivedResource) {
        StorageAwareTrace result = (StorageAwareTrace)this.traceToSourceProvider.get();
        result.setLocalStorage(derivedResource);
        result.setTraceRegionProvider(new ITraceRegionProvider(){

            public AbstractTraceRegion getTraceRegion() {
                IStorage traceFile;
                IStorage resource = derivedResource;
                if (resource instanceof IFile && (traceFile = FileBasedTraceInformation.this.getTraceFile(resource)) instanceof IFile && ((IFile)traceFile).exists()) {
                    InputStream contents = null;
                    try {
                        contents = traceFile.getContents();
                        AbstractTraceRegion abstractTraceRegion = FileBasedTraceInformation.this.traceRegionSerializer.readTraceRegionFrom(contents);
                        return abstractTraceRegion;
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)contents);
                    }
                }
                throw new TraceNotFoundException();
            }
        });
        return result;
    }

    @Nullable
    public ITrace getTraceToTarget(IStorage sourceResource) {
        if (sourceResource instanceof IFile) {
            try {
                IFile sourceFile = (IFile)sourceResource;
                final List<IPath> traceFiles = this.traceMarkers.findTraceFiles(sourceFile);
                if (!traceFiles.isEmpty()) {
                    StorageAwareTrace result = (StorageAwareTrace)this.traceToSourceProvider.get();
                    result.setLocalStorage(sourceResource);
                    final URI sourceFileURI = this.storage2UriMapper.getUri(sourceResource);
                    final String projectName = sourceFile.getProject().getName();
                    result.setTraceRegionProvider(new ITraceRegionProvider(){

                        public AbstractTraceRegion getTraceRegion() {
                            ArrayList result = Lists.newArrayList();
                            for (IPath tracePath : traceFiles) {
                                IFile traceFile = FileBasedTraceInformation.this.workspace.getRoot().getFile(tracePath);
                                if (!traceFile.exists()) continue;
                                Object contents = null;
                                try {
                                    try {
                                        contents = traceFile.getContents();
                                        AbstractTraceRegion traceRegion = FileBasedTraceInformation.this.traceRegionSerializer.readTraceRegionFrom((InputStream)contents);
                                        IStorage generatedFileForTraceFile = FileBasedTraceInformation.this.getGeneratedFileForTraceFile((IStorage)traceFile);
                                        if (generatedFileForTraceFile == null) {
                                            throw new TraceNotFoundException();
                                        }
                                        IPath generatedFilePath = generatedFileForTraceFile.getFullPath();
                                        URI generatedFileURI = URI.createPlatformResourceURI((String)generatedFilePath.toString(), (boolean)true);
                                        result.addAll(traceRegion.invertFor(sourceFileURI, generatedFileURI, projectName));
                                    }
                                    catch (Exception e) {
                                        log.error((Object)e.getMessage(), (Throwable)e);
                                        Closeables.closeQuietly((Closeable)contents);
                                        continue;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Closeables.closeQuietly(contents);
                                    throw throwable;
                                }
                                Closeables.closeQuietly((Closeable)contents);
                            }
                            if (!result.isEmpty()) {
                                if (result.size() > 1) {
                                    ITextRegionWithLineInformation rootLocation = ITextRegionWithLineInformation.EMPTY_REGION;
                                    ITextRegionWithLineInformation associated = ITextRegionWithLineInformation.EMPTY_REGION;
                                    for (AbstractTraceRegion child : result) {
                                        rootLocation = rootLocation.merge((ITextRegionWithLineInformation)new TextRegionWithLineInformation(child.getMyOffset(), child.getMyLength(), child.getMyLineNumber(), child.getMyEndLineNumber()));
                                        ILocationData childAssociation = child.getMergedAssociatedLocation();
                                        if (childAssociation == null) continue;
                                        associated = associated.merge((ITextRegionWithLineInformation)childAssociation);
                                    }
                                    AbstractStatefulTraceRegion root = new AbstractStatefulTraceRegion(rootLocation, new ArrayList(), null){};
                                    Collections.sort(result, new Comparator<AbstractTraceRegion>(){

                                        @Override
                                        public int compare(@Nullable AbstractTraceRegion o1, @Nullable AbstractTraceRegion o2) {
                                            if (o1 == null || o2 == null) {
                                                throw new NullPointerException();
                                            }
                                            return o1.getMyOffset() - o2.getMyOffset();
                                        }
                                    });
                                    for (AbstractTraceRegion child : result) {
                                        child.setParent((AbstractTraceRegion)root);
                                    }
                                    return root;
                                }
                                return (AbstractTraceRegion)result.get(0);
                            }
                            throw new TraceNotFoundException();
                        }
                    });
                    return result;
                }
            }
            catch (CoreException coreException) {
                log.info((Object)coreException.getMessage(), (Throwable)coreException);
            }
        }
        return null;
    }

    @Nullable
    public IStorage getTraceFile(IStorage storage) {
        if (storage instanceof IFile) {
            IFile file = (IFile)storage;
            String originLastSegment = file.getFullPath().lastSegment();
            IFile traceFile = file.getParent().getFile((IPath)new Path("." + originLastSegment + TRACE_FILE_EXTENSION));
            return traceFile;
        }
        return null;
    }

    @Nullable
    protected IStorage getGeneratedFileForTraceFile(IStorage traceFile) {
        if (traceFile instanceof IFile) {
            IFile file = (IFile)traceFile;
            String lastSegment = traceFile.getFullPath().lastSegment();
            lastSegment = lastSegment.substring(1, lastSegment.length() - TRACE_FILE_EXTENSION.length());
            return file.getParent().getFile((IPath)new Path(lastSegment));
        }
        return null;
    }
}

