/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.predicates.diseasepredicates.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.predicate.impl.TestImpl;
import org.eclipse.stem.definitions.LocationUtility;
import org.eclipse.stem.diseasemodels.predicates.diseasepredicates.DiseasepredicatesPackage;
import org.eclipse.stem.diseasemodels.predicates.diseasepredicates.LabelValueTest;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;

public class LabelValueTestImpl
extends TestImpl
implements LabelValueTest {
    protected static final String MODEL_NAME_EDEFAULT = null;
    protected String modelName = MODEL_NAME_EDEFAULT;
    protected static final URI TARGET_URI_EDEFAULT = null;
    protected URI targetURI = TARGET_URI_EDEFAULT;
    protected static final String STATE_EDEFAULT = "incidence";
    protected String state = "incidence";
    protected static final double THRESHOLD_EDEFAULT = 100.0;
    protected double threshold = 100.0;
    protected static final String PREDICATE_EDEFAULT = ">";
    protected String predicate = ">";
    protected static final String POPULATION_IDENTIFIER_EDEFAULT = "human";
    protected String populationIdentifier = "human";
    Set<LabelValue> labelValueCache;
    EAttribute attribute;

    protected LabelValueTestImpl() {
    }

    public boolean evaluate(STEMTime time, long timerPeriod, Graph graph) {
        if (this.labelValueCache == null) {
            this.labelValueCache = this.findLabelValues(graph);
        }
        if (this.labelValueCache == null) {
            return false;
        }
        double totalCount = 0.0;
        for (LabelValue currentValue : this.labelValueCache) {
            totalCount += ((Double)currentValue.eGet((EStructuralFeature)this.attribute)).doubleValue();
        }
        if (this.getPredicate().equals("=") && totalCount == this.getThreshold()) {
            return true;
        }
        if (this.getPredicate().equals(PREDICATE_EDEFAULT) && totalCount > this.getThreshold()) {
            return true;
        }
        if (this.getPredicate().equals("<") && totalCount < this.getThreshold()) {
            return true;
        }
        if (this.getPredicate().equals(">=") && totalCount >= this.getThreshold()) {
            return true;
        }
        return this.getPredicate().equals("<=") && totalCount <= this.getThreshold();
    }

    Set<LabelValue> findLabelValues(Graph graph) {
        HashSet<LabelValue> returnValue = new HashSet<LabelValue>();
        Node parent = graph.getNode(this.getTargetURI());
        if (parent == null) {
            return null;
        }
        Set children = LocationUtility.getAllChildren((Node)parent);
        children.add(parent);
        Decorator dec = null;
        for (Decorator d : graph.getDecorators()) {
            if ((!(d instanceof DiseaseModel) || !((DiseaseModel)d).getDiseaseName().equals(this.getModelName())) && (!(d instanceof PopulationModel) || !((PopulationModel)d).getName().equals(this.getModelName()))) continue;
            dec = d;
            break;
        }
        if (dec == null) {
            return null;
        }
        for (Node region : children) {
            block2: for (NodeLabel label : region.getLabels()) {
                DynamicLabel dl;
                if (!(label instanceof DynamicLabel) || (!(dl = (DynamicLabel)label).getDecorator().equals(dec) || !(dl instanceof DiseaseModelLabel) || !((DiseaseModelLabel)dl).getPopulationModelLabel().getPopulationIdentifier().equals(this.getPopulationIdentifier())) && (!(dl instanceof PopulationModelLabel) || !((PopulationModelLabel)dl).getPopulationIdentifier().equals(this.getPopulationIdentifier()))) continue;
                LabelValue currentValue = dl.getCurrentValue();
                for (EAttribute ea : currentValue.eClass().getEAllAttributes()) {
                    EDataType esf = ea.getEAttributeType();
                    if (!esf.getName().equals("EDouble") || !ea.getName().equals(this.getState())) continue;
                    if (this.attribute == null) {
                        this.attribute = ea;
                    }
                    returnValue.add(currentValue);
                    continue block2;
                }
            }
        }
        return returnValue;
    }

    public void reset() {
        this.attribute = null;
        this.labelValueCache = null;
    }

    protected EClass eStaticClass() {
        return DiseasepredicatesPackage.Literals.LABEL_VALUE_TEST;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public void setModelName(String newModelName) {
        this.modelName = newModelName;
    }

    @Override
    public URI getTargetURI() {
        return this.targetURI;
    }

    @Override
    public void setTargetURI(URI newTargetURI) {
        this.targetURI = newTargetURI;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public void setState(String newState) {
        this.state = newState;
    }

    @Override
    public double getThreshold() {
        return this.threshold;
    }

    @Override
    public void setThreshold(double newThreshold) {
        this.threshold = newThreshold;
    }

    @Override
    public String getPredicate() {
        return this.predicate;
    }

    @Override
    public void setPredicate(String newPredicate) {
        this.predicate = newPredicate;
    }

    @Override
    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    @Override
    public void setPopulationIdentifier(String newPopulationIdentifier) {
        this.populationIdentifier = newPopulationIdentifier;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getModelName();
            }
            case 1: {
                return this.getTargetURI();
            }
            case 2: {
                return this.getState();
            }
            case 3: {
                return this.getThreshold();
            }
            case 4: {
                return this.getPredicate();
            }
            case 5: {
                return this.getPopulationIdentifier();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setModelName((String)newValue);
                return;
            }
            case 1: {
                this.setTargetURI((URI)newValue);
                return;
            }
            case 2: {
                this.setState((String)newValue);
                return;
            }
            case 3: {
                this.setThreshold((Double)newValue);
                return;
            }
            case 4: {
                this.setPredicate((String)newValue);
                return;
            }
            case 5: {
                this.setPopulationIdentifier((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setModelName(MODEL_NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setTargetURI(TARGET_URI_EDEFAULT);
                return;
            }
            case 2: {
                this.setState(STATE_EDEFAULT);
                return;
            }
            case 3: {
                this.setThreshold(100.0);
                return;
            }
            case 4: {
                this.setPredicate(PREDICATE_EDEFAULT);
                return;
            }
            case 5: {
                this.setPopulationIdentifier(POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return MODEL_NAME_EDEFAULT == null ? this.modelName != null : !MODEL_NAME_EDEFAULT.equals(this.modelName);
            }
            case 1: {
                return TARGET_URI_EDEFAULT == null ? this.targetURI != null : !TARGET_URI_EDEFAULT.equals((Object)this.targetURI);
            }
            case 2: {
                return STATE_EDEFAULT == null ? this.state != null : !STATE_EDEFAULT.equals(this.state);
            }
            case 3: {
                return this.threshold != 100.0;
            }
            case 4: {
                return PREDICATE_EDEFAULT == null ? this.predicate != null : !PREDICATE_EDEFAULT.equals(this.predicate);
            }
            case 5: {
                return POPULATION_IDENTIFIER_EDEFAULT == null ? this.populationIdentifier != null : !POPULATION_IDENTIFIER_EDEFAULT.equals(this.populationIdentifier);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (modelName: ");
        result.append(this.modelName);
        result.append(", targetURI: ");
        result.append(this.targetURI);
        result.append(", state: ");
        result.append(this.state);
        result.append(", threshold: ");
        result.append(this.threshold);
        result.append(", predicate: ");
        result.append(this.predicate);
        result.append(", populationIdentifier: ");
        result.append(this.populationIdentifier);
        result.append(')');
        return result.toString();
    }
}

