/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.label;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.xtext.ui.label.DeclarativeLabelProvider;
import org.eclipse.xtext.ui.label.DefaultEditorImageUtil;

public class DefaultEditorInputLabelProvider
extends DeclarativeLabelProvider {
    private static final Logger LOG = Logger.getLogger(DefaultEditorInputLabelProvider.class);
    @Inject
    private DefaultEditorImageUtil imageUtil;

    public String text(IStorageEditorInput editorInput) {
        try {
            return editorInput.getStorage().getFullPath().lastSegment();
        }
        catch (CoreException e) {
            LOG.error((Object)"Error resolving IStorage from IStorageEditorInput", (Throwable)e);
            return null;
        }
    }

    public String text(URIEditorInput editorInput) {
        return editorInput.getURI().lastSegment();
    }

    public ImageDescriptor image(IStorageEditorInput editorInput) {
        return this.imageUtil.getDefaultEditorImageDescriptor(this.text(editorInput));
    }

    public ImageDescriptor image(URIEditorInput editorInput) {
        return this.imageUtil.getDefaultEditorImageDescriptor(this.text(editorInput));
    }
}

