/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.externaldatasource.presentation;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.stem.diseasemodels.externaldatasource.ExternalDataSourceDiseaseModel;
import org.eclipse.stem.diseasemodels.externaldatasource.ExternalDataSourcePackage;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.ui.adapters.diseasemodelpropertyeditor.DiseaseModelPropertyEditor;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ExternalDataSourceDiseaseModelPropertyEditor
extends DiseaseModelPropertyEditor {
    public ExternalDataSourceDiseaseModelPropertyEditor(Composite parent, int style, DiseaseModel diseaseModel, ModifyListener projectValidator, IProject project) {
        super(parent, style, diseaseModel, projectValidator, project);
    }

    public void populate(DiseaseModel diseaseModel) {
        super.populate(diseaseModel);
        if (diseaseModel instanceof ExternalDataSourceDiseaseModel) {
            Text txt;
            ExternalDataSourceDiseaseModel model = (ExternalDataSourceDiseaseModel)diseaseModel;
            model.setDataPath(((Text)this.map.get(ExternalDataSourcePackage.Literals.EXTERNAL_DATA_SOURCE_DISEASE_MODEL__DATA_PATH)).getText());
            Button button = (Button)this.booleanMap.get(ExternalDataSourcePackage.Literals.EXTERNAL_DATA_SOURCE_DISEASE_MODEL__RESTART);
            if (button != null) {
                model.setRestart(button.getSelection());
            }
            if ((txt = (Text)this.map.get(ExternalDataSourcePackage.Literals.EXTERNAL_DATA_SOURCE_DISEASE_MODEL__BUFFER_SIZE)) != null) {
                model.setBufferSize(Integer.parseInt(txt.getText().trim()));
            }
        }
    }

    public boolean validate() {
        String path;
        if (!super.validate()) {
            return false;
        }
        Text text = (Text)this.map.get(ExternalDataSourcePackage.Literals.EXTERNAL_DATA_SOURCE_DISEASE_MODEL__DATA_PATH);
        if (text != null && !(path = text.getText()).startsWith("platform") && !new File(path).exists()) {
            this.errorMessage = DiseaseWizardMessages.getString((String)"NDizWizErr20");
            return false;
        }
        text = (Text)this.map.get(ExternalDataSourcePackage.Literals.EXTERNAL_DATA_SOURCE_DISEASE_MODEL__BUFFER_SIZE);
        if (text != null) {
            if (text.getText().equals("")) {
                this.errorMessage = DiseaseWizardMessages.getString((String)"NDizWizErr32");
                return false;
            }
            String intText = text.getText();
            try {
                int r = Integer.parseInt(intText);
                if (r < 1) {
                    this.errorMessage = DiseaseWizardMessages.getString((String)"NDizWizErr32");
                    return false;
                }
            }
            catch (Exception exception) {
                this.errorMessage = DiseaseWizardMessages.getString((String)"NDizWizErr32");
                return false;
            }
        }
        return true;
    }
}

