/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.pde.internal.ui.parts.SharedPartWithButtons;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class StructuredViewerPart
extends SharedPartWithButtons {
    private StructuredViewer fViewer;
    private Point fMinSize;

    public StructuredViewerPart(String[] buttonLabels) {
        super(buttonLabels);
    }

    public StructuredViewer getViewer() {
        return this.fViewer;
    }

    public Control getControl() {
        return this.fViewer.getControl();
    }

    protected void createMainControl(Composite parent, int style, int span, FormToolkit toolkit) {
        this.fViewer = this.createStructuredViewer(parent, style, toolkit);
        Control control = this.fViewer.getControl();
        GridData gd = new GridData(1808);
        gd.horizontalSpan = span;
        control.setLayoutData((Object)gd);
        this.applyMinimumSize();
    }

    public void setMinimumSize(int width, int height) {
        this.fMinSize = new Point(width, height);
        if (this.fViewer != null) {
            this.applyMinimumSize();
        }
    }

    private void applyMinimumSize() {
        if (this.fMinSize != null) {
            GridData gd = (GridData)this.fViewer.getControl().getLayoutData();
            gd.widthHint = this.fMinSize.x;
            gd.heightHint = this.fMinSize.y;
        }
    }

    protected void updateEnabledState() {
        this.getControl().setEnabled(this.isEnabled());
        super.updateEnabledState();
    }

    protected abstract StructuredViewer createStructuredViewer(Composite var1, int var2, FormToolkit var3);
}

