/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.ExternalDataSourceDiseaseInitializer;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.DiseaseInitializerImpl;
import org.eclipse.stem.diseasemodels.standard.impl.DiseaseModelImpl;
import org.eclipse.stem.diseasemodels.standard.impl.Messages;

public class ExternalDataSourceDiseaseInitializerImpl
extends DiseaseInitializerImpl
implements ExternalDataSourceDiseaseInitializer {
    public static final String PLATFORM = "platform:";
    public static final String FILE = "file:";
    protected static final String DATA_PATH_EDEFAULT = null;
    protected String dataPath = DATA_PATH_EDEFAULT;
    protected static final int ROW_EDEFAULT = 0;
    protected int row = 0;
    protected static final boolean DO_RESCALING_EDEFAULT = false;
    protected boolean doRescaling = false;

    protected ExternalDataSourceDiseaseInitializerImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.EXTERNAL_DATA_SOURCE_DISEASE_INITIALIZER;
    }

    @Override
    public String getDataPath() {
        return this.dataPath;
    }

    @Override
    public void setDataPath(String newDataPath) {
        this.dataPath = newDataPath;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public void setRow(int newRow) {
        this.row = newRow;
    }

    @Override
    public boolean isDoRescaling() {
        return this.doRescaling;
    }

    @Override
    public void setDoRescaling(boolean newDoRescaling) {
        this.doRescaling = newDoRescaling;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getDataPath();
            }
            case 11: {
                return this.getRow();
            }
            case 12: {
                return this.isDoRescaling();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setDataPath((String)newValue);
                return;
            }
            case 11: {
                this.setRow((Integer)newValue);
                return;
            }
            case 12: {
                this.setDoRescaling((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setDataPath(DATA_PATH_EDEFAULT);
                return;
            }
            case 11: {
                this.setRow(0);
                return;
            }
            case 12: {
                this.setDoRescaling(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return DATA_PATH_EDEFAULT == null ? this.dataPath != null : !DATA_PATH_EDEFAULT.equals(this.dataPath);
            }
            case 11: {
                return this.row != 0;
            }
            case 12: {
                return this.doRescaling;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (dataPath: ");
        result.append(this.dataPath);
        result.append(", row: ");
        result.append(this.row);
        result.append(", doRescaling: ");
        result.append(this.doRescaling);
        result.append(')');
        return result.toString();
    }

    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
        if (this.isGraphDecorated()) {
            return;
        }
        Graph graph = this.getGraph();
        StandardDiseaseModel diseaseModel = null;
        for (Decorator decorator : graph.getDecorators()) {
            StandardDiseaseModel model;
            if (!(decorator instanceof StandardDiseaseModel) || !(model = (StandardDiseaseModel)decorator).getDiseaseName().equals(this.getDiseaseName())) continue;
            diseaseModel = model;
            break;
        }
        if (diseaseModel == null) {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.INITIALIZER_DISEASE_NOT_FOUND, (Object[])new Object[]{this.getDiseaseName(), this.getURI().toString()}), (Identifiable)this, new Exception());
        }
        Collection allNodes = graph.getNodes().values();
        List<String> compartments = this.getCompartments();
        Map<URI, List<Double>> compartmentValuesMap = null;
        try {
            compartmentValuesMap = this.getCompartmentValues(compartments);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        block3: for (Node node : allNodes) {
            List<Double> compartmentValues = compartmentValuesMap.get(node.getURI());
            if (compartmentValues == null) continue;
            for (NodeLabel nodeLabel : node.getLabels()) {
                DiseaseModelLabel diseaseModelLabel;
                if (!(nodeLabel instanceof DiseaseModelLabel) || (diseaseModelLabel = (DiseaseModelLabel)nodeLabel).getDecorator() != diseaseModel || !diseaseModelLabel.getPopulationModelLabel().getPopulationIdentifier().equals(this.getPopulationIdentifier())) continue;
                this.doInitialization(diseaseModelLabel, compartments, compartmentValues);
                continue block3;
            }
        }
        this.setProgress(1.0);
    }

    public void resetLabels() throws ScenarioInitializationException {
        this.setGraphDecorated(false);
        this.decorateGraph(null);
    }

    private void doInitialization(DiseaseModelLabel label, List<String> compartments, List<Double> compartmentValues) {
        int i;
        DiseaseModelLabelValue current = (DiseaseModelLabelValue)label.getCurrentValue();
        DiseaseModelImpl cfr_ignored_0 = (DiseaseModelImpl)label.getDecorator();
        EList attributes = current.eClass().getEAllAttributes();
        double sumOfCompartments = 0.0;
        double factor = 0.0;
        for (EAttribute attribute : attributes) {
            i = 0;
            while (i < compartments.size()) {
                if (attribute.getName().equalsIgnoreCase(compartments.get(i)) && !DiseaseModelImpl.isIncidence(attribute) && !DiseaseModelImpl.isDiseaseDeaths(attribute)) {
                    sumOfCompartments += compartmentValues.get(i).doubleValue();
                }
                ++i;
            }
        }
        if (sumOfCompartments != 0.0) {
            factor = current.getPopulationCount() / sumOfCompartments;
        }
        if (!this.isDoRescaling()) {
            factor = 1.0;
        }
        for (EAttribute attribute : attributes) {
            i = 0;
            while (i < compartments.size()) {
                if (attribute.getName().equalsIgnoreCase(compartments.get(i))) {
                    double dVal = compartmentValues.get(i) * factor;
                    current.eSet((EStructuralFeature)attribute, new Double(dVal));
                }
                ++i;
            }
        }
    }

    private Map<URI, List<Double>> getCompartmentValues(List<String> compartments) throws IOException {
        HashMap<URI, List<Double>> compartmentValues = new HashMap<URI, List<Double>>();
        File dir = this.getFileFromDataPath(this.dataPath);
        BufferedReader reader = null;
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            int compartmentIndex = compartments.indexOf(this.getCompartmentName(f.getName()));
            try {
                if (compartmentIndex != -1) {
                    reader = new BufferedReader(new FileReader(f));
                    String firstLine = reader.readLine();
                    String[] nodeToks = firstLine.split(",");
                    int i = 1;
                    while (i < this.row) {
                        reader.readLine();
                        ++i;
                    }
                    String line = reader.readLine();
                    String[] valToks = line.split(",");
                    int i2 = 2;
                    while (i2 < nodeToks.length) {
                        URI node = null;
                        double value = Double.parseDouble(valToks[i2]);
                        node = nodeToks[i2].startsWith("stem") ? URI.createURI((String)nodeToks[i2]) : RegionImpl.createRegionNodeURI((String)nodeToks[i2]);
                        ArrayList<Double> values = (ArrayList<Double>)compartmentValues.get(node);
                        if (values == null) {
                            values = new ArrayList<Double>();
                            values.addAll(Collections.nCopies(compartments.size(), new Double(0.0)));
                            compartmentValues.put(node, values);
                        }
                        values.set(compartmentIndex, new Double(value));
                        ++i2;
                    }
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            ++n2;
        }
        return compartmentValues;
    }

    private List<String> getCompartments() {
        ArrayList<String> compartments = new ArrayList<String>();
        File dir = this.getFileFromDataPath(this.dataPath);
        String[] stringArray = dir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fName = stringArray[n2];
            String compartment = this.getCompartmentName(fName);
            if (compartment != null && !compartments.contains(compartment)) {
                compartments.add(compartment);
            }
            ++n2;
        }
        return compartments;
    }

    private String getCompartmentName(String fName) {
        String prefix = fName.substring(0, fName.indexOf(95));
        if (prefix != null && !prefix.equals("Population Count")) {
            return prefix.toLowerCase();
        }
        return null;
    }

    private File getFileFromDataPath(String path) {
        if (path.startsWith(PLATFORM) || path.startsWith(FILE)) {
            try {
                URL inURL = new URL(path);
                return new File(FileLocator.toFileURL((URL)inURL).getFile());
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return new File(path);
    }
}

