/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.ScatterSeries;
import org.eclipse.birt.chart.model.type.impl.ScatterSeriesImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.PhaseSpaceCoordinate;
import org.eclipse.stem.util.analysis.views.LyapunovControl;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class LyapunovTrajectoryCanvas
extends Canvas {
    protected IDeviceRenderer idr = null;
    protected Chart cm = null;
    private LyapunovControl control = null;
    private final List<List<Double>> relativeValuesX = new ArrayList<List<Double>>();
    private final List<List<Double>> relativeValuesY = new ArrayList<List<Double>>();
    Generator gr;
    private final List<LineSeries> lineSeriesList = new ArrayList<LineSeries>();
    Axis yAxisPrimary;
    Axis xAxisPrimary;
    double maxX = -1.0;
    double maxY = -1.0;
    ColorDefinition[] lineColors = new ColorDefinition[]{ColorDefinitionImpl.RED(), ColorDefinitionImpl.BLUE(), ColorDefinitionImpl.ORANGE(), ColorDefinitionImpl.YELLOW(), ColorDefinitionImpl.GREEN(), ColorDefinitionImpl.PINK(), ColorDefinitionImpl.BLACK()};
    private static final int NUM_TRAJECTORIES = 2;
    public static final String TIME_LABEL = "time";
    public static final String RMS_LABEL = "I[A] vs I[B]";
    Image imgChart = null;

    public LyapunovTrajectoryCanvas(Composite parent) {
        super(parent, 0x20000800);
        while (this.relativeValuesX.size() < 2) {
            this.relativeValuesX.add(new ArrayList());
        }
        while (this.relativeValuesY.size() < 2) {
            this.relativeValuesY.add(new ArrayList());
        }
        this.resetData();
        this.gr = Generator.instance();
        try {
            this.idr = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException pex) {
            Activator.logError("Problem initializing chart", pex);
            return;
        }
        this.control = (LyapunovControl)parent;
        this.cm = this.createLyapunovTrajectoryChart(this.relativeValuesX, this.relativeValuesY, Messages.getString("PH.title"));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pe) {
                Composite source = (Composite)pe.getSource();
                Rectangle d = source.getClientArea();
                if (LyapunovTrajectoryCanvas.this.imgChart != null) {
                    LyapunovTrajectoryCanvas.this.imgChart.dispose();
                }
                LyapunovTrajectoryCanvas.this.imgChart = new Image((Device)source.getDisplay(), d);
                LyapunovTrajectoryCanvas.this.idr.setProperty("device.output.context", (Object)new GC((Drawable)LyapunovTrajectoryCanvas.this.imgChart));
                Bounds bounds = BoundsImpl.create((double)d.x, (double)d.y, (double)d.width, (double)d.height);
                bounds.scale(72.0 / (double)LyapunovTrajectoryCanvas.this.idr.getDisplayServer().getDpiResolution());
                try {
                    LyapunovTrajectoryCanvas.this.gr.render(LyapunovTrajectoryCanvas.this.idr, LyapunovTrajectoryCanvas.this.gr.build(LyapunovTrajectoryCanvas.this.idr.getDisplayServer(), LyapunovTrajectoryCanvas.this.cm, bounds, null, null, null));
                    pe.gc.drawImage(LyapunovTrajectoryCanvas.this.imgChart, d.x, d.y);
                }
                catch (ChartException ce) {
                    Activator.logError("Problem rendering chart", ce);
                }
            }
        });
    }

    public void draw() {
        this.clearData();
        LyapunovTrajectoryCanvas.setColorDefs(this.lineSeriesList);
        this.maxX = -1.0;
        this.maxY = -1.0;
        int i = 0;
        while (i < 2) {
            PhaseSpaceCoordinate[] trajectory = this.control.getPointValues(i);
            if (trajectory.length > 0) {
                int j = 0;
                while (j < trajectory.length) {
                    if (trajectory[j].getXValue() >= this.maxX) {
                        this.maxX = trajectory[j].getXValue();
                        this.xAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)this.maxX));
                    }
                    if (trajectory[j].getYValue() >= this.maxY) {
                        this.maxY = trajectory[j].getYValue();
                        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)this.maxY));
                    }
                    ++j;
                }
                int cycleNumber = 0;
                while (cycleNumber < trajectory.length) {
                    this.relativeValuesX.get(i).add(new Double(trajectory[cycleNumber].getXValue()));
                    this.relativeValuesY.get(i).add(new Double(trajectory[cycleNumber].getYValue()));
                    ++cycleNumber;
                }
            } else {
                this.resetData();
            }
            ++i;
        }
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public final Chart createLyapunovTrajectoryChart(List<List<Double>> relativeValuesX, List<List<Double>> relativeValuesY, String seriesIdentifier) {
        ChartWithAxes retValue = ChartWithAxesImpl.create();
        String defaultAxisLabel_X = "S";
        String defaultAxisLabel_Y = "I";
        retValue.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Plot p = retValue.getPlot();
        p.getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        retValue.getTitle().setVisible(false);
        Legend lg = retValue.getLegend();
        lg.setVisible(false);
        this.xAxisPrimary = retValue.getPrimaryBaseAxes()[0];
        this.xAxisPrimary.setType(AxisType.LINEAR_LITERAL);
        this.xAxisPrimary.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.xAxisPrimary.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxisPrimary.getTitle().getCaption().getFont().setSize(8.0f);
        String xAxisLabel = defaultAxisLabel_X;
        this.xAxisPrimary.getTitle().getCaption().setValue(xAxisLabel);
        this.xAxisPrimary.getTitle().setVisible(true);
        this.yAxisPrimary = retValue.getPrimaryOrthogonalAxis(this.xAxisPrimary);
        this.yAxisPrimary.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.yAxisPrimary.getTitle().getCaption().getFont().setSize(8.0f);
        String yAxisLabel = defaultAxisLabel_Y;
        this.yAxisPrimary.getTitle().getCaption().setValue(yAxisLabel);
        this.yAxisPrimary.getTitle().setVisible(true);
        int MAXCOLORS = this.lineColors.length;
        int i = 0;
        while (i < relativeValuesX.size()) {
            NumberDataSet orthoValuesX = NumberDataSetImpl.create(relativeValuesX.get(i));
            NumberDataSet orthoValuesY = NumberDataSetImpl.create(relativeValuesY.get(i));
            Series lsx = SeriesImpl.create();
            lsx.setDataSet((DataSet)orthoValuesX);
            ScatterSeries lsy = (ScatterSeries)ScatterSeriesImpl.create();
            lsy.setDataSet((DataSet)orthoValuesY);
            lsy.getLineAttributes().setVisible(true);
            int colorIndex = i % MAXCOLORS;
            lsy.getLineAttributes().setColor(this.lineColors[colorIndex]);
            lsy.setPaletteLineColor(false);
            lsy.setSeriesIdentifier((Object)seriesIdentifier);
            lsy.getMarkers().clear();
            SeriesDefinition sdX = SeriesDefinitionImpl.create();
            SeriesDefinition sdY = SeriesDefinitionImpl.create();
            sdY.getSeriesPalette().update(-2);
            this.xAxisPrimary.getSeriesDefinitions().add((Object)sdX);
            this.yAxisPrimary.getSeriesDefinitions().add((Object)sdY);
            sdX.getSeries().add((Object)lsx);
            sdY.getSeries().add((Object)lsy);
            ++i;
        }
        this.xAxisPrimary.setCategoryAxis(false);
        this.xAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.xAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.xAxisPrimary.getScale().setStep(0.25);
        this.xAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        this.yAxisPrimary.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxisPrimary.getScale().setMax((DataElement)NumberDataElementImpl.create((double)1.0));
        this.yAxisPrimary.getScale().setStep(0.25);
        this.yAxisPrimary.getLabel().getCaption().getFont().setSize(9.0f);
        return retValue;
    }

    public static void setColorDefs(List<LineSeries> lsList) {
        int i = 0;
        while (i < lsList.size()) {
            ColorDefinition color = ColorDefinitionImpl.BLUE();
            lsList.get(i).setPaletteLineColor(false);
            lsList.get(i).getLineAttributes().setColor(color);
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void reset() {
        this.resetData();
        this.redraw();
    }

    protected void resetData() {
        this.clearData();
        int i = 0;
        while (i < this.relativeValuesX.size()) {
            this.relativeValuesX.get(i).add(new Double(1.0));
            this.relativeValuesY.get(i).add(new Double(0.0));
            ++i;
        }
    }

    private void clearData() {
        int i = 0;
        while (i < this.relativeValuesX.size()) {
            this.relativeValuesX.get(i).clear();
            this.relativeValuesY.get(i).clear();
            ++i;
        }
    }
}

