/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinkedStack<THIS extends AbstractLinkedStack<?, ELEMENT>, ELEMENT>
implements Iterable<ELEMENT> {
    protected Element<ELEMENT> top = null;

    public THIS clone() {
        THIS result = this.createStack();
        this.init(result);
        return result;
    }

    public THIS cloneAndPop() {
        Object stack = this.clone();
        ((AbstractLinkedStack)stack).pop();
        return (THIS)stack;
    }

    public THIS cloneAndPush(ELEMENT element) {
        Object stack = this.clone();
        ((AbstractLinkedStack)stack).push(element);
        return (THIS)stack;
    }

    public boolean contains(ELEMENT value) {
        Element<Object> t = this.top;
        while (t != null) {
            if (t.value == value) {
                return true;
            }
            t = t.parent;
        }
        return false;
    }

    protected Element<ELEMENT> createElement(Element<ELEMENT> parent, ELEMENT value) {
        return new Element<ELEMENT>(parent, value);
    }

    protected abstract THIS createStack();

    public String elementToStr(ELEMENT value) {
        return value == null ? "null" : value.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractLinkedStack)) {
            return false;
        }
        Element<Object> t1 = this.top;
        Element<Object> t2 = ((AbstractLinkedStack)obj).top;
        while (t1 != null || t2 != null) {
            if (t1 == null || t2 == null || t1.value != t2.value) {
                return false;
            }
            t1 = t1.parent;
            t2 = t2.parent;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        Element<Object> t = this.top;
        while (t != null) {
            hashCode = 31 * hashCode + (t.value == null ? 0 : t.value.hashCode());
            t = t.parent;
        }
        return hashCode;
    }

    protected void init(THIS result) {
        ((AbstractLinkedStack)result).top = this.top;
    }

    public boolean isEmpty() {
        return this.top == null;
    }

    @Override
    public Iterator<ELEMENT> iterator() {
        return new ElementIterator(this.top);
    }

    public ELEMENT peek() {
        return this.top != null ? (ELEMENT)this.top.value : null;
    }

    public ELEMENT pop() {
        if (this.top != null) {
            Object result = this.top.value;
            this.top = this.top.parent;
            return (ELEMENT)result;
        }
        return null;
    }

    public void push(ELEMENT value) {
        this.top = this.createElement(this.top, value);
    }

    public String toString() {
        ArrayList values = Lists.newArrayList();
        Element<Object> t = this.top;
        while (t != null) {
            values.add(this.elementToStr(t.value));
            t = t.parent;
        }
        return ((Object)values).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Element<T> {
        protected Element<T> parent;
        protected T value;

        public Element(Element<T> parent, T value) {
            this.parent = parent;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ElementIterator
    implements Iterator<ELEMENT> {
        private Element<ELEMENT> ele;

        public ElementIterator(Element<ELEMENT> ele) {
            this.ele = ele;
        }

        @Override
        public boolean hasNext() {
            return this.ele != null;
        }

        @Override
        public ELEMENT next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Element prev = this.ele;
            this.ele = this.ele.parent;
            return prev.value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

