/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.product.ConfigurationSection;
import org.eclipse.pde.internal.ui.editor.product.PluginConfigurationSection;
import org.eclipse.pde.internal.ui.editor.product.ProductEditor;
import org.eclipse.pde.internal.ui.editor.product.PropertiesSection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class ConfigurationPage
extends PDEFormPage {
    public static final String PLUGIN_ID = "plugin-configuration";

    public ConfigurationPage(ProductEditor editor, boolean useFeatures) {
        super(editor, PLUGIN_ID, PDEUIMessages.ConfigurationPageMock_pageTitle);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FEATURE_OBJ));
        form.setText(PDEUIMessages.ConfigurationPageMock_pageTitle);
        this.fillBody(managedForm, toolkit);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.configuration_page");
    }

    private void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormGridLayout(false, 2));
        managedForm.addPart((IFormPart)new ConfigurationSection(this, body));
        if (TargetPlatformHelper.getTargetVersion() > 3.4) {
            managedForm.addPart((IFormPart)new PluginConfigurationSection(this, body));
        }
        managedForm.addPart((IFormPart)new PropertiesSection(this, body));
    }
}

