/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor;

import java.io.IOException;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.metamodel.provider.MetamodelItemProviderAdapterFactory;
import org.eclipse.stem.model.transform.MetamodelRegenerateValidator;
import org.eclipse.stem.model.ui.editor.ModelDiagramEditorContextMenuProvider;
import org.eclipse.stem.model.ui.editor.VisualModelLoader;
import org.eclipse.stem.model.ui.editor.actions.RunModelGeneratorAction;
import org.eclipse.stem.model.ui.editor.commands.emf.DelegatingCommandStack;
import org.eclipse.stem.model.ui.editor.commands.emf.EmfCommandWrapper;
import org.eclipse.stem.model.ui.editor.controls.VisualEditorComposite;
import org.eclipse.stem.model.ui.editor.parts.ModelDiagramEditPartFactory;
import org.eclipse.stem.model.ui.editor.vismodel.CanvasPackage;
import org.eclipse.stem.model.ui.editor.vismodel.ModelElement;
import org.eclipse.stem.model.ui.editor.vismodel.provider.VisualMetamodelItemProviderAdapterFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.IPageSite;

public class ModelDiagramEditor
extends GraphicalEditor
implements IGotoMarker,
CommandStackListener {
    private VisualModelLoader loader;
    private CanvasPackage vismodel;
    private Package metamodel;
    private ModelElement diagramElement;
    private List<ISelectionListener> modelListeners = new CopyOnWriteArrayList<ISelectionListener>();
    private VisualEditorComposite editorComposite;
    private CommandStackListener emfCommandStackAdapter = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            Object o = event.getSource();
            if (o instanceof BasicCommandStack) {
                Command lastCommand = ((BasicCommandStack)o).getMostRecentCommand();
                ModelDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)new EmfCommandWrapper(lastCommand));
            }
        }
    };
    EditingDomain metamodelEditingDomain;

    public ModelDiagramEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new ModelDiagramEditPartFactory());
        viewer.setRootEditPart((RootEditPart)new ScalableFreeformRootEditPart());
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
        ModelDiagramEditorContextMenuProvider cmProvider = new ModelDiagramEditorContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu((MenuManager)cmProvider, (ISelectionProvider)viewer);
        if (this.diagramElement != null) {
            viewer.setContents((Object)this.diagramElement);
        }
    }

    public DefaultEditDomain getEditingDomain() {
        return this.getEditDomain();
    }

    public CommandStack getCommandStack() {
        return super.getCommandStack();
    }

    protected void initializeGraphicalViewer() {
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected IFile getInputFile() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask("Saving Models", 10);
        try {
            try {
                if (this.loader != null) {
                    this.loader.save();
                    monitor.worked(1);
                    this.getCommandStack().markSaveLocation();
                    monitor.worked(1);
                    IEditorInput input = this.getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        ((IFileEditorInput)input).getFile().getProject().build(10, "org.eclipse.stem.model.builder.MetamodelBuilder", Collections.emptyMap(), (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                    }
                }
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                monitor.done();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public EditingDomain getMetamodelEditingDomain() {
        return this.metamodelEditingDomain;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.loader != null) {
            this.loader.destroy();
            this.metamodelEditingDomain.getCommandStack().removeCommandStackListener(this.emfCommandStackAdapter);
            this.loader = null;
        }
        try {
            this.loader = new VisualModelLoader((IFileEditorInput)input);
            this.loader.load();
            this.metamodel = this.loader.getMetamodel();
            this.vismodel = this.loader.getVisualModel();
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            adapterFactory.addAdapterFactory((AdapterFactory)new VisualMetamodelItemProviderAdapterFactory());
            adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
            adapterFactory.addAdapterFactory((AdapterFactory)new MetamodelItemProviderAdapterFactory());
            adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
            this.metamodelEditingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (org.eclipse.emf.common.command.CommandStack)new DelegatingCommandStack(this.getCommandStack()), this.metamodel.eResource().getResourceSet());
            this.metamodelEditingDomain.getCommandStack().addCommandStackListener(this.emfCommandStackAdapter);
            this.setPartName(this.metamodel.getName());
        }
        catch (VisualModelLoader.ModelLoadException mle) {
            mle.printStackTrace();
        }
    }

    public void reload() {
        ModelElement prevSelectedModel = this.diagramElement;
        this.setInput(this.getEditorInput());
        if (this.editorComposite != null) {
            this.editorComposite.inputChanged();
        }
        if (this.vismodel != null && this.vismodel.getModelElements().size() > 0) {
            if (prevSelectedModel != null) {
                for (ModelElement currentModel : this.vismodel.getModelElements()) {
                    Model m1 = currentModel.getModel();
                    Model m2 = prevSelectedModel.getModel();
                    if (m1 == null || m2 == null || !m1.getName().equals(m2.getName())) continue;
                    this.setDiagramElement(currentModel);
                }
            }
            this.setDiagramElement((ModelElement)this.vismodel.getModelElements().get(0));
        } else {
            this.setDiagramElement(null);
        }
    }

    public void createPartControl(Composite parent) {
        this.editorComposite = new VisualEditorComposite(this, parent, 0);
        super.createPartControl((Composite)this.editorComposite.getCanvasComposite());
    }

    public CanvasPackage getVisualModel() {
        return this.vismodel;
    }

    public Package getMetamodel() {
        return this.metamodel;
    }

    public void setDiagramElement(ModelElement me) {
        this.diagramElement = me;
        if (this.getGraphicalViewer() != null) {
            this.getGraphicalViewer().setContents((Object)this.diagramElement);
        }
        this.fireModelSelected();
    }

    public void setSelection(ISelection selection) {
    }

    public void addModelSelectionListener(ISelectionListener listener) {
        this.modelListeners.add(listener);
    }

    public void removeModelSelectionListener(ISelectionListener listener) {
        this.modelListeners.remove(listener);
    }

    private void fireModelSelected() {
        StructuredSelection selection = new StructuredSelection((Object)this.diagramElement);
        for (ISelectionListener listener : this.modelListeners) {
            listener.selectionChanged((IWorkbenchPart)this, (ISelection)selection);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
    }

    public void gotoMarker(IMarker marker) {
        try {
            String markerType = marker.getType();
            if ("org.eclipse.stem.model.builder.ModelNeedsRegenerationErrorMarker".equals(markerType)) {
                RunModelGeneratorAction action = new RunModelGeneratorAction(this);
                action.run();
            }
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
    }

    public boolean needsModelRegeneration(IProgressMonitor monitor) throws CoreException, IOException {
        IFile metamodelFile = this.getInputFile();
        if (metamodelFile != null) {
            MetamodelRegenerateValidator regenValidator = new MetamodelRegenerateValidator(this.metamodel, metamodelFile);
            return regenValidator.checkNeedRegeneration(monitor);
        }
        return false;
    }

    public class ModelDiagramOutlinePage
    extends ContentOutlinePage {
        public ModelDiagramOutlinePage(EditPartViewer viewer) {
            super(viewer);
        }

        public void createControl(Composite parent) {
            this.getViewer().createControl(parent);
            this.getViewer().setEditDomain((EditDomain)ModelDiagramEditor.this.getEditDomain());
            ModelDiagramEditor.this.getSelectionSynchronizer().addViewer(this.getViewer());
        }

        public void dispose() {
            ModelDiagramEditor.this.getSelectionSynchronizer().removeViewer(this.getViewer());
            super.dispose();
        }

        public Control getControl() {
            return this.getViewer().getControl();
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
        }
    }
}

