/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute.impl;

import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.util.ULocale;
import java.util.Locale;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.AttributePackage;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.impl.FormatSpecifierImpl;
import org.eclipse.birt.chart.util.NumberUtil;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class NumberFormatSpecifierImpl
extends FormatSpecifierImpl
implements NumberFormatSpecifier {
    protected static final String PREFIX_EDEFAULT = null;
    protected String prefix = PREFIX_EDEFAULT;
    protected static final String SUFFIX_EDEFAULT = null;
    protected String suffix = SUFFIX_EDEFAULT;
    protected static final double MULTIPLIER_EDEFAULT = 0.0;
    protected double multiplier = 0.0;
    protected boolean multiplierESet;
    protected static final int FRACTION_DIGITS_EDEFAULT = 0;
    protected int fractionDigits = 0;
    protected boolean fractionDigitsESet;

    protected NumberFormatSpecifierImpl() {
    }

    protected EClass eStaticClass() {
        return AttributePackage.Literals.NUMBER_FORMAT_SPECIFIER;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String newPrefix) {
        String oldPrefix = this.prefix;
        this.prefix = newPrefix;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldPrefix, (Object)this.prefix));
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String newSuffix) {
        String oldSuffix = this.suffix;
        this.suffix = newSuffix;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldSuffix, (Object)this.suffix));
        }
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(double newMultiplier) {
        double oldMultiplier = this.multiplier;
        this.multiplier = newMultiplier;
        boolean oldMultiplierESet = this.multiplierESet;
        this.multiplierESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldMultiplier, this.multiplier, !oldMultiplierESet));
        }
    }

    public void unsetMultiplier() {
        double oldMultiplier = this.multiplier;
        boolean oldMultiplierESet = this.multiplierESet;
        this.multiplier = 0.0;
        this.multiplierESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 2, oldMultiplier, 0.0, oldMultiplierESet));
        }
    }

    public boolean isSetMultiplier() {
        return this.multiplierESet;
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    public void setFractionDigits(int newFractionDigits) {
        int oldFractionDigits = this.fractionDigits;
        this.fractionDigits = newFractionDigits;
        boolean oldFractionDigitsESet = this.fractionDigitsESet;
        this.fractionDigitsESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldFractionDigits, this.fractionDigits, !oldFractionDigitsESet));
        }
    }

    public void unsetFractionDigits() {
        int oldFractionDigits = this.fractionDigits;
        boolean oldFractionDigitsESet = this.fractionDigitsESet;
        this.fractionDigits = 0;
        this.fractionDigitsESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 3, oldFractionDigits, 0, oldFractionDigitsESet));
        }
    }

    public boolean isSetFractionDigits() {
        return this.fractionDigitsESet;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getPrefix();
            }
            case 1: {
                return this.getSuffix();
            }
            case 2: {
                return this.getMultiplier();
            }
            case 3: {
                return this.getFractionDigits();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setPrefix((String)newValue);
                return;
            }
            case 1: {
                this.setSuffix((String)newValue);
                return;
            }
            case 2: {
                this.setMultiplier((Double)newValue);
                return;
            }
            case 3: {
                this.setFractionDigits((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setPrefix(PREFIX_EDEFAULT);
                return;
            }
            case 1: {
                this.setSuffix(SUFFIX_EDEFAULT);
                return;
            }
            case 2: {
                this.unsetMultiplier();
                return;
            }
            case 3: {
                this.unsetFractionDigits();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return PREFIX_EDEFAULT == null ? this.prefix != null : !PREFIX_EDEFAULT.equals(this.prefix);
            }
            case 1: {
                return SUFFIX_EDEFAULT == null ? this.suffix != null : !SUFFIX_EDEFAULT.equals(this.suffix);
            }
            case 2: {
                return this.isSetMultiplier();
            }
            case 3: {
                return this.isSetFractionDigits();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (prefix: ");
        result.append(this.prefix);
        result.append(", suffix: ");
        result.append(this.suffix);
        result.append(", multiplier: ");
        if (this.multiplierESet) {
            result.append(this.multiplier);
        } else {
            result.append("<unset>");
        }
        result.append(", fractionDigits: ");
        if (this.fractionDigitsESet) {
            result.append(this.fractionDigits);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public static NumberFormatSpecifier create() {
        NumberFormatSpecifier nfs = AttributeFactory.eINSTANCE.createNumberFormatSpecifier();
        nfs.setFractionDigits(2);
        return nfs;
    }

    public String format(double dValue, Locale lo) {
        return this.format(dValue, ULocale.forLocale((Locale)lo));
    }

    public String format(double dValue, ULocale lo) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance((ULocale)lo);
        if (this.isSetFractionDigits()) {
            df.setMinimumFractionDigits(this.getFractionDigits());
            df.setMaximumFractionDigits(this.getFractionDigits());
        }
        df.applyLocalizedPattern(df.toLocalizedPattern());
        StringBuffer sb = new StringBuffer();
        if (this.getPrefix() != null) {
            sb.append(this.getPrefix());
        }
        sb.append(this.isSetMultiplier() ? df.format(dValue * this.getMultiplier()) : df.format(dValue));
        if (this.getSuffix() != null) {
            sb.append(this.getSuffix());
        }
        return sb.toString();
    }

    public String format(Number number, ULocale lo) {
        String pattern;
        Number n = NumberUtil.transformNumber(number);
        if (n instanceof Double) {
            return this.format((double)((Double)number), lo);
        }
        BigDecimal bdNum = (BigDecimal)n;
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance((ULocale)lo);
        if (this.isSetFractionDigits()) {
            df.setMinimumFractionDigits(this.getFractionDigits());
            df.setMaximumFractionDigits(this.getFractionDigits());
        }
        if ((pattern = NumberUtil.adjustBigNumberFormatPattern(df.toLocalizedPattern())).indexOf(69) < 0) {
            pattern = String.valueOf(pattern) + "E0";
        }
        df.applyLocalizedPattern(pattern);
        StringBuffer sb = new StringBuffer();
        if (this.getPrefix() != null) {
            sb.append(this.getPrefix());
        }
        sb.append(this.isSetMultiplier() ? df.format(bdNum.multiply(BigDecimal.valueOf((double)this.getMultiplier()), NumberUtil.DEFAULT_MATHCONTEXT)) : df.format(bdNum));
        if (this.getSuffix() != null) {
            sb.append(this.getSuffix());
        }
        return sb.toString();
    }

    public NumberFormatSpecifier copyInstance() {
        NumberFormatSpecifierImpl dest = new NumberFormatSpecifierImpl();
        dest.set(this);
        return dest;
    }

    protected void set(NumberFormatSpecifier src) {
        super.set(src);
        this.prefix = src.getPrefix();
        this.suffix = src.getSuffix();
        this.multiplier = src.getMultiplier();
        this.multiplierESet = src.isSetMultiplier();
        this.fractionDigits = src.getFractionDigits();
        this.fractionDigitsESet = src.isSetFractionDigits();
    }
}

