/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.internal.ui.viewers.model.VirtualCopyToClipboardActionDelegate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class LaunchViewCopyToClipboardActionDelegate
extends VirtualCopyToClipboardActionDelegate {
    protected TreeItem[] getSelectedItems(TreeModelViewer clientViewer) {
        LaunchView view = (LaunchView)this.getView();
        if (view.isBreadcrumbVisible()) {
            IStructuredSelection selection = this.getSelection();
            if (selection instanceof ITreeSelection && this.getViewer() != null) {
                TreePath path = TreePath.EMPTY;
                if (!selection.isEmpty()) {
                    path = ((ITreeSelection)selection).getPaths()[0];
                }
                return this.getSelectedItemsInTreeViewer(this.getViewer(), path);
            }
            return new TreeItem[0];
        }
        TreeItem[] selection = clientViewer.getTree().getSelection();
        HashSet set = new HashSet();
        this.collectChildItems(set, selection);
        return set.toArray(new TreeItem[set.size()]);
    }

    private TreeItem[] getSelectedItemsInTreeViewer(TreeModelViewer viewer, TreePath path) {
        Widget item = viewer.findItem(path);
        HashSet<Widget> set = new HashSet<Widget>();
        if (item instanceof TreeItem) {
            set.add(item);
            if (((TreeItem)item).getExpanded()) {
                this.collectChildItems(set, ((TreeItem)item).getItems());
            }
        } else if (item instanceof Tree) {
            this.collectChildItems(set, ((Tree)item).getItems());
        }
        return set.toArray(new TreeItem[set.size()]);
    }

    private void collectChildItems(Set set, TreeItem[] items) {
        if (items == null) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            set.add(items[i]);
            if (items[i].getExpanded()) {
                this.collectChildItems(set, items[i].getItems());
            }
            ++i;
        }
    }
}

