/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryExtendedListener;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapter;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.ui.reports.views.IRemoveListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class ReportControl
extends Composite
implements RelativeValueHistoryExtendedListener,
ISimulationListener,
ISelectionProvider {
    protected RelativeValueHistoryProviderAdapter rvhp;
    protected static final String REMOVE_TEXT = "remove";
    protected static final String ADD_REFERENCE_TEXT = "Add Reference";
    protected Label simulationNameLabel;
    protected ISimulation simulation = null;
    protected Identifiable identifiable;
    protected Decorator selectedDecorator;
    protected DynamicLabel selectedDynamicLabel;
    protected Map<Decorator, List<DynamicLabel>> decoratorToLabelsMap;
    protected Button removeButton = null;
    protected Button addReferenceButton = null;
    protected Label addReferenceLabel = null;
    protected final List<ISelectionChangedListener> listeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    protected final List<IRemoveListener> removeListeners = new CopyOnWriteArrayList<IRemoveListener>();
    ISelection selection = null;
    protected Label identifiableTitle;
    protected static final int MARGIN_WIDTH = 5;
    protected static final int MARGIN_HEIGHT = 5;

    public ReportControl(Composite parent, int style) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ReportControl.this.dispose();
            }
        });
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.setLayout((Layout)layout);
    }

    protected Composite createTopComposite(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        FillLayout topCompositeLayout = new FillLayout(512);
        topComposite.setLayout((Layout)topCompositeLayout);
        this.simulationNameLabel = new Label(topComposite, 0x1000000);
        this.simulationNameLabel.setText("");
        return topComposite;
    }

    protected void switchToRVHP(RelativeValueHistoryProviderAdapter rvhp) {
        if (this.rvhp != null && this.rvhp != rvhp) {
            this.rvhp.removeExtensionListener((RelativeValueHistoryExtendedListener)this);
        }
        if (this.rvhp != rvhp && rvhp != null) {
            rvhp.addExtensionListener((RelativeValueHistoryExtendedListener)this);
        }
        this.rvhp = rvhp;
    }

    public abstract void remove();

    public void addIRemoveListener(IRemoveListener listener) {
        this.removeListeners.add(listener);
    }

    public void removeIRemoveListener(IRemoveListener listener) {
        this.removeListeners.remove(listener);
    }

    public void fireRemoveEvent(Identifiable ident) {
        for (IRemoveListener listener : this.removeListeners) {
            listener.identifiableRemoved(ident);
        }
    }

    public void setSimulation(ISimulation simulation) {
        if (this.simulation == simulation) {
            return;
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
        }
        this.simulation = simulation;
        this.selection = null;
        if (this.simulation != null) {
            this.simulation.addSimulationListener((ISimulationListener)this);
            this.initializeFromSimulation(this.simulation);
        } else {
            this.initializeFromSimulation(null);
        }
        this.refresh2();
    }

    protected abstract void initializeFromSimulation(ISimulation var1);

    protected abstract void refresh2();

    public final ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        this.fireSelection(selection);
    }

    public abstract void setIdentifiable(Identifiable var1);

    public abstract Identifiable getIdentifiable();

    public void fireSelection(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(event);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public abstract String getControlType();
}

