/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.resource;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.resource.DeleteResourcesProcessor;

public class DeleteResourcesDescriptor
extends RefactoringDescriptor {
    public static final String ID = "org.eclipse.ltk.core.refactoring.delete.resources";
    private IPath[] fResourcePaths;
    private boolean fDeleteContents = false;

    public DeleteResourcesDescriptor() {
        super(ID, null, RefactoringCoreMessages.RenameResourceDescriptor_unnamed_descriptor, null, 6);
    }

    public IPath[] getResourcePaths() {
        return this.fResourcePaths;
    }

    public void setResourcePaths(IPath[] resourcePath) {
        if (resourcePath == null) {
            throw new IllegalArgumentException();
        }
        this.fResourcePaths = resourcePath;
    }

    public void setResources(IResource[] resources) {
        if (resources == null) {
            throw new IllegalArgumentException();
        }
        IPath[] paths = new IPath[resources.length];
        int i = 0;
        while (i < paths.length) {
            paths[i] = resources[i].getFullPath();
            ++i;
        }
        this.setResourcePaths(paths);
    }

    public boolean isDeleteContents() {
        return this.fDeleteContents;
    }

    public void setDeleteContents(boolean deleteContents) {
        this.fDeleteContents = deleteContents;
    }

    public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource[] resources = new IResource[this.fResourcePaths.length];
        int i = 0;
        while (i < this.fResourcePaths.length) {
            IResource resource = wsRoot.findMember(this.fResourcePaths[i]);
            if (resource == null || !resource.exists()) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.DeleteResourcesDescriptor_error_delete_not_exists, BasicElementLabels.getPathLabel(this.fResourcePaths[i], false)));
                return null;
            }
            resources[i] = resource;
            ++i;
        }
        DeleteResourcesProcessor processor = new DeleteResourcesProcessor(resources, this.fDeleteContents);
        return new DeleteRefactoring(processor);
    }
}

