/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.externaldatasource.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.stem.analysis.LogInitializationException;
import org.eclipse.stem.analysis.util.CSVScenarioStreamer;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.diseasemodels.Activator;
import org.eclipse.stem.diseasemodels.externaldatasource.ExternalDataSourceDiseaseModel;
import org.eclipse.stem.diseasemodels.externaldatasource.ExternalDataSourcePackage;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.Infector;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.impl.SEIRLabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SILabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.impl.StandardDiseaseModelImpl;
import org.eclipse.stem.diseasemodels.standard.provider.StandardItemProviderAdapterFactory;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;

public class ExternalDataSourceDiseaseModelImpl
extends StandardDiseaseModelImpl
implements ExternalDataSourceDiseaseModel {
    protected static final String DATA_PATH_EDEFAULT = null;
    protected String dataPath = DATA_PATH_EDEFAULT;
    protected static final String DISEASE_TYPE_EDEFAULT = null;
    public static final String LOCATIONID_PREFIX = "/node/geo/region/";
    public String dirName = DEFAULT_DIR;
    private double fileLineCounter = 0.0;
    protected Set<String> S_KEY_SET = new HashSet<String>();
    protected Set<String> E_KEY_SET = new HashSet<String>();
    protected Set<String> I_KEY_SET = new HashSet<String>();
    protected Set<String> R_KEY_SET = new HashSet<String>();
    protected Set<String> INCIDENCE_KEY_SET = new HashSet<String>();
    public static String labelS = null;
    public static String labelE = null;
    public static String labelI = null;
    public static String labelR = null;
    public static String labelIncidence = null;
    private String[] cumulativeStates = new String[]{"diseaseDeaths"};
    protected Map<String, List<IItemPropertyDescriptor>> propertyDescriptors;
    CSVScenarioStreamer streamer;
    private double totalPopulationCount = 0.0;
    private double totalArea = 0.0;
    private String diseaseType;
    protected static final int BUFFER_SIZE_EDEFAULT = 250;
    protected int bufferSize = 250;
    protected static final boolean RESTART_EDEFAULT = false;
    protected boolean restart = false;
    private Decorator diseaseModel;

    public EList<PopulationModelLabel> getPopulationModelLabels(String populationIdentifier, Graph graph) throws ScenarioInitializationException {
        BasicEList retValue = new BasicEList();
        this.setupStreaming();
        EList labels = graph.getNodeLabelsByTypeURI(PopulationModelLabel.URI_TYPE_DYNAMIC_POPULATION_LABEL);
        for (NodeLabel pl : labels) {
            PopulationModelLabel populationLabel = (PopulationModelLabel)pl;
            boolean keep = false;
            if (this.streamer.getDecorator() != null) {
                for (String loggedPopulation : this.streamer.getPopulationIdentifiers()) {
                    if (!populationLabel.getPopulationIdentifier().equals(loggedPopulation)) continue;
                    keep = true;
                }
            } else if (populationLabel.getPopulationIdentifier().equals(populationIdentifier)) {
                keep = true;
            }
            if (!keep || populationLabel.getNode() == null) continue;
            retValue.add((Object)populationLabel);
        }
        return retValue;
    }

    public void resetLabels() throws ScenarioInitializationException {
        super.resetLabels();
        try {
            if (this.streamer != null) {
                this.streamer.close();
            }
        }
        catch (IOException ioe) {
            throw new ScenarioInitializationException("IOException closing streamer", (Identifiable)this, (Exception)ioe);
        }
        this.streamer = null;
        this.fileLineCounter = 0.0;
        this.setupStreaming();
        for (StandardDiseaseModelLabel diseaseLabel : this.getLabelsToUpdate()) {
            StandardDiseaseModelLabelValue deltaState = (StandardDiseaseModelLabelValue)diseaseLabel.getDeltaValue();
            this.importDiseaseData(deltaState, diseaseLabel, null, 0L);
            ((StandardDiseaseModelLabelValue)diseaseLabel.getCurrentValue()).add((IntegrationLabelValue)deltaState);
        }
    }

    private void setPropertyLabels() {
        StandardItemProviderAdapterFactory itemProviderFactory = new StandardItemProviderAdapterFactory();
        if (this.diseaseModel == null) {
            SEIRLabelValue diseaseLabel = (SEIRLabelValue)StandardFactory.eINSTANCE.createSEIRLabel().getCurrentValue();
            IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)diseaseLabel, PropertySource.class);
            List properties = propertySource.getPropertyDescriptors(null);
            IItemPropertyDescriptor propertyS = (IItemPropertyDescriptor)properties.get(3);
            IItemPropertyDescriptor propertyE = (IItemPropertyDescriptor)properties.get(8);
            IItemPropertyDescriptor propertyI = (IItemPropertyDescriptor)properties.get(6);
            IItemPropertyDescriptor propertyR = (IItemPropertyDescriptor)properties.get(7);
            IItemPropertyDescriptor propertyIncidence = (IItemPropertyDescriptor)properties.get(4);
            labelS = propertyS.getDisplayName((Object)propertyS);
            labelE = propertyE.getDisplayName((Object)propertyE);
            labelI = propertyI.getDisplayName((Object)propertyI);
            labelR = propertyR.getDisplayName((Object)propertyR);
            labelIncidence = propertyIncidence.getDisplayName((Object)propertyIncidence);
        } else {
            DiseaseModel dm = (DiseaseModel)this.diseaseModel;
            for (String popId : this.streamer.getPopulationIdentifiers()) {
                DiseaseModelLabel dml = dm.createDiseaseModelLabel(popId);
                RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dml, RelativeValueProvider.class);
                rvp.setTarget((Notifier)dml);
                List properties = rvp.getProperties();
                if (this.propertyDescriptors == null) {
                    this.propertyDescriptors = new HashMap<String, List<IItemPropertyDescriptor>>();
                }
                this.propertyDescriptors.put(popId, properties);
            }
        }
    }

    private synchronized void setupStreaming() {
        if (this.streamer == null) {
            try {
                this.streamer = new CSVScenarioStreamer(this.dataPath, this.getBufferSize(), this.isRestart(), this.cumulativeStates);
                this.diseaseModel = this.streamer.getDecorator();
                if (this.diseaseModel == null) {
                    this.streamer.prepareForStreaming("", -1);
                    this.diseaseType = this.streamer.getType("").name();
                    this.S_KEY_SET = CSVscenarioLoader.getsKeySet();
                    this.E_KEY_SET = CSVscenarioLoader.geteKeySet();
                    this.I_KEY_SET = CSVscenarioLoader.getiKeySet();
                    this.R_KEY_SET = CSVscenarioLoader.getrKeySet();
                    this.INCIDENCE_KEY_SET = CSVscenarioLoader.getIncidenceKeySet();
                } else {
                    for (String pop : this.streamer.getPopulationIdentifiers()) {
                        this.streamer.prepareForStreaming(pop, -1);
                    }
                }
            }
            catch (LogInitializationException sie) {
                Activator.logError((String)"Error reading scenario files", (Throwable)sie);
            }
            catch (IOException ioe) {
                Activator.logError((String)"IOExceptopn reading scenario files", (Throwable)ioe);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public StandardDiseaseModelLabelValue importDiseaseData(StandardDiseaseModelLabelValue deltaState, StandardDiseaseModelLabel diseaseLabel, STEMTime time, long timeDelta) {
        try {
            String location;
            Identifiable ident;
            String fileName;
            this.setupStreaming();
            if (labelS == null && this.propertyDescriptors == null) {
                this.setPropertyLabels();
            }
            if ((fileName = (ident = diseaseLabel.getIdentifiable()).getURI().toString()).contains(LOCATIONID_PREFIX)) {
                int last = fileName.lastIndexOf(LOCATIONID_PREFIX);
                location = fileName.substring(last += LOCATIONID_PREFIX.length(), fileName.length());
            } else {
                location = fileName;
            }
            int adminLevel = Utility.keyLevel((String)location);
            String population = diseaseLabel.getPopulationModelLabel().getPopulationIdentifier();
            StandardDiseaseModelLabelValue currentValue = (StandardDiseaseModelLabelValue)diseaseLabel.getCurrentValue();
            if (adminLevel > -1) {
                if (this.streamer.getDecorator() == null) {
                    double deltaS = 0.0;
                    double deltaE = 0.0;
                    double deltaI = 0.0;
                    double deltaR = 0.0;
                    double incidence = 0.0;
                    population = "";
                    List<Double> result = null;
                    int pos = this.streamer.getDataPosition(population, adminLevel, location);
                    if (pos == -1) {
                        return null;
                    }
                    result = this.streamData(population, adminLevel, labelS);
                    double d = result.get(pos);
                    deltaS = d - currentValue.getS();
                    result = this.streamData(population, adminLevel, labelIncidence);
                    d = result.get(pos);
                    incidence = d - currentValue.getIncidence();
                    if (this.diseaseType.equals("SEIR")) {
                        result = this.streamData(population, adminLevel, labelE);
                        d = result.get(pos);
                        deltaE = d - ((SEIRLabelValue)currentValue).getE();
                    }
                    this.I_KEY_SET.size();
                    if (this.I_KEY_SET != null) {
                        Iterator<String> iter = this.I_KEY_SET.iterator();
                        double dI = 0.0;
                        while (iter.hasNext()) {
                            String iKey = iter.next();
                            result = this.streamData(population, adminLevel, iKey);
                            d = result.get(pos);
                            dI += d;
                        }
                        deltaI = dI - ((SILabelValue)currentValue).getI();
                    } else {
                        Activator.logInformation((String)"I Keys are all Null !!");
                    }
                    if (this.diseaseType.equals("SIR") || this.diseaseType.equals("SEIR")) {
                        result = this.streamData(population, adminLevel, labelR);
                        d = result.get(pos);
                        deltaR = d - ((SIRLabelValue)currentValue).getR();
                    }
                    if (this.diseaseType.equals("SI")) {
                        ((SILabelValue)deltaState).setS(deltaS);
                        ((SILabelValue)deltaState).setI(deltaI);
                        ((SILabelValue)deltaState).setIncidence(incidence);
                        return new SILabelValueImpl(0.0, 0.0, 0.0, 0.0);
                    }
                    if (this.diseaseType.equals("SIR")) {
                        ((SIRLabelValue)deltaState).setS(deltaS);
                        ((SIRLabelValue)deltaState).setI(deltaI);
                        ((SIRLabelValue)deltaState).setR(deltaR);
                        ((SIRLabelValue)deltaState).setIncidence(incidence);
                        return new SIRLabelValueImpl(0.0, 0.0, 0.0, 0.0, 0.0);
                    }
                    if (this.diseaseType.equals("SEIR")) {
                        ((SEIRLabelValue)deltaState).setS(deltaS);
                        ((SEIRLabelValue)deltaState).setE(deltaE);
                        ((SEIRLabelValue)deltaState).setI(deltaI);
                        ((SEIRLabelValue)deltaState).setR(deltaR);
                        ((SEIRLabelValue)deltaState).setIncidence(incidence);
                        return new SEIRLabelValueImpl(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                    }
                    throw new UnsupportedOperationException("ExternalDataSource Invalid Type " + this.diseaseType + " must be SI, SIR, or SEIR");
                }
                List<Double> result = null;
                for (IItemPropertyDescriptor propDesc : this.propertyDescriptors.get(population)) {
                    String dispName = propDesc.getDisplayName((Object)propDesc);
                    int pos = this.streamer.getDataPosition(population, adminLevel, location);
                    result = this.streamData(population, adminLevel, dispName);
                    double d = result.get(pos);
                    if (pos < 0) continue;
                    EStructuralFeature feature = (EStructuralFeature)propDesc.getFeature(null);
                    double currentVal = (Double)currentValue.eGet(feature);
                    if (feature.isDerived() || !feature.isChangeable()) continue;
                    deltaState.eSet(feature, (Object)(d - currentVal));
                }
            }
        }
        catch (IOException ioe) {
            Activator.logError((String)"Exception streaming data", (Throwable)ioe);
        }
        return null;
    }

    private List<Double> streamData(String population, int adminLevel, String compartment) throws IOException {
        double fraction = this.fileLineCounter - Math.floor(this.fileLineCounter);
        ArrayList<Double> result = new ArrayList<Double>();
        int row = (int)this.fileLineCounter;
        while ((double)this.streamer.getCurrentRow(population, adminLevel, compartment) <= this.fileLineCounter) {
            this.streamer.streamRow(population, adminLevel, compartment);
        }
        List data1 = this.streamer.getNthFetchedRow(population, adminLevel, compartment, row);
        List data2 = this.streamer.getNthFetchedRow(population, adminLevel, compartment, row + 1);
        int n = 0;
        while (n < data1.size()) {
            result.add(this.interpolate((Double)data1.get(n), (Double)data2.get(n), fraction));
            ++n;
        }
        return result;
    }

    private double interpolate(Double double1, Double double2, double fraction) {
        if (double1 == null) {
            return double2;
        }
        return double1 + fraction * (double2 - double1);
    }

    private double interpolateAggregate(Double double1, Double double2, double fraction) {
        return double1 - (1.0 - fraction) * double2;
    }

    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        if (this.streamer.getDecorator() == null) {
            if (this.diseaseType == "SI") {
                return StandardFactory.eINSTANCE.createSILabel();
            }
            if (this.diseaseType == "SIR") {
                return StandardFactory.eINSTANCE.createSIRLabel();
            }
            return StandardFactory.eINSTANCE.createSEIRLabel();
        }
        return ((DiseaseModel)this.streamer.getDecorator()).createDiseaseModelLabel(populationIdentifier);
    }

    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        if (this.streamer.getDecorator() == null) {
            if (this.diseaseType == "SI") {
                return StandardFactory.eINSTANCE.createSILabelValue();
            }
            if (this.diseaseType == "SIR") {
                return StandardFactory.eINSTANCE.createSIRLabelValue();
            }
            return StandardFactory.eINSTANCE.createSEIRLabelValue();
        }
        return ((DiseaseModel)this.streamer.getDecorator()).createDiseaseModelLabelValue(populationIdentifier);
    }

    public Infector createInfector() {
        throw new UnsupportedOperationException();
    }

    public void addToTotalArea(double area) {
        this.totalArea += area;
    }

    public void addToTotalPopulationCount(double populationCount) {
        this.totalPopulationCount += populationCount;
    }

    public double getArea(PopulationLabel populationLabel) {
        double retValue = 0.0;
        retValue = populationLabel.getPopulatedArea();
        if (retValue == 0.0) {
            for (NodeLabel nodeLabel : populationLabel.getNode().getLabels()) {
                if (!(nodeLabel instanceof AreaLabel)) continue;
                AreaLabel areaLabel = (AreaLabel)nodeLabel;
                retValue = areaLabel.getCurrentAreaValue().getArea();
                break;
            }
        }
        return retValue;
    }

    private void reportBadAreaValue(PopulationLabel populationLabel, double area) {
        if (populationLabel.getPopulatedArea() == 0.0) {
            Activator.logError((String)("The area value of \"" + area + "\" specified for \"" + populationLabel.getNode().toString() + "\" is not greater than zero (0.0)"), null);
        } else {
            Activator.logError((String)("The area value of \"" + area + "\" specified for the population \"" + populationLabel.getPopulationIdentifier() + "\" for the region \"" + populationLabel.getNode().toString() + "\" is not greater than zero (0.0)"), null);
        }
    }

    public EList<String> getAllLabelIdentifiers() {
        List popIds = this.streamer.getPopulationIdentifiers();
        BasicEList identifiers = new BasicEList();
        if (popIds != null) {
            for (String pop : popIds) {
                identifiers.add((Object)pop);
            }
        } else {
            identifiers.add((Object)this.getPopulationIdentifier());
        }
        return identifiers;
    }

    protected EClass eStaticClass() {
        return ExternalDataSourcePackage.Literals.EXTERNAL_DATA_SOURCE_DISEASE_MODEL;
    }

    @Override
    public String getDataPath() {
        return this.dataPath;
    }

    @Override
    public void setDataPath(String newDataPath) {
        this.dataPath = newDataPath;
    }

    @Override
    public String getDiseaseType() {
        return this.diseaseType;
    }

    @Override
    public void setDiseaseType(String newDiseaseType) {
        this.diseaseType = newDiseaseType;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int newBufferSize) {
        this.bufferSize = newBufferSize;
    }

    @Override
    public boolean isRestart() {
        return this.restart;
    }

    @Override
    public void setRestart(boolean newRestart) {
        this.restart = newRestart;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 19: {
                return this.getDataPath();
            }
            case 20: {
                return this.getDiseaseType();
            }
            case 21: {
                return this.getBufferSize();
            }
            case 22: {
                return this.isRestart();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 19: {
                this.setDataPath((String)newValue);
                return;
            }
            case 20: {
                this.setDiseaseType((String)newValue);
                return;
            }
            case 21: {
                this.setBufferSize((Integer)newValue);
                return;
            }
            case 22: {
                this.setRestart((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 19: {
                this.setDataPath(DATA_PATH_EDEFAULT);
                return;
            }
            case 20: {
                this.setDiseaseType(DISEASE_TYPE_EDEFAULT);
                return;
            }
            case 21: {
                this.setBufferSize(250);
                return;
            }
            case 22: {
                this.setRestart(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 19: {
                return DATA_PATH_EDEFAULT == null ? this.dataPath != null : !DATA_PATH_EDEFAULT.equals(this.dataPath);
            }
            case 20: {
                return DISEASE_TYPE_EDEFAULT == null ? this.diseaseType != null : !DISEASE_TYPE_EDEFAULT.equals(this.diseaseType);
            }
            case 21: {
                return this.bufferSize != 250;
            }
            case 22: {
                return this.restart;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (dataPath: ");
        result.append(this.dataPath);
        result.append(", diseaseType: ");
        result.append(this.diseaseType);
        result.append(", bufferSize: ");
        result.append(this.bufferSize);
        result.append(", restart: ");
        result.append(this.restart);
        result.append(')');
        return result.toString();
    }

    public void applyExternalDeltas(STEMTime time, long timeDelta, EList<DynamicLabel> labels) {
    }

    public synchronized void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double rowsPerSequencerStep = (double)timeDelta / (double)this.streamer.getTimeStepMS();
        this.fileLineCounter = t * rowsPerSequencerStep;
        for (DynamicLabel dynLabel : labels) {
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)dynLabel;
            StandardDiseaseModelLabelValue deltaState = (StandardDiseaseModelLabelValue)diseaseLabel.getDeltaValue();
            this.importDiseaseData(deltaState, diseaseLabel, time, timeDelta);
            this.computeAdditionalDeltasAndExchanges((IntegrationLabel)dynLabel, time, t, timeDelta);
        }
    }
}

