/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model.edit;

import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.validation.Issue;

public class IssueModificationContext
implements IModificationContext {
    @Inject
    private IURIEditorOpener editorOpener;
    private Issue issue;

    public void setIssue(Issue issue) {
        this.issue = issue;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public IXtextDocument getXtextDocument() {
        return this.getXtextDocument(this.issue.getUriToProblem());
    }

    public IXtextDocument getXtextDocument(URI uri) {
        IEditorPart editor = this.editorOpener.open(uri, false);
        if (editor instanceof XtextEditor) {
            XtextEditor xtextEditor = (XtextEditor)editor;
            return xtextEditor.getDocument();
        }
        return null;
    }

    @ImplementedBy(value=Default.class)
    public static interface Factory {
        public IModificationContext createModificationContext(Issue var1);

        public static class Default
        implements Factory {
            @Inject
            private Provider<IssueModificationContext> provider;

            public IModificationContext createModificationContext(Issue issue) {
                IssueModificationContext modificationContext = (IssueModificationContext)this.provider.get();
                modificationContext.setIssue(issue);
                return modificationContext;
            }
        }
    }
}

