/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.reconciler;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.reconciler.XtextReconcilerUnitOfWork;
import org.eclipse.xtext.ui.editor.reconciler.XtextSpellingReconcileStrategy;

public class XtextDocumentReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
ISourceViewerAware {
    private static final Logger log = Logger.getLogger(XtextDocumentReconcileStrategy.class);
    private XtextDocument document;
    @Inject
    private XtextSpellingReconcileStrategy.Factory spellingReconcileStrategyFactory;
    private XtextSpellingReconcileStrategy spellingReconcileStrategy;

    public void reconcile(IRegion region) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("reconcile region: " + region), (Throwable)new Exception());
        }
        this.document.internalModify(new XtextReconcilerUnitOfWork(region, this.document));
        if (this.spellingReconcileStrategy != null) {
            this.spellingReconcileStrategy.reconcile(region);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void setDocument(IDocument document) {
        if (!(document instanceof XtextDocument)) {
            throw new IllegalArgumentException("Document must be an " + XtextDocument.class.getSimpleName());
        }
        this.document = (XtextDocument)document;
        if (this.spellingReconcileStrategy != null) {
            this.spellingReconcileStrategy.setDocument(document);
        }
    }

    public void setSourceViewer(ISourceViewer sourceViewer) {
        this.spellingReconcileStrategy = this.spellingReconcileStrategyFactory.create(sourceViewer);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        if (this.spellingReconcileStrategy != null) {
            this.spellingReconcileStrategy.setProgressMonitor(monitor);
        }
    }

    public void initialReconcile() {
        if (this.spellingReconcileStrategy != null) {
            this.spellingReconcileStrategy.initialReconcile();
        }
    }
}

