/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.ui.reports.Activator;
import org.eclipse.stem.ui.reports.views.IRemoveListener;
import org.eclipse.stem.ui.reports.views.ReportControl;
import org.eclipse.stem.ui.reports.views.ReportControlFactory;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ReportViewer
extends Viewer
implements ISelectionChangedListener,
ISimulationManagerListener {
    private final Set<Identifiable> identifiablesToDisplay = new LinkedHashSet<Identifiable>();
    private SimulationManager simulationManager;
    private ISelection selection = null;
    final Composite composite;
    private DialogSettings masterSettings = null;
    private final Set<String> monitorSet = new HashSet<String>();
    private static final String ROOT_KEY = "root";
    public static final String REPORTVIEWPREFERENCES_FILENAME = "Preferences.txt";
    public static final String LOCATION_PREFERENCE_KEY = "location.ids";
    private static final IPath PATH = Activator.getDefault().getStateLocation();
    private final ReportControlFactory rcf;

    public ReportViewer(Composite parent, ReportControlFactory rcf) {
        this.composite = new Composite(parent, 0);
        FillLayout compositeLayout = new FillLayout(256);
        this.composite.setLayout((Layout)compositeLayout);
        this.rcf = rcf;
        this.refresh();
        this.composite.pack();
    }

    public Control getControl() {
        return this.composite;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void refresh() {
        if (this.simulationManager != null) {
            List allSimulations = null;
            List activeSimulations = this.simulationManager.getActiveSimulations();
            if (activeSimulations != null && activeSimulations.size() >= 1) {
                int i = 0;
                while (i < activeSimulations.size()) {
                    ISimulation sim = (ISimulation)activeSimulations.get(i);
                    this.updatePreferenceState(sim);
                    ++i;
                }
            }
            allSimulations = this.simulationManager.getActiveSimulations();
            this.addToDisplayedIdentifiableSet(allSimulations);
            this.identifiablesToDisplay.clear();
            this.identifiablesToDisplay.addAll(this.getIdentifiablesInSimulation(allSimulations));
        }
        if (this.rcf.getFactoryType().equals("IDENTIFIABLE_CONTROL_FACTORY")) {
            this.populateView();
        } else {
            this.populateView(null);
        }
    }

    public void addMonitor(Identifiable ident) {
        if (!(ident instanceof Node)) {
            return;
        }
        this.identifiablesToDisplay.add(ident);
        this.populateView();
        this.savePreferenceState();
        this.monitorSet.add(ident.getURI().toString());
    }

    public Object getInput() {
        return this.simulationManager;
    }

    public void setInput(Object input) {
        SimulationManager oldInput = this.simulationManager;
        this.simulationManager = (SimulationManager)input;
        this.inputChanged(input, oldInput);
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (oldInput != null) {
            ((SimulationManager)oldInput).removeListener((ISimulationManagerListener)this);
        }
        if (input != null) {
            ((SimulationManager)input).addSimulationManagerListener((ISimulationManagerListener)this);
        }
        this.refresh();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.selection = selection;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() instanceof ReportControl) {
            this.selection = event.getSelection();
            this.fireSelectionChanged(event);
        }
    }

    public void simulationsChanged(SimulationManagerEvent event) {
        this.removeFromDisplayedSimulationSet(Arrays.asList(event.getSimulationsRemoved()));
        List<ISimulation> newSimulationList = Arrays.asList(event.getSimulationsAdded());
        if (newSimulationList != null && newSimulationList.size() >= 1) {
            int i = 0;
            while (i < newSimulationList.size()) {
                ISimulation sim = newSimulationList.get(i);
                this.updatePreferenceState(sim);
                this.addToDisplayedIdentifiableSet(sim);
                this.populateView();
                this.populateView(sim);
                ++i;
            }
        }
    }

    private void addToDisplayedIdentifiableSet(List<ISimulation> simulations) {
        if (!simulations.isEmpty()) {
            this.identifiablesToDisplay.addAll(this.getIdentifiablesInSimulation(simulations));
        }
    }

    private void addToDisplayedIdentifiableSet(ISimulation sim) {
        this.identifiablesToDisplay.addAll(this.getIdentifiablesInSimulation(sim));
    }

    private void removeFromDisplayedSimulationSet(List<ISimulation> simulations) {
        if (!simulations.isEmpty()) {
            Set<Identifiable> defunctIdentifiables = this.getIdentifiablesInSimulation(simulations);
            this.identifiablesToDisplay.removeAll(defunctIdentifiables);
            this.cleanup(defunctIdentifiables);
        }
    }

    private void cleanup(Set<Identifiable> defunctIdentifiables) {
        if (defunctIdentifiables != null) {
            Iterator<Identifiable> iter = defunctIdentifiables.iterator();
            while (iter != null && iter.hasNext()) {
                Identifiable ident = iter.next();
                this.monitorSet.remove(ident.getURI().toString());
            }
            if (!this.composite.isDisposed()) {
                Control[] allControls;
                Control[] controlArray = allControls = this.composite.getChildren();
                int n = allControls.length;
                int n2 = 0;
                while (n2 < n) {
                    Control element = controlArray[n2];
                    ReportControl reportControl = (ReportControl)element;
                    try {
                        Identifiable testIdentifiable = reportControl.getIdentifiable();
                        if (testIdentifiable == null || !this.identifiablesToDisplay.contains(testIdentifiable)) {
                            reportControl.remove();
                        }
                    }
                    catch (SWTException sWTException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
        }
    }

    protected void removeIdentifiable(Identifiable ident) {
        if (ident != null) {
            this.identifiablesToDisplay.remove(ident);
            this.savePreferenceState();
        }
    }

    private void populateView(ISimulation sim) {
        if (!this.rcf.getFactoryType().equals("SIMULATION_CONTROL_FACTORY")) {
            return;
        }
        boolean foundControl = false;
        if (this.composite.isDisposed()) {
            return;
        }
        this.selection = null;
        List activeSimList = SimulationManager.getManager().getActiveSimulations();
        HashSet activeSimSet = new HashSet();
        activeSimSet.addAll(activeSimList);
        if (sim != null) {
            ReportControl reportControl;
            Control element;
            Control[] controls;
            Control[] controlArray = controls = this.composite.getChildren();
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                element = controlArray[n2];
                reportControl = (ReportControl)element;
                if (reportControl.getControlType().equals("SIMULATION_CONTROL_FACTORY") && reportControl.simulation == null) {
                    reportControl.setSimulation(sim);
                    reportControl.redraw();
                    foundControl = true;
                }
                ++n2;
            }
            controlArray = controls;
            n = controls.length;
            n2 = 0;
            while (n2 < n) {
                element = controlArray[n2];
                reportControl = (ReportControl)element;
                if (reportControl.getControlType().equals("SIMULATION_CONTROL_FACTORY") && reportControl.simulation != null && !activeSimSet.contains(reportControl.simulation)) {
                    reportControl.removeSelectionChangedListener(this);
                    reportControl.dispose();
                }
                ++n2;
            }
            if (!foundControl) {
                ReportControl reportControl2 = this.rcf.create(this.composite);
                reportControl2.addSelectionChangedListener(this);
                reportControl2.setSimulation(sim);
                reportControl2.addIRemoveListener(new IRemoveListener(){

                    @Override
                    public void identifiableRemoved(Identifiable ident) {
                        ReportViewer.this.removeIdentifiable(ident);
                    }
                });
                reportControl2.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        ReportViewer.this.composite.layout(true, true);
                        ReportViewer.this.composite.redraw();
                    }
                });
            }
        } else if (this.composite.getChildren().length == 0) {
            ReportControl reportControl = this.rcf.create(this.composite);
            reportControl.addSelectionChangedListener(this);
            reportControl.addIRemoveListener(new IRemoveListener(){

                @Override
                public void identifiableRemoved(Identifiable ident) {
                    ReportViewer.this.removeIdentifiable(ident);
                }
            });
            reportControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ReportViewer.this.composite.layout(true, true);
                    ReportViewer.this.composite.redraw();
                }
            });
        }
        this.composite.layout(true, true);
        this.composite.redraw();
    }

    private void populateView() {
        Identifiable ident;
        ReportControl reportControl;
        Control element;
        Control[] controls;
        if (this.rcf.getFactoryType().equals("SIMULATION_CONTROL_FACTORY")) {
            return;
        }
        if (this.composite.isDisposed()) {
            return;
        }
        this.selection = null;
        HashSet<Identifiable> undisplayedIdentifiables = new HashSet<Identifiable>();
        for (Identifiable node : this.identifiablesToDisplay) {
            if (this.isDisplayed(node)) continue;
            undisplayedIdentifiables.add(node);
        }
        Control[] controlArray = controls = this.composite.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            element = controlArray[n2];
            reportControl = (ReportControl)element;
            if (reportControl.getControlType().equals("IDENTIFIABLE_CONTROL_FACTORY") && !undisplayedIdentifiables.isEmpty() && !this.identifiablesToDisplay.contains(reportControl.getIdentifiable())) {
                ident = (Identifiable)undisplayedIdentifiables.toArray()[0];
                reportControl.setIdentifiable(ident);
                undisplayedIdentifiables.remove(ident);
            }
            ++n2;
        }
        controlArray = controls;
        n = controls.length;
        n2 = 0;
        while (n2 < n) {
            element = controlArray[n2];
            reportControl = (ReportControl)element;
            if (reportControl.getControlType().equals("IDENTIFIABLE_CONTROL_FACTORY") && (ident = reportControl.getIdentifiable()) != null && !this.identifiablesToDisplay.contains(ident)) {
                reportControl.removeSelectionChangedListener(this);
                reportControl.dispose();
            }
            ++n2;
        }
        for (Identifiable ident2 : undisplayedIdentifiables) {
            if (ident2 == null) continue;
            ReportControl reportControl2 = this.rcf.create(this.composite);
            reportControl2.addSelectionChangedListener(this);
            reportControl2.setIdentifiable(ident2);
            reportControl2.addIRemoveListener(new IRemoveListener(){

                @Override
                public void identifiableRemoved(Identifiable ident) {
                    ReportViewer.this.removeIdentifiable(ident);
                }
            });
            reportControl2.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ReportViewer.this.composite.layout(true, true);
                    ReportViewer.this.composite.redraw();
                }
            });
        }
        if (this.composite.getChildren().length == 0) {
            ReportControl reportControl3 = this.rcf.create(this.composite);
            reportControl3.addSelectionChangedListener(this);
            reportControl3.addIRemoveListener(new IRemoveListener(){

                @Override
                public void identifiableRemoved(Identifiable ident) {
                    ReportViewer.this.removeIdentifiable(ident);
                }
            });
            reportControl3.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ReportViewer.this.composite.layout(true, true);
                    ReportViewer.this.composite.redraw();
                }
            });
        }
        this.composite.layout(true, true);
        this.composite.redraw();
    }

    private Set<Identifiable> getIdentifiablesInSimulation(List<ISimulation> simulationList) {
        LinkedHashSet<Identifiable> retVal = new LinkedHashSet<Identifiable>();
        int i = 0;
        while (i < simulationList.size()) {
            ISimulation simulation = simulationList.get(i);
            Graph graph = simulation.getScenario().getCanonicalGraph();
            if (graph != null) {
                Iterator<String> iter = this.monitorSet.iterator();
                while (iter != null && iter.hasNext()) {
                    String key = iter.next();
                    Node node = null;
                    URI locURI = null;
                    try {
                        locURI = URI.createURI((String)key);
                        node = graph.getNode(locURI);
                        if (node == null) continue;
                        retVal.add((Identifiable)node);
                    }
                    catch (Exception e) {
                        Activator.logError("ReportViewer.getIdentifiablesInSimulation() Error setting Identifiable to " + key + " ", e);
                    }
                }
            }
            ++i;
        }
        return retVal;
    }

    private Set<Identifiable> getIdentifiablesInSimulation(ISimulation simulation) {
        LinkedHashSet<Identifiable> retVal = new LinkedHashSet<Identifiable>();
        Graph graph = simulation.getScenario().getCanonicalGraph();
        if (graph != null) {
            Iterator<String> iter = this.monitorSet.iterator();
            while (iter != null && iter.hasNext()) {
                String key = iter.next();
                Node node = null;
                URI locURI = null;
                try {
                    locURI = URI.createURI((String)key);
                    node = graph.getNode(locURI);
                    if (node == null) continue;
                    retVal.add((Identifiable)node);
                }
                catch (Exception e) {
                    Activator.logError("ReportViewer.getIdentifiablesInSimulation() Error setting Identifiable to " + key + " ", e);
                }
            }
        }
        return retVal;
    }

    private boolean isDisplayed(Identifiable identifiable) {
        Control[] allControls;
        boolean retValue = false;
        Control[] controlArray = allControls = this.composite.getChildren();
        int n = allControls.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            ReportControl reportControl = (ReportControl)element;
            Identifiable testIdentifiable = reportControl.getIdentifiable();
            if (testIdentifiable != null && testIdentifiable.equals(identifiable)) {
                retValue = true;
                break;
            }
            ++n2;
        }
        return retValue;
    }

    private void savePreferenceState() {
        List allSimulations = null;
        HashSet<String> nodesInSimulation = new HashSet<String>();
        if (this.simulationManager != null) {
            allSimulations = this.simulationManager.getActiveSimulations();
        }
        if (allSimulations != null && allSimulations.size() >= 1) {
            int i = 0;
            while (i < allSimulations.size()) {
                nodesInSimulation.clear();
                ISimulation sim = (ISimulation)allSimulations.get(i);
                String scenarioName = sim.getScenario().getURI().toString();
                DialogSettings section = new DialogSettings(scenarioName);
                Graph graph = sim.getScenario().getCanonicalGraph();
                Iterator<Identifiable> iter = this.identifiablesToDisplay.iterator();
                while (iter != null && iter.hasNext()) {
                    String id;
                    Node node;
                    Identifiable ident = iter.next();
                    if (ident == null || (node = graph.getNode(ident.getURI())) == null || (id = ident.getURI().toString()) == null) continue;
                    nodesInSimulation.add(id);
                }
                String[] newPrefs = new String[nodesInSimulation.size()];
                Iterator iter2 = nodesInSimulation.iterator();
                int icount = 0;
                while (iter2 != null && iter2.hasNext()) {
                    newPrefs[icount] = (String)iter2.next();
                    ++icount;
                }
                section.put(LOCATION_PREFERENCE_KEY, newPrefs);
                if (this.masterSettings == null) {
                    this.masterSettings = new DialogSettings(ROOT_KEY);
                }
                this.masterSettings.addSection((IDialogSettings)section);
                try {
                    this.masterSettings.save(this.getPrefFileName());
                }
                catch (IOException ioe) {
                    Activator.logError("exception writing file [" + ioe.getMessage() + "]", ioe);
                }
                ++i;
            }
        }
    }

    private void updatePreferenceState(ISimulation sim) {
        String[] allIDs;
        String scenarioName;
        IDialogSettings section;
        if (this.masterSettings == null) {
            this.readMasterSettingsFromFile();
        }
        if ((section = this.masterSettings.getSection(scenarioName = sim.getScenario().getURI().toString())) == null) {
            section = new DialogSettings(scenarioName);
            this.masterSettings.addSection(section);
        }
        if ((allIDs = section.getArray(LOCATION_PREFERENCE_KEY)) != null) {
            String[] stringArray = allIDs;
            int n = allIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                this.monitorSet.add(element);
                ++n2;
            }
        }
    }

    public void readMasterSettingsFromFile() {
        this.masterSettings = new DialogSettings(ROOT_KEY);
        String filename = this.getPrefFileName();
        File f = new File(filename);
        if (f.exists()) {
            try {
                this.masterSettings.load(filename);
            }
            catch (IOException ioe) {
                Activator.logError("exception loading file [" + ioe.getMessage() + "]", ioe);
            }
        } else {
            try {
                this.masterSettings.save(filename);
            }
            catch (IOException ioe) {
                Activator.logError("exception creating file [" + ioe.getMessage() + "]", ioe);
            }
        }
    }

    public String getPrefFileName() {
        String controlCategory = this.rcf.getUniqueControlName();
        String filename = PATH.append(String.valueOf(controlCategory) + "_" + REPORTVIEWPREFERENCES_FILENAME).toOSString();
        return filename;
    }
}

