/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.populationmodels.standard.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.populationmodels.standard.wizards.NewPopulationModelWizard;
import org.eclipse.stem.ui.populationmodels.standard.wizards.PopulationModelPropertyComposite;
import org.eclipse.stem.ui.populationmodels.standard.wizards.PopulationModelWizardMessages;
import org.eclipse.stem.ui.widgets.LocationPickerDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class PopulationModelDefinitionControl
extends Composite {
    private static PopulationModel[] populationModels = null;
    private final Combo combo;
    private final PopulationModelPropertyComposite populationModelPropertyComposite;
    private String isoKey = "";
    private URI targetURI = null;
    private NewPopulationModelWizard newPopulationWizard;

    public PopulationModelDefinitionControl(Composite parent, int style, final ModifyListener projectValidator, final IProject project, NewPopulationModelWizard npwz) {
        super(parent, style);
        this.newPopulationWizard = npwz;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label populationModelLabel = new Label((Composite)this, 0);
        GridData gd_populationModelLabel = new GridData(4, 0x1000000, true, false);
        gd_populationModelLabel.widthHint = 100;
        populationModelLabel.setLayoutData((Object)gd_populationModelLabel);
        populationModelLabel.setText(PopulationModelWizardMessages.getString("DDC.0"));
        this.combo = new Combo((Composite)this, 8);
        this.combo.setTextLimit(30);
        GridData gd_combo = new GridData(4, 0x1000000, true, false);
        gd_combo.widthHint = 303;
        this.combo.setLayoutData((Object)gd_combo);
        this.combo.setToolTipText(PopulationModelWizardMessages.getString("DDC.1"));
        this.combo.setItems(this.getPopulationModelNames(this.getPopulationModels()));
        this.combo.select(0);
        this.combo.addModifyListener(projectValidator);
        this.populationModelPropertyComposite = new PopulationModelPropertyComposite(this, 0, this.getPopulationModels(), projectValidator, project);
        GridData gd_populationModelPropertyControl = new GridData(4, 0x1000000, true, false, 2, 1);
        this.populationModelPropertyComposite.setLayoutData(gd_populationModelPropertyControl);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PopulationModelDefinitionControl.this.populationModelPropertyComposite.displayDiseaseModel(PopulationModelDefinitionControl.this.getPopulationModels()[PopulationModelDefinitionControl.this.combo.getSelectionIndex()]);
                projectValidator.modifyText(null);
                PopulationModelDefinitionControl.this.newPopulationWizard.newDublinCorePage.updateDublinCorePage(PopulationModelDefinitionControl.this.getSelectedPopulationModelDublinCore());
            }
        });
        Label isoKeyLabel = new Label((Composite)this, 0);
        isoKeyLabel.setText(PopulationModelWizardMessages.getString("NPopWizISOK"));
        GridData gd_isoKeyLabel = new GridData(4, 0x1000000, true, false);
        isoKeyLabel.setLayoutData((Object)gd_isoKeyLabel);
        final Label isokeyValueLabel = new Label((Composite)this, 0);
        isokeyValueLabel.setText(this.isoKey);
        GridData gd_isoKeyLabelValue = new GridData(4, 0x1000000, true, false);
        isokeyValueLabel.setLayoutData((Object)gd_isoKeyLabelValue);
        Button locationButton = new Button((Composite)this, 0);
        locationButton.setText(PopulationModelWizardMessages.getString("NPopWizPickLoc"));
        GridData lb_isoKeyLabel = new GridData(4, 0x1000000, true, false);
        locationButton.setLayoutData((Object)lb_isoKeyLabel);
        locationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                LocationPickerDialog lpDialog = new LocationPickerDialog(PopulationModelDefinitionControl.this.getShell(), 0, PopulationModelWizardMessages.getString("NPopWizPickLocTitle"), PopulationModelDefinitionControl.this.isoKey, project);
                Object[] ret = lpDialog.open();
                if (ret != null) {
                    isokeyValueLabel.setText((String)ret[0]);
                    PopulationModelDefinitionControl.this.isoKey = (String)ret[0];
                    PopulationModelDefinitionControl.this.targetURI = (URI)ret[1];
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newpopulation_contextid");
    }

    private PopulationModel[] getPopulationModels() {
        if (populationModels == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] populationModelConfigElements = registry.getConfigurationElementsFor("org.eclipse.stem.populationmodels.populationmodel");
            ArrayList<PopulationModel> temp = new ArrayList<PopulationModel>();
            ArrayList<DublinCore> dctemp = new ArrayList<DublinCore>();
            populationModels = new PopulationModel[populationModelConfigElements.length];
            int i = 0;
            while (i < populationModelConfigElements.length) {
                IConfigurationElement element = populationModelConfigElements[i];
                if (element.getName().equals("classdef")) {
                    try {
                        temp.add((PopulationModel)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        Activator.logError((String)PopulationModelWizardMessages.getString("DDC.3"), (Throwable)e);
                    }
                } else if (element.getName().equals("dublin_core")) {
                    dctemp.add(Utility.getPluginDublinCore((IConfigurationElement)element));
                }
                ++i;
            }
            populationModels = temp.toArray(new PopulationModel[0]);
            int n = 0;
            while (n < populationModels.length) {
                populationModels[n].setDublinCore((DublinCore)dctemp.get(n));
                ++n;
            }
        }
        return populationModels;
    }

    private String[] getPopulationModelNames(PopulationModel[] populationModels) {
        String[] retValue = new String[populationModels.length];
        int i = 0;
        while (i < populationModels.length) {
            String name = populationModels[i].getDublinCore().getTitle();
            if (name == null || name.equals("")) {
                name = populationModels[i].getClass().getSimpleName();
            }
            retValue[i] = name;
            ++i;
        }
        return retValue;
    }

    PopulationModel getSelectedPopulationModel() {
        PopulationModel retValue = (PopulationModel)EcoreUtil.copy((EObject)this.getPopulationModels()[this.combo.getSelectionIndex()]);
        this.populationModelPropertyComposite.populatePopulationModel(retValue);
        retValue.setTargetISOKey(this.getIsoKey());
        return retValue;
    }

    DublinCore getSelectedPopulationModelDublinCore() {
        PopulationModel retValue = (PopulationModel)EcoreUtil.copy((EObject)this.getPopulationModels()[this.combo.getSelectionIndex()]);
        return retValue.getDublinCore();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return this.populationModelPropertyComposite.validate();
    }

    public String getErrorMessage() {
        return this.populationModelPropertyComposite.getErrorMessage();
    }

    public String getIsoKey() {
        return this.isoKey;
    }

    public URI getTargetURI() {
        return this.targetURI;
    }
}

