/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.transform;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.stem.model.codegen.GeneratorUtils;
import org.eclipse.stem.model.metamodel.AuthorDetails;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.CompartmentGroup;
import org.eclipse.stem.model.metamodel.CompartmentType;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.ModelGenSettings;
import org.eclipse.stem.model.metamodel.ModelParam;
import org.eclipse.stem.model.metamodel.ModelParamConstraint;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.metamodel.PackageGenSettings;
import org.eclipse.stem.model.metamodel.util.MetamodelSwitch;

public class EcoreTransformSwitch
extends MetamodelSwitch<Object> {
    protected static final EcoreFactory FACTORY = EcoreFactory.eINSTANCE;
    protected EPackage parentPackage;
    private static final MetamodelSwitch<EObject> ALLOCATION_SWITCH = new MetamodelSwitch<EObject>(){

        public EObject caseModel(Model object) {
            object.setClass(EcoreFactory.eINSTANCE.createEClass());
            this.caseCompartmentGroup(object.getCompartments());
            return null;
        }

        public EObject caseCompartmentGroup(CompartmentGroup object) {
            object.setClass(EcoreFactory.eINSTANCE.createEClass());
            object.setValueClass(EcoreFactory.eINSTANCE.createEClass());
            return null;
        }
    };

    public EPackage casePackage(Package object) {
        this.parentPackage = FACTORY.createEPackage();
        this.allocateEClassInstances(object);
        this.parentPackage.setName(object.getName());
        this.parentPackage.setNsPrefix(this.getNSPrefixForPackage(object));
        this.parentPackage.setNsURI(this.getNSURIForPackage(object));
        for (Model model : object.getModels()) {
            this.parentPackage.getEClassifiers().add((Object)this.caseModel(model));
        }
        this.addCodeGenMarkerAnnotation((EModelElement)this.parentPackage);
        return this.parentPackage;
    }

    public EClass caseModel(Model object) {
        EClass modelClass = object.getClass_();
        modelClass.setName(object.getName());
        if (object.getParentModel() != null) {
            modelClass.getESuperTypes().add((Object)object.getParentModel().getClass_());
        }
        object.setClass(modelClass);
        if (object.getCompartments() != null) {
            modelClass.getEAnnotations().addAll((Collection)this.caseCompartmentGroup(object.getCompartments()));
        }
        for (ModelParam param : object.getParameters()) {
            modelClass.getEStructuralFeatures().add((Object)this.caseModelParam(param));
        }
        if (object.getAuthor() != null) {
            modelClass.getEAnnotations().add((Object)this.caseAuthorDetails(object.getAuthor()));
        }
        modelClass.getEAnnotations().add((Object)this.createAdaptersAnnotation(object));
        this.addCodeGenMarkerAnnotation((EModelElement)modelClass);
        return modelClass;
    }

    public EStructuralFeature caseModelParam(ModelParam object) {
        EAnnotation messagesAnnotation;
        EAttribute modelFeature = null;
        if (object.getDataType() instanceof EDataType) {
            modelFeature = FACTORY.createEAttribute();
        } else if (object.getDataType() instanceof EClass) {
            modelFeature = FACTORY.createEReference();
            ((EReference)modelFeature).setContainment(true);
        } else {
            return null;
        }
        modelFeature.setName(object.getName());
        modelFeature.setEType(object.getDataType());
        modelFeature.setDefaultValueLiteral(object.getDefaultValue());
        if (object.getConstraints().size() > 0) {
            EAnnotation constraintAnnotation = FACTORY.createEAnnotation();
            constraintAnnotation.setSource("http:///org/eclipse/stem/modelgen/modelparam/constraints");
            modelFeature.getEAnnotations().add((Object)constraintAnnotation);
            for (ModelParamConstraint c : object.getConstraints()) {
                constraintAnnotation.getDetails().put((Object)c.getName(), (Object)c.getConstraint());
            }
        }
        if ((messagesAnnotation = this.createMessagesAnnotation(object)) != null) {
            modelFeature.getEAnnotations().add((Object)messagesAnnotation);
        }
        this.addCodeGenMarkerAnnotation((EModelElement)modelFeature);
        return modelFeature;
    }

    public EAnnotation caseModelParamConstraint(ModelParamConstraint object) {
        EAnnotation modelAnnotation = FACTORY.createEAnnotation();
        modelAnnotation.setSource("http:///org/eclipse/stem/modelgen/modelparam/constraints");
        modelAnnotation.getDetails().put((Object)object.getName(), (Object)object.getConstraint());
        return modelAnnotation;
    }

    public List<EAnnotation> caseCompartmentGroup(CompartmentGroup object) {
        EClass parentLabelValue;
        EClass labelClass = object.getClass_();
        EClass labelValueClass = object.getValueClass();
        this.parentPackage.getEClassifiers().add((Object)labelClass);
        this.parentPackage.getEClassifiers().add((Object)labelValueClass);
        labelClass.setName(String.valueOf(object.getName()) + "Label");
        labelValueClass.setName(String.valueOf(object.getName()) + "LabelValue");
        EClass parentLabel = object.getParentGroup().getClass_();
        if (parentLabel != null) {
            labelClass.getESuperTypes().add((Object)parentLabel);
        }
        if ((parentLabelValue = object.getParentGroup().getValueClass()) != null) {
            labelValueClass.getESuperTypes().add((Object)parentLabelValue);
        }
        for (Compartment c : object.getCompartments()) {
            labelValueClass.getEStructuralFeatures().add((Object)this.caseCompartment(c));
        }
        this.addCodeGenMarkerAnnotation((EModelElement)labelClass);
        this.addCodeGenMarkerAnnotation((EModelElement)labelValueClass);
        EAnnotation labelAnnotation = FACTORY.createEAnnotation();
        labelAnnotation.setSource("http:///org/eclipse/stem/modelgen/model/label");
        labelAnnotation.getDetails().put((Object)"*", (Object)labelClass.getName());
        EAnnotation labelValueAnnotation = FACTORY.createEAnnotation();
        labelValueAnnotation.setSource("http:///org/eclipse/stem/modelgen/model/labelvalue");
        labelValueAnnotation.getDetails().put((Object)"*", (Object)labelValueClass.getName());
        return Arrays.asList(labelAnnotation, labelValueAnnotation);
    }

    public EAttribute caseCompartment(Compartment object) {
        EAttribute modelAttribute = FACTORY.createEAttribute();
        modelAttribute.setName(object.getName());
        modelAttribute.setEType((EClassifier)object.getDataType());
        EAnnotation typeAnnotation = this.createCompartmentTypeAnnotation(object.getType());
        if (typeAnnotation != null) {
            modelAttribute.getEAnnotations().add((Object)typeAnnotation);
        }
        this.addCodeGenMarkerAnnotation((EModelElement)modelAttribute);
        return modelAttribute;
    }

    public EAnnotation caseAuthorDetails(AuthorDetails object) {
        EAnnotation authorAnnotation = FACTORY.createEAnnotation();
        authorAnnotation.setSource("http:///org/eclipse/stem/modelgen/author");
        for (EAttribute attribute : object.eClass().getEAttributes()) {
            Object value = object.eGet((EStructuralFeature)attribute);
            if (value == null) continue;
            authorAnnotation.getDetails().put((Object)attribute.getName(), (Object)value.toString());
        }
        return authorAnnotation;
    }

    private EAnnotation createAdaptersAnnotation(Model object) {
        EAnnotation annotation = FACTORY.createEAnnotation();
        annotation.setSource("http:///org/eclipse/stem/modelgen/model/adapters");
        ModelGenSettings settings = object.getGeneratorSettings();
        ModelGenSettings parentSettings = object.getParentModel().getGeneratorSettings();
        if (settings != null) {
            if (!GeneratorUtils.isNullOrEmpty((String)settings.getPropertyEditorClass())) {
                annotation.getDetails().put((Object)"propertyEditorClass", (Object)settings.getPropertyEditorClass());
            }
            if (!GeneratorUtils.isNullOrEmpty((String)settings.getStringProviderAdapterClass())) {
                annotation.getDetails().put((Object)"stringProviderClass", (Object)settings.getStringProviderAdapterClass());
            }
            if (!GeneratorUtils.isNullOrEmpty((String)settings.getLabelRelativeValueProviderAdapterClass())) {
                annotation.getDetails().put((Object)"labelRelativeValueProviderClass", (Object)settings.getLabelRelativeValueProviderAdapterClass());
            }
            if (!GeneratorUtils.isNullOrEmpty((String)settings.getLabelValueRelativeValueProviderAdapterClass())) {
                annotation.getDetails().put((Object)"labelValueRelativeValueProviderClass", (Object)settings.getLabelValueRelativeValueProviderAdapterClass());
            }
        }
        if (settings != null && !GeneratorUtils.isNullOrEmpty((String)settings.getPropertyEditorParentClass())) {
            annotation.getDetails().put((Object)"propertyEditorSuperClass", (Object)settings.getPropertyEditorParentClass());
        } else if (parentSettings != null && !GeneratorUtils.isNullOrEmpty((String)parentSettings.getPropertyEditorClass())) {
            annotation.getDetails().put((Object)"propertyEditorSuperClass", (Object)parentSettings.getPropertyEditorClass());
        }
        if (settings != null && !GeneratorUtils.isNullOrEmpty((String)settings.getStringProviderAdapterParentClass())) {
            annotation.getDetails().put((Object)"stringProviderSuperClass", (Object)settings.getStringProviderAdapterParentClass());
        } else if (parentSettings != null && !GeneratorUtils.isNullOrEmpty((String)parentSettings.getStringProviderAdapterClass())) {
            annotation.getDetails().put((Object)"stringProviderSuperClass", (Object)parentSettings.getStringProviderAdapterClass());
        }
        if (settings != null && !GeneratorUtils.isNullOrEmpty((String)settings.getLabelRelativeValueProviderAdapterParentClass())) {
            annotation.getDetails().put((Object)"labelRelativeValueProviderSuperClass", (Object)settings.getLabelRelativeValueProviderAdapterParentClass());
        } else if (parentSettings != null && !GeneratorUtils.isNullOrEmpty((String)parentSettings.getLabelRelativeValueProviderAdapterClass())) {
            annotation.getDetails().put((Object)"labelRelativeValueProviderSuperClass", (Object)parentSettings.getLabelRelativeValueProviderAdapterClass());
        }
        if (settings != null && !GeneratorUtils.isNullOrEmpty((String)settings.getLabelValueRelativeValueProviderAdapterParentClass())) {
            annotation.getDetails().put((Object)"labelValueRelativeValueProviderSuperClass", (Object)settings.getLabelValueRelativeValueProviderAdapterParentClass());
        } else if (parentSettings != null && !GeneratorUtils.isNullOrEmpty((String)parentSettings.getLabelValueRelativeValueProviderAdapterClass())) {
            annotation.getDetails().put((Object)"labelValueRelativeValueProviderSuperClass", (Object)parentSettings.getLabelValueRelativeValueProviderAdapterClass());
        }
        return annotation;
    }

    public EAnnotation casePackageGenSettings(PackageGenSettings object) {
        EAnnotation annotation = FACTORY.createEAnnotation();
        return annotation;
    }

    private EAnnotation createMessagesAnnotation(ModelParam object) {
        if (GeneratorUtils.isNullOrEmpty((String)object.getDisplayName()) && GeneratorUtils.isNullOrEmpty((String)object.getUnit()) && GeneratorUtils.isNullOrEmpty((String)object.getHelpMessage()) && GeneratorUtils.isNullOrEmpty((String)object.getInvalidMessage()) && GeneratorUtils.isNullOrEmpty((String)object.getMissingMessage())) {
            return null;
        }
        EAnnotation modelAnnotation = FACTORY.createEAnnotation();
        modelAnnotation.setSource("http:///org/eclipse/stem/modelgen/modelparam/messages");
        if (!GeneratorUtils.isNullOrEmpty((String)object.getDisplayName())) {
            modelAnnotation.getDetails().put((Object)"name", (Object)object.getDisplayName());
        }
        if (!GeneratorUtils.isNullOrEmpty((String)object.getUnit())) {
            modelAnnotation.getDetails().put((Object)"unit", (Object)object.getUnit());
        }
        if (!GeneratorUtils.isNullOrEmpty((String)object.getHelpMessage())) {
            modelAnnotation.getDetails().put((Object)"tooltip", (Object)object.getHelpMessage());
        }
        if (!GeneratorUtils.isNullOrEmpty((String)object.getInvalidMessage())) {
            modelAnnotation.getDetails().put((Object)"invalid", (Object)object.getInvalidMessage());
        }
        if (!GeneratorUtils.isNullOrEmpty((String)object.getMissingMessage())) {
            modelAnnotation.getDetails().put((Object)"missing", (Object)object.getMissingMessage());
        }
        return modelAnnotation;
    }

    private EAnnotation createCompartmentTypeAnnotation(CompartmentType type) {
        EAnnotation annotation = null;
        if (type != CompartmentType.STANDARD) {
            annotation = FACTORY.createEAnnotation();
            annotation.setSource("http:///org/eclipse/stem/modelgen/compartment/type");
            annotation.getDetails().put((Object)"type", (Object)type.getLiteral());
        }
        return annotation;
    }

    private void addCodeGenMarkerAnnotation(EModelElement obj) {
        EAnnotation annotation = FACTORY.createEAnnotation();
        annotation.setSource("http:///org/eclipse/stem/modelgen/generated");
        annotation.getDetails().put((Object)"version", (Object)"1.0");
        obj.getEAnnotations().add((Object)annotation);
    }

    private void allocateEClassInstances(Package object) {
        TreeIterator it = object.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            ALLOCATION_SWITCH.doSwitch(obj);
        }
    }

    private String getNSPrefixForPackage(Package pkg) {
        StringBuilder sb = new StringBuilder();
        sb.append(pkg.getPackagePrefix());
        sb.append(".");
        sb.append(pkg.getName());
        return sb.toString().toLowerCase();
    }

    private String getNSURIForPackage(Package pkg) {
        StringBuilder sb = new StringBuilder();
        sb.append("http:///");
        sb.append(this.getNSPrefixForPackage(pkg).replace('.', '/'));
        sb.append("/");
        sb.append(pkg.getName());
        sb.append(".ecore");
        return sb.toString().toLowerCase();
    }
}

