/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.labels.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.provider.DynamicEdgeLabelItemProvider;
import org.eclipse.stem.definitions.edges.provider.DefinitionsEditPlugin;
import org.eclipse.stem.definitions.labels.LabelsPackage;
import org.eclipse.stem.definitions.labels.TransportRelationshipLabel;
import org.eclipse.stem.geography.names.GeographicNames;

public class TransportRelationshipLabelItemProvider
extends DynamicEdgeLabelItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public TransportRelationshipLabelItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addTransportModePropertyDescriptor(object);
            this.addPopulationIdentifierPropertyDescriptor(object);
            this.addTransportIdentifierPropertyDescriptor(object);
            this.addCurrentTransportRelationshipLabelValuePropertyDescriptor(object);
            this.addRateTimePeriodPropertyDescriptor(object);
            this.addDepartureCapacityPropertyDescriptor(object);
            this.addMaximumDepartureCapacityPropertyDescriptor(object);
            this.addCapacityPropertyDescriptor(object);
            this.addMaximumCapacityPropertyDescriptor(object);
            this.addTransitTimePropertyDescriptor(object);
            this.addStartUpDelayPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addTransportModePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TransportRelationshipLabel_transportMode_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TransportRelationshipLabel_transportMode_feature", "_UI_TransportRelationshipLabel_type"), (EStructuralFeature)LabelsPackage.Literals.TRANSPORT_RELATIONSHIP_LABEL__TRANSPORT_MODE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addPopulationIdentifierPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TransportRelationshipLabel_populationIdentifier_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TransportRelationshipLabel_populationIdentifier_feature", "_UI_TransportRelationshipLabel_type"), (EStructuralFeature)LabelsPackage.Literals.TRANSPORT_RELATIONSHIP_LABEL__POPULATION_IDENTIFIER, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addTransportIdentifierPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TransportRelationshipLabel_transportIdentifier_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TransportRelationshipLabel_transportIdentifier_feature", "_UI_TransportRelationshipLabel_type"), (EStructuralFeature)LabelsPackage.Literals.TRANSPORT_RELATIONSHIP_LABEL__TRANSPORT_IDENTIFIER, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addCurrentTransportRelationshipLabelValuePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TransportRelationshipLabel_currentTransportRelationshipLabelValue_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TransportRelationshipLabel_currentTransportRelationshipLabelValue_feature", "_UI_TransportRelationshipLabel_type"), (EStructuralFeature)LabelsPackage.Literals.TRANSPORT_RELATIONSHIP_LABEL__CURRENT_TRANSPORT_RELATIONSHIP_LABEL_VALUE, false, false, false, null, null, null));
    }

    protected void addRateTimePeriodPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TransportRelationshipLabel_rateTimePeriod_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TransportRelationshipLabel_rateTimePeriod_feature", "_UI_TransportRelationshipLabel_type"), (EStructuralFeature)LabelsPackage.Literals.TRANSPORT_RELATIONSHIP_LABEL__RATE_TIME_PERIOD, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addDepartureCapacityPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TransportRelationshipLabel_departureCapacity_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TransportRelationshipLabel_departureCapacity_feature", "_UI_TransportRelationshipLabel_type"), (EStructuralFeature)LabelsPackage.Literals.TRANSPORT_RELATIONSHIP_LABEL__DEPARTURE_CAPACITY, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addMaximumDepartureCapacityPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TransportRelationshipLabel_maximumDepartureCapacity_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TransportRelationshipLabel_maximumDepartureCapacity_feature", "_UI_TransportRelationshipLabel_type"), (EStructuralFeature)LabelsPackage.Literals.TRANSPORT_RELATIONSHIP_LABEL__MAXIMUM_DEPARTURE_CAPACITY, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addCapacityPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TransportRelationshipLabel_capacity_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TransportRelationshipLabel_capacity_feature", "_UI_TransportRelationshipLabel_type"), (EStructuralFeature)LabelsPackage.Literals.TRANSPORT_RELATIONSHIP_LABEL__CAPACITY, false, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addMaximumCapacityPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TransportRelationshipLabel_maximumCapacity_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TransportRelationshipLabel_maximumCapacity_feature", "_UI_TransportRelationshipLabel_type"), (EStructuralFeature)LabelsPackage.Literals.TRANSPORT_RELATIONSHIP_LABEL__MAXIMUM_CAPACITY, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addTransitTimePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TransportRelationshipLabel_transitTime_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TransportRelationshipLabel_transitTime_feature", "_UI_TransportRelationshipLabel_type"), (EStructuralFeature)LabelsPackage.Literals.TRANSPORT_RELATIONSHIP_LABEL__TRANSIT_TIME, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addStartUpDelayPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TransportRelationshipLabel_startUpDelay_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TransportRelationshipLabel_startUpDelay_feature", "_UI_TransportRelationshipLabel_type"), (EStructuralFeature)LabelsPackage.Literals.TRANSPORT_RELATIONSHIP_LABEL__START_UP_DELAY, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    public String getText(Object object) {
        URI labelURI = ((TransportRelationshipLabel)object).getURI();
        String lastSegment = labelURI.lastSegment().toString();
        int i = lastSegment.indexOf("_");
        String firstISOKey = lastSegment.substring(0, i);
        String secondISOKey = lastSegment.substring(i + 1);
        String firstGeoName = GeographicNames.getName((String)firstISOKey);
        String secondGeoName = GeographicNames.getName((String)secondISOKey);
        StringBuilder sb = new StringBuilder(firstGeoName.startsWith("!") ? firstISOKey : firstGeoName);
        Edge edge = ((EdgeLabel)object).getEdge();
        sb.append(edge.isDirected() ? " -> " : " <-> ");
        sb.append(secondGeoName.startsWith("!") ? secondISOKey : secondGeoName);
        return sb.toString();
    }

    public String getTextGen(Object object) {
        URI labelValue = ((TransportRelationshipLabel)object).getURI();
        String label = labelValue == null ? null : labelValue.toString();
        return label == null || label.length() == 0 ? this.getString("_UI_TransportRelationshipLabel_type") : String.valueOf(this.getString("_UI_TransportRelationshipLabel_type")) + " " + label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(TransportRelationshipLabel.class)) {
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return DefinitionsEditPlugin.INSTANCE;
    }
}

