/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphgenerators;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AreaUnit implements Enumerator
{
    SQ_KM(0, "SQ_KM", "km^2"),
    SQ_M(1, "SQ_M", "m^2"),
    SQ_MILE(2, "SQ_MILE", "mi^2");

    public static final int SQ_KM_VALUE = 0;
    public static final int SQ_M_VALUE = 1;
    public static final int SQ_MILE_VALUE = 2;
    private static final AreaUnit[] VALUES_ARRAY;
    public static final List<AreaUnit> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AreaUnit[]{SQ_KM, SQ_M, SQ_MILE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AreaUnit get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AreaUnit result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AreaUnit getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AreaUnit result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AreaUnit get(int value) {
        switch (value) {
            case 0: {
                return SQ_KM;
            }
            case 1: {
                return SQ_M;
            }
            case 2: {
                return SQ_MILE;
            }
        }
        return null;
    }

    private AreaUnit(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

