/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphgenerators.impl;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.definitions.adapters.spatial.geo.InlineLatLongDataProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.edges.EdgesFactory;
import org.eclipse.stem.definitions.edges.MigrationEdge;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.impl.CommonBorderRelationshipLabelImpl;
import org.eclipse.stem.definitions.labels.impl.RoadTransportRelationshipLabelImpl;
import org.eclipse.stem.definitions.nodes.NodesFactory;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.gis.shp.ShpPolyLine;
import org.eclipse.stem.gis.shp.ShpPolygon;
import org.eclipse.stem.gis.shp.ShpRecord;
import org.eclipse.stem.gis.shp.type.Box;
import org.eclipse.stem.gis.shp.type.Part;
import org.eclipse.stem.graphgenerators.AreaUnit;
import org.eclipse.stem.graphgenerators.GraphgeneratorsPackage;
import org.eclipse.stem.graphgenerators.MigrationShapefile;
import org.eclipse.stem.graphgenerators.RegionShapefile;
import org.eclipse.stem.graphgenerators.RoadShapefile;
import org.eclipse.stem.graphgenerators.Shapefile;
import org.eclipse.stem.graphgenerators.ShapefileGraphGenerator;
import org.eclipse.stem.graphgenerators.impl.GraphGeneratorImpl;
import org.eclipse.stem.graphgenerators.impl.Reader;

public class ShapefileGraphGeneratorImpl
extends GraphGeneratorImpl
implements ShapefileGraphGenerator {
    protected EList<Shapefile> shapefiles;

    @Override
    protected EClass eStaticClass() {
        return GraphgeneratorsPackage.Literals.SHAPEFILE_GRAPH_GENERATOR;
    }

    @Override
    public EList<Shapefile> getShapefiles() {
        if (this.shapefiles == null) {
            this.shapefiles = new EObjectResolvingEList(Shapefile.class, (InternalEObject)this, 3);
        }
        return this.shapefiles;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getShapefiles();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.getShapefiles().clear();
                this.getShapefiles().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.getShapefiles().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.shapefiles != null && !this.shapefiles.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Graph getGraph() {
        Graph graph = GraphFactory.eINSTANCE.createGraph();
        ArrayList<Node> nodeList = new ArrayList<Node>();
        ArrayList<ShpPolygon> polygonList = new ArrayList<ShpPolygon>();
        DublinCore dc = graph.getDublinCore();
        Calendar c = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("E yyyy.MM.dd 'at' hh:mm:ss a zzz");
        dc.populate();
        dc.setTitle("GIS Import");
        dc.setSource(this.getClass().getSimpleName());
        dc.setValid(formatter.format(c.getTime()));
        this.processRegionShapefiles(graph, nodeList, polygonList);
        this.processCommonBorderCreation(graph, nodeList, polygonList);
        this.processRoadShapefiles(graph, nodeList, polygonList);
        this.processMigrationShapefiles(graph, nodeList, polygonList);
        assert (graph.sane());
        return graph;
    }

    private void processRegionShapefiles(Graph graph, List<Node> nodeList, List<ShpPolygon> polygonList) {
        for (Shapefile s : this.shapefiles) {
            if (!(s instanceof RegionShapefile)) continue;
            RegionShapefile shapefile = (RegionShapefile)s;
            List<ShpRecord> shapeList = null;
            List<List<String>> data = null;
            List<String> columnNames = null;
            String regionID = shapefile.getId();
            String area = shapefile.getArea();
            AreaUnit areaUnit = shapefile.getAreaUnit();
            EList<String> populationNames = shapefile.getPopulationNames();
            EList<String> populationSizes = shapefile.getPopulationSizes();
            try {
                Reader reader = new Reader(shapefile.getFileName());
                shapeList = reader.getShapeList();
                data = reader.getData();
                columnNames = reader.getColumnNames();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (shapeList != null) {
                int i = 0;
                while (i < shapeList.size()) {
                    ShpRecord shape = shapeList.get(i);
                    if (shape instanceof ShpPolygon) {
                        ShpPolygon polygon = (ShpPolygon)shape;
                        this.adjustNumberOfFractionalDigits((ShpPolyLine)polygon);
                        String currentID = data.get(i).get(columnNames.indexOf(regionID.replaceFirst("column:", "")));
                        currentID = currentID.replace(" ", "");
                        Double currentArea = null;
                        try {
                            currentArea = area.startsWith("column:") ? Double.valueOf(Double.parseDouble(data.get(i).get(columnNames.indexOf(area.replaceFirst("column:", ""))))) : Double.valueOf(Double.parseDouble(area));
                            if (areaUnit != AreaUnit.SQ_KM) {
                                if (areaUnit == AreaUnit.SQ_M) {
                                    currentArea = currentArea / 1000000.0;
                                } else if (areaUnit == AreaUnit.SQ_MILE) {
                                    currentArea = currentArea * 2.589988110336;
                                }
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                        Region regionNode = this.createRegionNode(currentID);
                        LatLong nodeSegments = this.createSTEMPolygon(polygon);
                        String spatialURIString = InlineLatLongDataProvider.createSpatialInlineURIString((LatLong)nodeSegments);
                        regionNode.getDublinCore().setSpatial(spatialURIString);
                        nodeList.add((Node)regionNode);
                        graph.putNode((Node)regionNode);
                        polygonList.add(polygon);
                        if (currentArea != null) {
                            AreaLabel areaLabel = this.createAreaLabel(currentArea);
                            areaLabel.setURIOfIdentifiableToBeLabeled(regionNode.getURI());
                            areaLabel.setNode((Node)regionNode);
                            regionNode.getLabels().add((Object)areaLabel);
                            graph.getNodeLabels().put((Object)areaLabel.getURI(), (Object)areaLabel);
                        }
                        int j = 0;
                        while (j < populationNames.size()) {
                            double currentPopSize;
                            String currentPopName = ((String)populationNames.get(j)).startsWith("column:") ? data.get(i).get(columnNames.indexOf(((String)populationNames.get(j)).replaceFirst("column:", ""))) : (String)populationNames.get(j);
                            if (((String)populationSizes.get(j)).startsWith("column:")) {
                                try {
                                    currentPopSize = Double.parseDouble(data.get(i).get(columnNames.indexOf(((String)populationSizes.get(j)).replaceFirst("column:", ""))));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    currentPopSize = 0.0;
                                }
                            } else {
                                try {
                                    currentPopSize = Double.parseDouble((String)populationSizes.get(j));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    currentPopSize = 0.0;
                                }
                            }
                            PopulationLabel popLabel = this.createPopulationLabel(currentPopName, currentPopSize);
                            popLabel.setURIOfIdentifiableToBeLabeled(regionNode.getURI());
                            popLabel.setNode((Node)regionNode);
                            regionNode.getLabels().add((Object)popLabel);
                            graph.getNodeLabels().put((Object)popLabel.getURI(), (Object)popLabel);
                            ++j;
                        }
                    } else {
                        System.err.println("Region Shapefile contains non-polygon");
                    }
                    ++i;
                }
                continue;
            }
            Activator.logInformation((String)"Warning, shape file contains null entries");
        }
    }

    private void processRoadShapefiles(Graph graph, List<Node> nodeList, List<ShpPolygon> polygonList) {
        for (Shapefile s : this.shapefiles) {
            if (!(s instanceof RoadShapefile)) continue;
            RoadShapefile shapefile = (RoadShapefile)s;
            List<ShpRecord> shapeList = null;
            List<List<String>> data = null;
            List<String> columnNames = null;
            String roadID = shapefile.getId();
            String roadClass = shapefile.getRoadClass();
            try {
                Reader reader = new Reader(shapefile.getFileName());
                shapeList = reader.getShapeList();
                data = reader.getData();
                columnNames = reader.getColumnNames();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int i = 0;
            while (i < shapeList.size()) {
                ShpRecord shape = shapeList.get(i);
                if (shape instanceof ShpPolyLine) {
                    ShpPolyLine polyline = (ShpPolyLine)shape;
                    this.adjustNumberOfFractionalDigits(polyline);
                    Map<Point, Integer> crossings = this.getCrossings(polyline, polygonList);
                    String currentID = data.get(i).get(columnNames.indexOf(roadID.replaceFirst("column:", "")));
                    currentID = currentID.replace(" ", "");
                    String currentClass = null;
                    currentClass = roadClass.startsWith("column:") ? data.get(i).get(columnNames.indexOf(roadClass.replaceFirst("column:", ""))) : roadClass;
                    for (Map.Entry<Point, Integer> entry : crossings.entrySet()) {
                        int loc1 = entry.getKey().x;
                        int loc2 = entry.getKey().y;
                        int numCrossings = entry.getValue();
                        graph.putEdge(this.createRoadTransportEdge(nodeList.get(loc1), nodeList.get(loc2), currentID, currentClass, numCrossings));
                    }
                } else {
                    System.err.println("Road Shapefile contains non-polyline");
                }
                ++i;
            }
        }
    }

    private void processMigrationShapefiles(Graph graph, List<Node> nodeList, List<ShpPolygon> polygonList) {
        for (Shapefile s : this.shapefiles) {
            if (!(s instanceof MigrationShapefile)) continue;
            MigrationShapefile shapefile = (MigrationShapefile)s;
            List<ShpRecord> shapeList = null;
            List<List<String>> data = null;
            List<String> columnNames = null;
            String migrationID = shapefile.getId();
            String migrationPopulation = shapefile.getPopulationName();
            String migrationRate = shapefile.getMigrationRate();
            try {
                Reader reader = new Reader(shapefile.getFileName());
                shapeList = reader.getShapeList();
                data = reader.getData();
                columnNames = reader.getColumnNames();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int i = 0;
            while (i < shapeList.size()) {
                ShpRecord shape = shapeList.get(i);
                if (shape instanceof ShpPolyLine) {
                    ShpPolyLine polyline = (ShpPolyLine)shape;
                    this.adjustNumberOfFractionalDigits(polyline);
                    Map<Point, Integer> crossings = this.getCrossings(polyline, polygonList);
                    String currentID = data.get(i).get(columnNames.indexOf(migrationID.replaceFirst("column:", "")));
                    currentID = currentID.replace(" ", "");
                    String currentPopulation = null;
                    double currentRate = 0.0;
                    currentPopulation = migrationPopulation.startsWith("column:") ? data.get(i).get(columnNames.indexOf(migrationPopulation.replaceFirst("column:", ""))) : migrationPopulation;
                    currentRate = migrationRate.startsWith("column:") ? Double.parseDouble(data.get(i).get(columnNames.indexOf(migrationRate.replaceFirst("column:", "")))) : Double.parseDouble(migrationRate);
                    for (Map.Entry<Point, Integer> entry : crossings.entrySet()) {
                        int loc1 = entry.getKey().x;
                        int loc2 = entry.getKey().y;
                        int numCrossings = entry.getValue();
                        graph.putEdge((Edge)this.createMigrationEdge(nodeList.get(loc1), nodeList.get(loc2), currentID, currentPopulation, (double)numCrossings * currentRate));
                        graph.putEdge((Edge)this.createMigrationEdge(nodeList.get(loc2), nodeList.get(loc1), currentID, currentPopulation, (double)numCrossings * currentRate));
                    }
                } else {
                    System.err.println("Migration Shapefile contains non-polyline");
                }
                ++i;
            }
        }
    }

    private void processCommonBorderCreation(Graph graph, List<Node> nodeHolder, List<ShpPolygon> polygonList) {
        int n = polygonList.size();
        ArrayList<Rectangle2D.Double> boundingBoxList = new ArrayList<Rectangle2D.Double>(n);
        for (ShpPolygon p : polygonList) {
            Box b = p.getBoundingBox();
            boundingBoxList.add(new Rectangle2D.Double(b.getXMin(), b.getYMin(), b.getXMax() - b.getXMin(), b.getYMax() - b.getYMin()));
        }
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                double borderLength;
                Rectangle2D intersection = ((Rectangle2D)boundingBoxList.get(i)).createIntersection((Rectangle2D)boundingBoxList.get(j));
                if (intersection.getWidth() >= 0.0 && intersection.getHeight() >= 0.0 && (borderLength = this.commonBorderLength(polygonList.get(i), polygonList.get(j))) > 0.0) {
                    graph.putEdge(this.createCommonBorderEdge(nodeHolder.get(i), nodeHolder.get(j), borderLength));
                }
                ++j;
            }
            ++i;
        }
    }

    private Map<Point, Integer> getCrossings(ShpPolyLine polyline, List<ShpPolygon> polygonList) {
        HashMap<Point, Integer> crossings = new HashMap<Point, Integer>();
        Part[] partArray = polyline.getParts();
        int n = partArray.length;
        int n2 = 0;
        while (n2 < n) {
            Part p = partArray[n2];
            double[] xs = p.getXs();
            double[] ys = p.getYs();
            int lastContainingPolygon = -1;
            int i = 0;
            while (i < xs.length) {
                int containingPolygon = this.getContainingPolygon(xs[i], ys[i], polygonList, lastContainingPolygon);
                if (containingPolygon != lastContainingPolygon && containingPolygon != -1 && lastContainingPolygon != -1) {
                    int loc2;
                    int loc1 = Math.min(lastContainingPolygon, containingPolygon);
                    Integer n3 = (Integer)crossings.get(new Point(loc1, loc2 = Math.max(lastContainingPolygon, containingPolygon)));
                    if (n3 != null) {
                        crossings.put(new Point(loc1, loc2), n3 + 1);
                    } else {
                        crossings.put(new Point(loc1, loc2), 1);
                    }
                }
                lastContainingPolygon = containingPolygon;
                ++i;
            }
            ++n2;
        }
        return crossings;
    }

    private int getContainingPolygon(double x, double y, List<ShpPolygon> esriPolygonLists, int guess) {
        int n;
        if (guess != -1) {
            ShpPolygon list = esriPolygonLists.get(guess);
            Part[] partArray = list.getParts();
            n = partArray.length;
            int n2 = 0;
            while (n2 < n) {
                Part p = partArray[n2];
                if (this.isPointInPolygon(x, y, p)) {
                    return guess;
                }
                ++n2;
            }
        }
        int i = 0;
        while (i < esriPolygonLists.size()) {
            ShpPolygon list = esriPolygonLists.get(i);
            if (i != guess) {
                Part[] partArray = list.getParts();
                int n3 = partArray.length;
                n = 0;
                while (n < n3) {
                    Part p = partArray[n];
                    if (this.isPointInPolygon(x, y, p)) {
                        return i;
                    }
                    ++n;
                }
            }
            ++i;
        }
        return -1;
    }

    private LatLong createSTEMPolygon(ShpPolygon polygon) {
        LatLong retValue = new LatLong();
        Part[] partArray = polygon.getParts();
        int n = partArray.length;
        int n2 = 0;
        while (n2 < n) {
            Part p = partArray[n2];
            LatLong.SegmentBuilder sb = new LatLong.SegmentBuilder();
            double[] xs = p.getXs();
            double[] ys = p.getYs();
            int i = 0;
            while (i < xs.length) {
                double latitude = ys[i];
                double longitude = xs[i];
                sb.add(latitude, longitude);
                ++i;
            }
            retValue.add(sb.toSegment());
            ++n2;
        }
        return retValue;
    }

    private Region createRegionNode(String regionName) {
        Region node = NodesFactory.eINSTANCE.createRegion();
        node.getDublinCore().setTitle(regionName);
        node.setURI(STEMURI.createURI((String)("node/geo/region/" + this.makeURICompatible(regionName))));
        return node;
    }

    private AreaLabel createAreaLabel(double area) {
        AreaLabel areaLabel = LabelsFactory.eINSTANCE.createAreaLabel();
        areaLabel.getCurrentAreaValue().setArea(area);
        return areaLabel;
    }

    private PopulationLabel createPopulationLabel(String populationName, double populationSize) {
        PopulationLabel popLabel = LabelsFactory.eINSTANCE.createPopulationLabel();
        popLabel.setPopulationIdentifier(populationName);
        popLabel.getCurrentPopulationValue().setCount(populationSize);
        return popLabel;
    }

    private Edge createRoadTransportEdge(Node nodeA, Node nodeB, String roadID, String roadClass, int numCrossings) {
        Edge edge = RoadTransportRelationshipLabelImpl.createRoadTransportRelationship((Node)nodeA, (Node)nodeB, (String)roadID, (String)roadClass, (int)numCrossings);
        edge.setURI(STEMURI.createURI((String)("edge/" + nodeA.getURI().lastSegment() + "_" + nodeB.getURI().lastSegment() + "_" + this.makeURICompatible(roadID))));
        edge.getDublinCore().setTitle(roadID);
        return edge;
    }

    private MigrationEdge createMigrationEdge(Node nodeA, Node nodeB, String migrationID, String migrationPopulation, double migrationRate) {
        MigrationEdge mEdge = EdgesFactory.eINSTANCE.createMigrationEdge();
        mEdge.setURI(STEMURI.createURI((String)("edge/migration/" + nodeA.getURI().lastSegment() + "_" + nodeB.getURI().lastSegment() + "_" + this.makeURICompatible(migrationID))));
        mEdge.setNodeAURI(nodeA.getURI());
        mEdge.setNodeBURI(nodeB.getURI());
        mEdge.getLabel().setURIOfIdentifiableToBeLabeled(mEdge.getURI());
        mEdge.getLabel().getCurrentValue().setMigrationRate(migrationRate);
        mEdge.getDublinCore().setTitle(migrationID);
        mEdge.setPopulationIdentifier(migrationPopulation);
        return mEdge;
    }

    private Edge createCommonBorderEdge(Node nodeA, Node nodeB, double borderLength) {
        Edge edge = CommonBorderRelationshipLabelImpl.createCommonBorderRelationship((Node)nodeA, (Node)nodeB, (double)borderLength);
        String sEdge = edge.getURI().toString();
        int last = sEdge.lastIndexOf("/");
        String sEdge1 = sEdge.substring(0, last);
        String sEdge2 = sEdge.substring(last, sEdge.length());
        URI newURI = URI.createURI((String)(String.valueOf(sEdge1) + "/relationship/commonborder" + sEdge2));
        edge.setURI(newURI);
        edge.getDublinCore().setTitle("Edge[(" + nodeA.getDublinCore().getTitle() + ")<->(" + nodeB.getDublinCore().getTitle() + ")]");
        return edge;
    }

    private double commonBorderLength(ShpPolygon a, ShpPolygon b) {
        double[] ys;
        double[] xs;
        Part p;
        double border_length = 0.0;
        HashSet<Point2D.Double> bPoints = new HashSet<Point2D.Double>();
        Part[] partArray = b.getParts();
        int n = partArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = partArray[n2];
            xs = p.getXs();
            ys = p.getYs();
            int i = 0;
            while (i < xs.length) {
                bPoints.add(new Point2D.Double(xs[i], ys[i]));
                ++i;
            }
            ++n2;
        }
        partArray = a.getParts();
        n = partArray.length;
        n2 = 0;
        while (n2 < n) {
            p = partArray[n2];
            xs = p.getXs();
            ys = p.getYs();
            Point2D.Double p1 = null;
            int i = 0;
            while (i < xs.length) {
                Point2D.Double p2 = new Point2D.Double(xs[i], ys[i]);
                if (bPoints.contains(p2)) {
                    if (p1 != null) {
                        border_length += this.getDistanceInKM(p1.y, p1.x, p2.y, p2.x, false);
                    }
                    p1 = p2;
                } else {
                    p1 = null;
                }
                ++i;
            }
            ++n2;
        }
        return border_length;
    }

    private double getDistanceInKM(double lat1, double lon1, double lat2, double lon2, boolean approx) {
        double value;
        lat1 = Math.toRadians(lat1);
        lon1 = Math.toRadians(lon1);
        lat2 = Math.toRadians(lat2);
        lon2 = Math.toRadians(lon2);
        if (approx) {
            double x = (lon2 - lon1) * Math.cos((lat1 + lat2) / 2.0);
            double y = lat2 - lat1;
            value = Math.sqrt(x * x + y * y) * 6731.0;
        } else {
            value = Math.acos(Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1)) * 6731.0;
        }
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            value = 0.0;
        }
        return value;
    }

    private boolean isPointInPolygon(double x, double y, Part poly) {
        double[] xs = poly.getXs();
        double[] ys = poly.getYs();
        int n = xs.length;
        int hits = 0;
        double x1 = xs[n - 1];
        double y1 = ys[n - 1];
        int i = 0;
        while (i < n) {
            double xProjection;
            double x2 = xs[i];
            double y2 = ys[i];
            if (y == y2) {
                double y3;
                if (x < x2 && y > Math.min(y1, y3 = ys[(i + 1) % n]) && y < Math.max(y1, y3)) {
                    ++hits;
                }
            } else if (y > Math.min(y1, y2) && y < Math.max(y1, y2) && x < (xProjection = (x2 - x1) / (y2 - y1) * (y - y1) + x1)) {
                ++hits;
            }
            x1 = x2;
            y1 = y2;
            ++i;
        }
        return hits % 2 != 0;
    }

    private String makeURICompatible(String s) {
        s = s.replaceAll("/", "");
        return s;
    }

    private void adjustNumberOfFractionalDigits(ShpPolyLine poly) {
        double factor = Math.pow(10.0, 6.0);
        Part[] partArray = poly.getParts();
        int n = partArray.length;
        int n2 = 0;
        while (n2 < n) {
            Part p = partArray[n2];
            int i = 0;
            while (i < p.getPointCount()) {
                p.getXs()[i] = Math.rint(p.getXs()[i] * factor) / factor;
                p.getYs()[i] = Math.rint(p.getYs()[i] * factor) / factor;
                ++i;
            }
            ++n2;
        }
    }
}

