/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.explorer;

import java.util.ArrayList;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.explorer.IdentifiableInstanceTreeNode;
import org.eclipse.stem.ui.views.explorer.IdentifiableInstanceTreeNodeContentProvider;
import org.eclipse.stem.ui.views.explorer.IdentifiableTreeNode;

public class DiseaseModelInstanceTreeNodeContentProvider
extends IdentifiableInstanceTreeNodeContentProvider {
    public Object[] getChildren(Object parentElement) {
        Object[] retValue = null;
        if (parentElement instanceof IdentifiableTreeNode) {
            IdentifiableTreeNode itn = (IdentifiableTreeNode)parentElement;
            IFolder folder = itn.getProject().getFolder(itn.getFolderName());
            ArrayList<IdentifiableInstanceTreeNode> temp = new ArrayList<IdentifiableInstanceTreeNode>();
            try {
                IResource[] iResourceArray = folder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource identifiableFile = iResourceArray[n2];
                    if (this.isDiseaseModel(identifiableFile)) {
                        String identifiableName = identifiableFile.getName();
                        String extension = identifiableFile.getFileExtension();
                        String nameWithoutExtension = identifiableName.substring(0, identifiableName.indexOf(extension) - 1);
                        temp.add(new IdentifiableInstanceTreeNode(itn, nameWithoutExtension, extension));
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                Activator.logError((String)"", (Throwable)e);
            }
            retValue = temp.toArray();
        }
        return retValue;
    }

    protected boolean isDiseaseModel(IResource identifiableFile) {
        return identifiableFile.getFileExtension().endsWith("standard");
    }
}

