/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.preferences;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.ScaleFieldEditor;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.adapters.color.IPreferencesContributer;
import org.eclipse.stem.ui.adapters.color.RelativeValueColorPreferences;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MapsColorsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID_STEM_MAPS_COLORS_PAGE = "org.eclipse.stem.ui.preferences.MapsColorsPreferencePage";
    public static final String FOREGROUND_COLOR_ID = "org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolor";
    public static final String BACKGROUND_COLOR_ID = "org.eclipse.stem.ui.views.geographic.map.preferences.backgroundcolor";
    public static final String BORDERS_COLOR_ID = "org.eclipse.stem.ui.views.geographic.map.preferences.borderscolor";
    public static final String BORDERS_ALPHA_ID = "org.eclipse.stem.ui.views.geographic.map.preferences.bordersalpha";
    public static final String EDGES_COLOR_ID = "org.eclipse.stem.ui.views.geographic.map.preferences.edgescolor";
    public static final String FOREGROUND_COLOR_DEFAULT_RGB_STRING = "255,0,0";
    public static final String BACKGROUND_COLOR_DEFAULT_RGB_STRING = "255,255,255";
    public static final String BORDERS_COLOR_DEFAULT_RGB_STRING = "0,80,80";
    public static final int BORDERS_ALPHA_DEFAULT_VALUE = 25;
    public static final String EDGES_COLOR_DEFAULT_RGB_STRING = "255,0,255";
    private static ColorFieldEditor backgroundColorFieldEditor;
    private static ColorFieldEditor foregroundColorFieldEditor;
    private static ColorFieldEditor bordersColorFieldEditor;
    private static ScaleFieldEditor bordersAlphaFieldEditor;
    private static ColorFieldEditor edgesColorFieldEditor;
    private final List<IPreferencesContributer> preferencesExtenders = new CopyOnWriteArrayList<IPreferencesContributer>();

    public MapsColorsPreferencePage() {
        super(1);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Choose the colors to be used for drawing maps");
        RelativeValueColorPreferences preferencesExtender = new RelativeValueColorPreferences();
        preferencesExtender.setPreferencePage(this);
        this.preferencesExtenders.add(preferencesExtender);
    }

    protected void createFieldEditors() {
        backgroundColorFieldEditor = new ColorFieldEditor(BACKGROUND_COLOR_ID, "Background Color", this.getFieldEditorParent());
        foregroundColorFieldEditor = new ColorFieldEditor(FOREGROUND_COLOR_ID, "Foreground Color", this.getFieldEditorParent());
        bordersColorFieldEditor = new ColorFieldEditor(BORDERS_COLOR_ID, "Borders Color", this.getFieldEditorParent());
        bordersAlphaFieldEditor = new ScaleFieldEditor(BORDERS_ALPHA_ID, "Borders Alpha", this.getFieldEditorParent(), 0, 255, 1, 10);
        edgesColorFieldEditor = new ColorFieldEditor(EDGES_COLOR_ID, "Edges Color", this.getFieldEditorParent());
        this.addField((FieldEditor)backgroundColorFieldEditor);
        this.addField((FieldEditor)foregroundColorFieldEditor);
        this.addField((FieldEditor)bordersColorFieldEditor);
        this.addField((FieldEditor)bordersAlphaFieldEditor);
        this.addField((FieldEditor)edgesColorFieldEditor);
        for (IPreferencesContributer preferencesExtender : this.preferencesExtenders) {
            preferencesExtender.createFieldEditors();
        }
    }

    protected void initialize() {
        for (IPreferencesContributer preferencesExtender : this.preferencesExtenders) {
            preferencesExtender.initialize();
        }
        super.initialize();
    }

    public void propertyChange(PropertyChangeEvent event) {
        for (IPreferencesContributer preferencesExtender : this.preferencesExtenders) {
            preferencesExtender.propertyChange(event);
        }
        super.propertyChange(event);
    }

    protected void performDefaults() {
        foregroundColorFieldEditor.getColorSelector().setColorValue(StringConverter.asRGB((String)FOREGROUND_COLOR_DEFAULT_RGB_STRING));
        backgroundColorFieldEditor.getColorSelector().setColorValue(StringConverter.asRGB((String)BACKGROUND_COLOR_DEFAULT_RGB_STRING));
        bordersColorFieldEditor.getColorSelector().setColorValue(StringConverter.asRGB((String)BORDERS_COLOR_DEFAULT_RGB_STRING));
        bordersAlphaFieldEditor.getScaleControl().setSelection(25);
        edgesColorFieldEditor.getColorSelector().setColorValue(StringConverter.asRGB((String)EDGES_COLOR_DEFAULT_RGB_STRING));
        for (IPreferencesContributer preferencesExtender : this.preferencesExtenders) {
            preferencesExtender.performDefaults();
        }
    }

    public void init(IWorkbench arg0) {
    }

    public void addField(FieldEditor editor) {
        super.addField(editor);
    }

    public Composite getFieldEditorParent() {
        return super.getFieldEditorParent();
    }
}

