/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.internal.Activator;
import org.eclipse.tea.library.build.model.FeatureData;
import org.eclipse.tea.library.build.model.PluginData;
import org.eclipse.tea.library.build.services.TeaBuildVersionService;

@Creatable
public class WorkspaceData {
    private static final String JAVA_NATURE = "org.eclipse.jdt.core.javanature";
    private final List<IProject> unknownProjects = new ArrayList<IProject>();
    private final Map<String, PluginData> plugins = new TreeMap<String, PluginData>();
    private final Map<String, FeatureData> features = new TreeMap<String, FeatureData>();

    @Inject
    public WorkspaceData(TaskingLog console, TeaBuildVersionService bvService) {
        this(ResourcesPlugin.getWorkspace(), console, bvService);
    }

    public WorkspaceData(IWorkspace workspace, TaskingLog console, TeaBuildVersionService bvService) {
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!project.exists()) {
                console.error("project doesn't exist: " + project.getName());
            } else if (!project.isOpen()) {
                console.warn("project is closed: " + project.getName());
            } else {
                IProjectDescription desc;
                try {
                    desc = project.getDescription();
                }
                catch (CoreException ex) {
                    throw new IllegalStateException(ex);
                }
                if (WorkspaceData.isPluginProject(project)) {
                    PluginData pd = new PluginData(project);
                    this.plugins.put(pd.getBundleName(), pd);
                } else if (WorkspaceData.isFeatureProject(project)) {
                    FeatureData fd = new FeatureData(project, bvService);
                    this.features.put(fd.getBundleName(), fd);
                } else {
                    if (desc.hasNature(JAVA_NATURE)) {
                        console.warn("skipping plain Java project: " + project.getName());
                    }
                    this.unknownProjects.add(project);
                }
            }
            ++n2;
        }
    }

    public static boolean isBinaryProject(IProject project) {
        return WorkspaceModelManager.isBinaryProject((IProject)project);
    }

    public static boolean isFeatureProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.pde.FeatureNature");
        }
        catch (CoreException e) {
            Activator.log(2, "cannot determine feature nature for " + project, null);
            return false;
        }
    }

    public static boolean isPluginProject(IProject project) {
        return WorkspaceModelManager.isPluginProject((IProject)project);
    }

    public static IProject getProject(String projectName) {
        if (projectName == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project != null && project.exists()) {
            return project;
        }
        return null;
    }

    public Collection<PluginData> getPlugins() {
        return this.plugins.values();
    }

    public Collection<FeatureData> getFeatures() {
        return this.features.values();
    }

    public Collection<IProject> getUnknownProjects() {
        return this.unknownProjects;
    }

    public FeatureData getFeature(String name) {
        return this.features.get(name);
    }

    public PluginData getPlugin(String name) {
        return this.plugins.get(name);
    }
}

