/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.services;

import com.google.common.base.Joiner;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.services.TaskChain;

public interface TaskingAdditionalMenuEntryProvider {
    public List<TaskingAdditionalMenuEntry> getAdditionalEntries();

    public static class TaskingAdditionalMenuEntry
    implements Comparable<TaskingAdditionalMenuEntry> {
        private final TaskChain chain;
        private final String[] path;
        private final String label;
        private final String iconBundle;
        private final String iconPath;
        private final String groupingId;
        private final boolean developerOnly;

        public TaskingAdditionalMenuEntry(TaskChain chain, String[] path, String iconUri, String groupingId, boolean dev) {
            this(chain, TaskingModel.getTaskChainName(chain), path, TaskingAdditionalMenuEntry.getIconBundle(iconUri), TaskingAdditionalMenuEntry.getIconPath(iconUri), groupingId, dev);
        }

        protected static String getIconBundle(String iconUri) {
            if (iconUri == null) {
                return null;
            }
            Assert.isLegal((boolean)iconUri.startsWith("platform:/plugin"), (String)"URI must be of platform:/plugin scheme");
            String sub = iconUri.substring("platform:/plugin/".length());
            return sub.substring(0, sub.indexOf(47));
        }

        protected static String getIconPath(String iconUri) {
            if (iconUri == null) {
                return null;
            }
            Assert.isLegal((boolean)iconUri.startsWith("platform:/plugin"), (String)"URI must be of platform:/plugin scheme");
            String sub = iconUri.substring("platform:/plugin/".length());
            return sub.substring(sub.indexOf(47) + 1);
        }

        public TaskingAdditionalMenuEntry(TaskChain chain, String label, String[] path, String bundle, String icon, String groupingId, boolean developerOnly) {
            this.chain = chain;
            this.label = label;
            this.path = path;
            this.iconBundle = bundle;
            this.iconPath = icon;
            this.groupingId = groupingId != null ? groupingId : "none";
            this.developerOnly = developerOnly;
        }

        public TaskChain getTaskChain() {
            return this.chain;
        }

        public String[] getMenuPath() {
            return this.path;
        }

        public String getLabel() {
            return this.label;
        }

        public String getIconBundleName() {
            return this.iconBundle;
        }

        public String getIconPath() {
            return this.iconPath;
        }

        public String getGroupingId() {
            return this.groupingId;
        }

        public boolean isDeveloperOnly() {
            return this.developerOnly;
        }

        public String getMenuId() {
            if (this.path == null) {
                return this.label;
            }
            return String.valueOf(Joiner.on((char)'/').join((Object[])this.path)) + "/" + this.label;
        }

        @Override
        public int compareTo(TaskingAdditionalMenuEntry o) {
            return this.getMenuId().compareTo(o.getMenuId());
        }
    }
}

