/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui;

import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tea.core.internal.TimeHelper;
import org.eclipse.tea.core.internal.config.CoreConfig;
import org.eclipse.tea.core.internal.config.TaskingDevelopmentConfig;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.core.ui.Activator;
import org.eclipse.tea.core.ui.config.TaskingConsoleConfig;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.service.component.annotations.Component;

@TaskingLog.TaskingLogQualifier(headless=false)
@Component(service={TaskingLog.class})
public class TaskingConsole
extends TaskingLog {
    private static final String TASKING_CONSOLE = "Tasking Console";
    private static final ImageDescriptor TEA_ICON = Activator.imageDescriptorFromPlugin((String)"org.eclipse.tea.core.ui", (String)"resources/tea.png");
    public PrintStream outInfo;
    public PrintStream outStd;
    public PrintStream outWrn;
    public PrintStream outErr;
    private volatile MessageConsole myConsole;
    private volatile MessageConsoleStream sInfo;
    private volatile MessageConsoleStream sStd;
    private volatile MessageConsoleStream sWrn;
    private volatile MessageConsoleStream sErr;
    private CoreConfig cfg;
    private volatile TaskingConsoleConfig config;

    @TaskingLog.TaskingLogInit
    public void init(TaskingConsoleConfig config, TaskingDevelopmentConfig devConfig, CoreConfig coreCfg) {
        this.cfg = coreCfg;
        this.config = config;
        this.setShowDebug(devConfig.showDebugLogs);
        if (this.myConsole == null) {
            this.myConsole = TaskingConsole.findConsole(TASKING_CONSOLE);
            this.sInfo = this.myConsole.newMessageStream();
            this.sStd = this.myConsole.newMessageStream();
            this.sWrn = this.myConsole.newMessageStream();
            this.sErr = this.myConsole.newMessageStream();
            this.outInfo = new PrintStream((OutputStream)this.sInfo);
            this.outStd = new PrintStream((OutputStream)this.sStd);
            this.outWrn = new PrintStream((OutputStream)this.sWrn);
            this.outErr = new PrintStream((OutputStream)this.sErr);
            this.myConsole.activate();
        }
        Display.getDefault().asyncExec(this::updateConfig);
    }

    public void bringToFront() {
        if (this.myConsole != null) {
            this.myConsole.activate();
        }
    }

    void updateConfig() {
        if (this.cfg.useAccessibleMode.booleanValue()) {
            this.myConsole.setConsoleWidth(80);
        } else {
            this.myConsole.setConsoleWidth(0);
        }
        if (this.config.useColors.booleanValue()) {
            boolean isDarkTheme = ((IThemeEngine)Display.getDefault().getData("org.eclipse.e4.ui.css.swt.theme")).getActiveTheme().getLabel().equals("Dark");
            if (this.config.useDarkColors.booleanValue() || isDarkTheme) {
                this.sInfo.setColor(new Color(null, 164, 164, 164));
                this.sStd.setColor(new Color(null, 255, 255, 255));
                this.sWrn.setColor(new Color(null, 255, 190, 50));
                this.sErr.setColor(new Color(null, 255, 100, 100));
            } else {
                this.sInfo.setColor(new Color(null, 164, 164, 164));
                this.sStd.setColor(new Color(null, 32, 32, 32));
                this.sWrn.setColor(new Color(null, 255, 190, 0));
                this.sErr.setColor(new Color(null, 255, 0, 0));
            }
        } else {
            this.sInfo.setColor(null);
            this.sStd.setColor(null);
            this.sWrn.setColor(null);
            this.sErr.setColor(null);
        }
    }

    public void flush() {
        this.outInfo.flush();
        this.outStd.flush();
        this.outWrn.flush();
        this.outErr.flush();
    }

    protected void finalize() throws Throwable {
        TaskingConsole.close(this.sInfo);
        TaskingConsole.close(this.sStd);
        TaskingConsole.close(this.sWrn);
        TaskingConsole.close(this.sErr);
        super.finalize();
    }

    private static void close(MessageConsoleStream s) {
        try {
            if (s != null && !s.isClosed()) {
                s.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static MessageConsole findConsole(String name) {
        try {
            IConsole[] existing;
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            IConsoleManager conMan = plugin.getConsoleManager();
            IConsole[] iConsoleArray = existing = conMan.getConsoles();
            int n = existing.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole ic = iConsoleArray[n2];
                if (name.equals(ic.getName())) {
                    return (MessageConsole)ic;
                }
                ++n2;
            }
            MessageConsole myConsole = new MessageConsole(name, TEA_ICON);
            MessageConsoleStream stream = myConsole.newMessageStream();
            try {
                conMan.addConsoles(new IConsole[]{myConsole});
            }
            finally {
                if (!stream.isClosed()) {
                    stream.close();
                }
            }
            return myConsole;
        }
        catch (Exception ex) {
            throw new RuntimeException("cannot create console", ex);
        }
    }

    public PrintStream debug() {
        return this.outInfo;
    }

    public PrintStream info() {
        return this.outStd;
    }

    public PrintStream warn() {
        return this.outWrn;
    }

    public PrintStream error() {
        return this.outErr;
    }

    public String formatMessage(String msg) {
        if (this.cfg == null || !this.cfg.useAccessibleMode.booleanValue()) {
            return super.formatMessage(msg);
        }
        return TimeHelper.getFormattedCurrentTime() + "\n" + msg;
    }
}

