/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponsePushbackMessage;
import org.eclipse.actf.util.httpproxy.core.IMessageBody;
import org.eclipse.actf.util.httpproxy.core.IPushbackMessageBody;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkedMessageBodyReader;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseInMemoryMessage;
import org.eclipse.actf.util.internal.httpproxy.core.PushbackMessageBody;

public class HTTPResponsePushbackMessage
extends HTTPResponseInMemoryMessage
implements IHTTPResponsePushbackMessage {
    public HTTPResponsePushbackMessage(long l, byte[] byArray, byte[] byArray2, byte[] byArray3, IMessageBody iMessageBody, int n) {
        super(l, byArray, byArray2, byArray3);
        if (iMessageBody != null) {
            InputStream inputStream = iMessageBody.getMessageBodyTimeoutInputStream();
            PushbackMessageBody pushbackMessageBody = iMessageBody.isChunkedEncoding() ? new PushbackMessageBody(inputStream, n) : new PushbackMessageBody(inputStream, n, iMessageBody.getContentLength());
            super.setOriginalMessageBody(pushbackMessageBody);
        }
    }

    public byte[] readBody(long l, boolean bl) throws IOException, TimeoutException {
        PushbackMessageBody pushbackMessageBody = (PushbackMessageBody)this.getMessageBody();
        if (pushbackMessageBody == null) {
            return null;
        }
        InputStream inputStream = pushbackMessageBody.getMessageBodyInputStream();
        int n = pushbackMessageBody.getContentLength();
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (n >= 0) {
            int n2 = 0;
            while (n2 < n) {
                byteArrayOutputStream.write(inputStream.read());
                ++n2;
            }
        } else {
            ChunkedMessageBodyReader chunkedMessageBodyReader = new ChunkedMessageBodyReader(inputStream);
            chunkedMessageBodyReader.readChunkedMessage(l, byteArrayOutputStream, this);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (bl) {
            PushbackInputStream pushbackInputStream = pushbackMessageBody.getMessageBodyPushBackInputStream();
            pushbackInputStream.unread(byArray);
        }
        return byArray;
    }

    public HTTPResponsePushbackMessage(IHTTPResponseMessage iHTTPResponseMessage, int n) {
        this(iHTTPResponseMessage.getSerial(), iHTTPResponseMessage.getHTTPVersionAsBytes(), iHTTPResponseMessage.getStatusCodeAsBytes(), iHTTPResponseMessage.getReasonPhraseAsBytes(), iHTTPResponseMessage.getMessageBody(), n);
        this.setBaseHeaders(iHTTPResponseMessage);
    }

    public IPushbackMessageBody getPushbackMessageBody() {
        return (PushbackMessageBody)this.getMessageBody();
    }
}

