/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.jar;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipExploder {
    private Logger logger = Logger.getLogger("org.eclipse.actf.core");
    protected boolean verbose;
    protected boolean sortNames;

    public ZipExploder() {
        this(false);
    }

    public ZipExploder(boolean bl) {
        this.setVerbose(bl);
    }

    public ZipExploder(boolean bl, boolean bl2) {
        this(bl);
        this.setSortNames(bl2);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getSortNames() {
        return this.sortNames;
    }

    public void setSortNames(boolean bl) {
        this.sortNames = bl;
    }

    public void process(String[] stringArray, String[] stringArray2, String string) throws IOException {
        this.processZips(stringArray, string);
        this.processJars(stringArray2, string);
    }

    public void processJars(String[] stringArray, String string) throws IOException {
        int n = 0;
        while (n < stringArray.length) {
            this.processFile(stringArray[n], string);
            ++n;
        }
    }

    public void processZips(String[] stringArray, String string) throws IOException {
        int n = 0;
        while (n < stringArray.length) {
            this.processFile(stringArray[n], string);
            ++n;
        }
    }

    public void processFile(String string, String string2) throws IOException {
        String string3 = new File(string).getCanonicalPath();
        String string4 = new File(string2).getCanonicalPath();
        if (this.verbose) {
            this.logger.log(Level.FINE, "\n**** Exploding " + string3 + " to " + string4);
        }
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(string3);
                Map map = this.getEntries(zipFile);
                Object[] objectArray = map.keySet().toArray(new String[0]);
                if (this.sortNames) {
                    Arrays.sort(objectArray);
                }
                int n = 0;
                while (n < objectArray.length) {
                    Object object = objectArray[n];
                    ZipEntry zipEntry = (ZipEntry)map.get(object);
                    this.copyFileEntry(string4, zipFile, zipEntry);
                    ++n;
                }
            }
            catch (IOException iOException) {
                String string5 = iOException.getMessage();
                if (string5.indexOf(string) < 0) {
                    string5 = String.valueOf(string5) + " - " + string;
                }
                throw new IOException(string5);
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected Map getEntries(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        HashMap<String, ZipEntry> hashMap = new HashMap<String, ZipEntry>();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            hashMap.put(zipEntry.getName(), zipEntry);
        }
        return hashMap;
    }

    public void copyFileEntry(String string, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(zipFile.getInputStream(zipEntry)));
        try {
            this.copyFileEntry(string, zipEntry.isDirectory(), zipEntry.getName(), dataInputStream);
        }
        catch (Throwable throwable) {
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            dataInputStream.close();
        }
        catch (IOException iOException) {}
    }

    protected void copyFileEntry(String string, boolean bl, String string2, DataInputStream dataInputStream) throws IOException {
        File file;
        byte[] byArray = this.readAllBytes(dataInputStream);
        this.logger.log(Level.FINE, "Writing " + byArray.length + " bytes...");
        File file2 = new File(string2);
        String string3 = file2.getParent();
        if (string3 != null && string3.length() > 0 && (file = new File(string, string3)) != null) {
            this.logger.log(Level.FINE, "Creating directory path " + file.getAbsolutePath());
            file.mkdirs();
            this.logger.log(Level.FINE, "Created directory path " + file.getAbsolutePath());
        }
        file = new File(string, string2);
        if (bl) {
            this.logger.log(Level.FINE, "Creating directory " + file.getAbsolutePath());
            file.mkdir();
            this.logger.log(Level.FINE, "Created directory " + file.getAbsolutePath());
        } else {
            this.logger.log(Level.FINE, "Creating file " + file.getAbsolutePath());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                fileOutputStream.write(byArray, 0, byArray.length);
                if (this.verbose) {
                    this.logger.log(Level.FINE, "Copied file " + file.getAbsolutePath());
                }
            }
            catch (Throwable throwable) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected byte[] readAllBytes(DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[]{};
        int n = dataInputStream.available();
        while (n > 0) {
            byte[] byArray2 = new byte[n];
            int n2 = dataInputStream.read(byArray2);
            this.logger.log(Level.FINE, "readAllBytes: " + n + " vs. " + n2);
            if (n2 > 0) {
                byte[] byArray3 = new byte[byArray.length + n2];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, n2);
                byArray = byArray3;
            } else if (n2 < 0) break;
            n = dataInputStream.available();
        }
        return byArray;
    }

    protected void print(String string) {
        System.out.print(string);
    }

    protected static void printHelp() {
        System.out.println();
        System.out.println("Usage: java " + ZipExploder.class.getName() + " (-jar jarFilename... | -zip zipFilename...)... -dir destDir {-verbose}");
        System.out.println("Where:");
        System.out.println("  jarFilename path to source jar, may repeat");
        System.out.println("  zipFilename path to source zip, may repeat");
        System.out.println("  destDir    path to target directory; should exist");
        System.out.println("Note: one -jar or -zip is required; switch case or order is not important");
    }

    protected static void reportError(String string) {
        System.err.println(string);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            ZipExploder.printHelp();
            System.exit(0);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2.charAt(0) == '-') {
                if ((string2 = string2.substring(1)).equalsIgnoreCase("jar")) {
                    bl = true;
                    bl2 = false;
                    bl3 = false;
                } else if (string2.equalsIgnoreCase("zip")) {
                    bl2 = true;
                    bl = false;
                    bl3 = false;
                } else if (string2.equalsIgnoreCase("dir")) {
                    bl = false;
                    bl2 = false;
                    bl3 = true;
                } else if (string2.equalsIgnoreCase("verbose")) {
                    bl4 = true;
                } else {
                    ZipExploder.reportError("Invalid switch - " + string2);
                }
            } else if (bl) {
                arrayList2.add(string2);
            } else if (bl2) {
                arrayList.add(string2);
            } else if (bl3) {
                if (string != null) {
                    ZipExploder.reportError("duplicate argument - -destDir");
                }
                string = string2;
            } else {
                ZipExploder.reportError("Too many parameters - " + string2);
            }
            ++n;
        }
        if (string == null || arrayList.size() + arrayList2.size() == 0) {
            ZipExploder.reportError("Missing parameters");
        }
        if (bl4) {
            System.out.println("Effective command: " + ZipExploder.class.getName() + " " + (arrayList2.size() > 0 ? "-jars " + arrayList2 + " " : "") + (arrayList.size() > 0 ? "-zips " + arrayList + " " : "") + "-dir " + string);
        }
        try {
            ZipExploder zipExploder = new ZipExploder(bl4);
            zipExploder.process(arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]), string);
        }
        catch (IOException iOException) {
            System.err.println("Exception - " + iOException.getMessage());
            iOException.printStackTrace();
            System.exit(2);
        }
    }
}

