/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import org.eclipse.actf.util.resources.ClassLoaderCache;
import org.eclipse.actf.util.resources.IResourceLocator;

public class DefaultResourceLocator
implements IResourceLocator {
    public InputStream getResourceAsStream(String string) {
        return this.getResourceAsStream(string, this.getClass().getClassLoader());
    }

    public InputStream getResourceAsStream(String string, ClassLoader classLoader) {
        String string2 = System.getProperty(string);
        return this.getResourceAsBufferedStream(string2 != null ? string2 : string, classLoader);
    }

    public InputStream getResourceAsStream(String string, String string2, String string3, ClassLoader classLoader) {
        String string4 = System.getProperty(string);
        return this.getResourceAsBufferedStream(string4 != null ? string4 : string, string2, string3, classLoader);
    }

    protected InputStream makeBufferedStream(InputStream inputStream) {
        if (inputStream != null && !(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        return inputStream;
    }

    protected InputStream getResourceAsBufferedStream(String string, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return this.makeBufferedStream(classLoader.getResourceAsStream(string));
    }

    protected InputStream getResourceAsBufferedStream(String string, String string2, String string3, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        String string4 = string;
        if (string2 != null) {
            string4 = String.valueOf(string2) + "/" + string4;
        }
        if (string3 != null) {
            string4 = String.valueOf(string4) + "." + string3;
        }
        return this.makeBufferedStream(classLoader.getResourceAsStream(string4));
    }

    public URL getResource(String string) {
        return ClassLoaderCache.getDefault().getResource(string);
    }

    public URL[] getResources(String string) {
        LinkedList<URL> linkedList = new LinkedList<URL>();
        Enumeration enumeration = null;
        try {
            enumeration = ClassLoaderCache.getDefault().getResources(string);
        }
        catch (IOException iOException) {}
        while (enumeration != null && enumeration.hasMoreElements()) {
            linkedList.add((URL)enumeration.nextElement());
        }
        return linkedList.toArray(new URL[linkedList.size()]);
    }

    public String getPath(String string) {
        String string2 = null;
        URL uRL = this.getResource(string);
        if (uRL != null) {
            string2 = uRL.toString();
        }
        return string2;
    }

    public String[] getPaths(String string) {
        String[] stringArray = null;
        URL[] uRLArray = this.getResources(string);
        if (uRLArray != null) {
            stringArray = new String[uRLArray.length];
            int n = 0;
            while (n < uRLArray.length) {
                if (uRLArray[n] != null) {
                    stringArray[n] = uRLArray[n].toString();
                }
                ++n;
            }
        }
        return stringArray;
    }
}

