/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.io;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;

public class PBMReader {
    public static BinaryImage readBinaryImage(String string) throws LowVisionIOException {
        String string2;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new LowVisionIOException("The file was not found: " + string);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        try {
            char c = (char)bufferedReader.read();
            char c2 = (char)bufferedReader.read();
            if (c != 'P' || c2 != '1') {
                bufferedReader.close();
                throw new LowVisionIOException("Bad magic number: " + c + c2 + "\n\"P4\" cannot be treated in this version.\n(Only \"P1\" is accepted.)");
            }
        }
        catch (IOException iOException) {
            throw new LowVisionIOException("IOException occurred while reading the magic number.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf("#");
                if (n == -1) {
                    stringBuffer.append(String.valueOf(string2) + "\n");
                    continue;
                }
                stringBuffer.append(String.valueOf(string2.substring(0, n)) + "\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LowVisionIOException("IO error occurred when reading.");
        }
        string2 = stringBuffer.toString();
        if (!Character.isWhitespace(string2.charAt(0))) {
            throw new LowVisionIOException("The magic number must be followed by a white space.");
        }
        string2 = string2.substring(1);
        Pattern pattern = Pattern.compile("(\\d+)\\s(\\d+)\\s([01\\s]+)");
        Matcher matcher = pattern.matcher(string2);
        if (!matcher.find()) {
            throw new LowVisionIOException("Invalid data format (1).");
        }
        int n = matcher.groupCount();
        if (n != 3) {
            throw new LowVisionIOException("Invalid data format (2). count = " + n);
        }
        int n2 = Integer.parseInt(matcher.group(1));
        int n3 = Integer.parseInt(matcher.group(2));
        String string3 = matcher.group(3);
        Pattern pattern2 = Pattern.compile("\\s+");
        Matcher matcher2 = pattern2.matcher(string3);
        String string4 = matcher2.replaceAll("");
        if (string4.length() != n2 * n3) {
            throw new LowVisionIOException("Data size does not equal to width*height");
        }
        BinaryImage binaryImage = new BinaryImage(n2, n3);
        byte[][] byArray = binaryImage.getData();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = 0;
            while (n6 < n2) {
                if (string4.charAt(n4) == '1') {
                    byArray[n5][n6] = 1;
                }
                ++n4;
                ++n6;
            }
            ++n5;
        }
        return binaryImage;
    }
}

