/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.draw.impl;

import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.ODFParser;
import org.eclipse.actf.model.dom.odf.base.ContentBaseElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.impl.EmbedDrawingObjectElementImpl;
import org.eclipse.actf.model.dom.odf.draw.ObjectElement;
import org.eclipse.actf.model.dom.odf.office.BodyElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.w3c.dom.Element;

class ObjectElementImpl
extends EmbedDrawingObjectElementImpl
implements ObjectElement {
    private static final long serialVersionUID = 3713511152465032919L;

    protected ObjectElementImpl(ODFDocument oDFDocument, Element element) {
        super(oDFDocument, element);
    }

    public void setAttrXlinkHref(String string) {
        if (string == null) {
            this.removeAttributeNS("http://www.w3.org/1999/xlink", "href");
            return;
        }
        this.setAttributeNS("http://www.w3.org/1999/xlink", "href", string.trim());
    }

    public String getAttrDrawNotifyOnUpdateOfRanges() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "notify-on-update-of-ranges")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "notify-on-update-of-ranges");
        }
        return null;
    }

    public String getAttrXlinkHref() {
        if (this.hasAttributeNS("http://www.w3.org/1999/xlink", "href")) {
            return this.getAttributeNS("http://www.w3.org/1999/xlink", "href");
        }
        return null;
    }

    public String getAttrXlinkType() {
        if (this.hasAttributeNS("http://www.w3.org/1999/xlink", "type")) {
            return this.getAttributeNS("http://www.w3.org/1999/xlink", "type");
        }
        return null;
    }

    public String getAttrXlinkShow() {
        if (this.hasAttributeNS("http://www.w3.org/1999/xlink", "show")) {
            return this.getAttributeNS("http://www.w3.org/1999/xlink", "show");
        }
        return null;
    }

    public String getAttrXlinkActuate() {
        if (this.hasAttributeNS("http://www.w3.org/1999/xlink", "actuate")) {
            return this.getAttributeNS("http://www.w3.org/1999/xlink", "actuate");
        }
        return null;
    }

    public boolean isPresentationTable() {
        ODFParser oDFParser;
        ODFDocument oDFDocument;
        ODFDocument oDFDocument2 = (ODFDocument)this.getOwnerDocument();
        DocumentContentElement documentContentElement = (DocumentContentElement)oDFDocument2.getDocumentElement();
        ODFConstants.ContentType contentType = documentContentElement.getBodyElement().getContent().getContentType();
        if (contentType != ODFConstants.ContentType.PRESENTATION) {
            return false;
        }
        String string = oDFDocument2.getURL();
        String string2 = this.getAttrXlinkHref();
        if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        if ((oDFDocument = (oDFParser = new ODFParser()).getDocument(string, string2 = String.valueOf(string2) + "/" + "content.xml")) == null) {
            return false;
        }
        Element element = oDFDocument.getDocumentElement();
        if (!(element instanceof DocumentContentElement)) {
            return false;
        }
        BodyElement bodyElement = ((DocumentContentElement)element).getBodyElement();
        if (bodyElement == null) {
            return false;
        }
        ContentBaseElement contentBaseElement = bodyElement.getContent();
        return contentBaseElement != null && contentBaseElement.getContentType() == ODFConstants.ContentType.SPREADSHEET;
    }
}

