/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.eval;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.ui.util.HighlightStringListener;
import org.eclipse.actf.visualization.eval.IEvaluationResult;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemVisitor;
import org.eclipse.swt.custom.LineStyleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationResultImpl
implements IEvaluationResult {
    private String _summaryReportUrl;
    private List<IProblemItem> _problemList = new ArrayList<IProblemItem>();
    private String _summaryReportText;
    private String _targetUrl;
    private File _sourceFile = null;
    private boolean showAllGuidelineItems = false;
    private Vector<File> associateFileV = new Vector();
    private LineStyleListener lsl = new HighlightStringListener();

    @Override
    public void setProblemList(List<IProblemItem> list) {
        if (list == null) {
            list = new ArrayList<IProblemItem>();
        }
        this._problemList = list;
    }

    @Override
    public void addProblemItems(Collection<IProblemItem> collection) {
        this._problemList.addAll(collection);
    }

    @Override
    public void addProblemItems(IProblemItem[] iProblemItemArray) {
        if (iProblemItemArray != null) {
            int n = 0;
            while (n < iProblemItemArray.length) {
                this._problemList.add(iProblemItemArray[n]);
                ++n;
            }
        }
    }

    @Override
    public List<IProblemItem> getProblemList() {
        return this._problemList;
    }

    @Override
    public void setSummaryReportText(String string) {
        this._summaryReportText = string;
    }

    @Override
    public String getSummaryReportText() {
        if (this._summaryReportText == null) {
            return "";
        }
        return this._summaryReportText;
    }

    @Override
    public String getSummaryReportUrl() {
        if (this._summaryReportUrl == null) {
            return "";
        }
        return this._summaryReportUrl;
    }

    @Override
    public void setSummaryReportUrl(String string) {
        this._summaryReportUrl = string;
    }

    @Override
    public void accept(IProblemItemVisitor iProblemItemVisitor) {
        for (IProblemItem iProblemItem : this._problemList) {
            iProblemItem.accept(iProblemItemVisitor);
        }
    }

    @Override
    public String getTargetUrl() {
        if (this._targetUrl == null) {
            return "";
        }
        return this._targetUrl;
    }

    @Override
    public void setTargetUrl(String string) {
        this._targetUrl = string;
    }

    @Override
    public File getSourceFile() {
        return this._sourceFile;
    }

    @Override
    public void setSourceFile(File file) {
        this._sourceFile = file;
    }

    @Override
    public boolean isShowAllGuidelineItems() {
        return this.showAllGuidelineItems;
    }

    @Override
    public void setShowAllGuidelineItems(boolean bl) {
        this.showAllGuidelineItems = bl;
    }

    @Override
    public LineStyleListener getLineStyleListener() {
        return this.lsl;
    }

    @Override
    public void setLineStyleListener(LineStyleListener lineStyleListener) {
        if (lineStyleListener != null) {
            this.lsl = lineStyleListener;
        }
    }

    @Override
    public boolean addAssociateFile(File file) {
        if (file != null) {
            return this.associateFileV.add(file);
        }
        return false;
    }

    @Override
    public File[] getAssociateFiles() {
        return this.associateFileV.toArray(new File[this.associateFileV.size()]);
    }

    @Override
    public boolean removeAssociatedFile(File file) {
        return this.associateFileV.remove(file);
    }
}

