/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.distribution.model;

import org.eclipse.linuxtools.tmf.ui.views.distribution.model.BaseDistributionData;

public abstract class DistributionData
extends BaseDistributionData {
    protected boolean fIsFirst;
    protected final int[][] fBuckets;
    protected long fTimeLimit;

    public DistributionData(int[][] buckets) {
        this(2000, buckets);
    }

    public DistributionData(int nbBuckets, int[][] buckets) {
        super(nbBuckets);
        this.fBuckets = buckets;
        this.clear();
    }

    public long getTimeLimit() {
        return this.fTimeLimit;
    }

    public void clear() {
        super.clear();
        this.fIsFirst = true;
        this.updateEndTime();
    }

    public boolean isFirst() {
        return this.fIsFirst;
    }

    public int countEvent(long timestamp) {
        if (this.fIsFirst) {
            this.fIsFirst = false;
            this.fFirstBucketTime = timestamp;
            this.fFirstEventTime = timestamp;
            this.updateEndTime();
        }
        if (timestamp < this.fFirstEventTime) {
            this.fFirstEventTime = timestamp;
        }
        if (this.fLastEventTime < timestamp) {
            this.fLastEventTime = timestamp;
        }
        if (timestamp >= this.fFirstBucketTime) {
            while (timestamp >= this.fTimeLimit) {
                this.mergeBuckets();
            }
        } else {
            int offset = this.getOffset(timestamp);
            while (this.fLastBucket + offset >= this.fNbBuckets) {
                this.mergeBuckets();
                offset = this.getOffset(timestamp);
            }
            this.moveBuckets(offset);
            this.fLastBucket += offset;
            this.fFirstBucketTime -= (long)offset * this.fBucketDuration;
            this.updateEndTime();
        }
        int index = (int)((timestamp - this.fFirstBucketTime) / this.fBucketDuration);
        if (this.fLastBucket < index) {
            this.fLastBucket = index;
        }
        return index;
    }

    protected abstract void moveBuckets(int var1);

    protected abstract void mergeBuckets();

    protected int getOffset(long timestamp) {
        int offset = (int)((this.fFirstBucketTime - timestamp) / this.fBucketDuration);
        if ((this.fFirstBucketTime - timestamp) % this.fBucketDuration != 0L) {
            ++offset;
        }
        return offset;
    }

    protected void updateEndTime() {
        this.fTimeLimit = this.fFirstBucketTime + (long)this.fNbBuckets * this.fBucketDuration;
    }
}

