/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHoverMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class CheckboxFieldEditor
extends FieldEditor {
    private String extensionID;
    private String preferenceName;
    private HashMap<String, String> mapItems = new HashMap();
    private Table table;
    private CheckboxTableViewer tv;
    private Button[] buttons;
    private Composite usercomp;
    private Composite buttoncomp;
    public static final String EMPTY_STR = "";
    public static final String MOVEUP_STR = LibHoverMessages.getString("FileListControl.moveup");
    public static final String MOVEDOWN_STR = LibHoverMessages.getString("FileListControl.movedown");

    public CheckboxFieldEditor(String extensionID, String preferenceName, String label, Composite parent) {
        this.extensionID = extensionID;
        this.preferenceName = preferenceName;
        this.init(preferenceName, label);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns > 1) {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
            }
            ((GridData)this.table.getLayoutData()).horizontalSpan = numColumns - 1;
            ((GridData)this.buttoncomp.getLayoutData()).horizontalSpan = 1;
        } else {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this.usercomp.getLayoutData()).horizontalSpan = 1;
            ((GridData)this.buttoncomp.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int checkC = 1;
        if (numColumns > 1) {
            checkC = numColumns - 1;
        }
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        control = this.getCheckboxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = checkC;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
        control = this.getButtonControl(parent);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
    }

    private void getExtensions() {
        this.mapItems.clear();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(this.extensionID);
        if (point != null) {
            IExtension[] exts;
            IExtension[] iExtensionArray = exts = point.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                if (ext.getConfigurationElements().length > 0) {
                    this.mapItems.put(ext.getUniqueIdentifier(), ext.getLabel());
                }
                ++n2;
            }
        }
    }

    protected void doLoad() {
        this.getExtensions();
        HashMap copyMap = (HashMap)this.mapItems.clone();
        ArrayList<TableData> data = new ArrayList<TableData>();
        ArrayList<TableData> checkedData = new ArrayList<TableData>();
        String pref = this.getPreferenceStore().getString(this.preferenceName);
        String[] tokens = pref.split(":");
        if (tokens.length > 1) {
            int i = 0;
            while (i < tokens.length) {
                String id = tokens[i];
                Boolean checked = Boolean.valueOf(tokens[i + 1]);
                String value = (String)copyMap.get(id);
                if (value != null) {
                    TableData d = new TableData(id, value);
                    data.add(d);
                    if (checked.booleanValue()) {
                        checkedData.add(d);
                    }
                    copyMap.remove(id);
                }
                i += 2;
            }
        }
        String[] leftovers = new String[copyMap.size()];
        leftovers = copyMap.keySet().toArray(leftovers);
        int i = 0;
        while (i < leftovers.length) {
            TableData d = new TableData(leftovers[i], (String)copyMap.get(leftovers[i]));
            data.add(d);
            checkedData.add(d);
            ++i;
        }
        this.tv.setInput((Object)data.toArray());
        this.tv.setCheckedElements(checkedData.toArray());
        this.updateButtons();
    }

    protected void doLoadDefault() {
        this.getExtensions();
        HashMap copyMap = (HashMap)this.mapItems.clone();
        ArrayList<TableData> data = new ArrayList<TableData>();
        ArrayList<TableData> checkedData = new ArrayList<TableData>();
        String[] ids = new String[copyMap.size()];
        ids = copyMap.keySet().toArray(ids);
        int i = 0;
        while (i < ids.length) {
            TableData d = new TableData(ids[i], (String)copyMap.get(ids[i]));
            data.add(d);
            checkedData.add(d);
            ++i;
        }
        this.tv.setInput((Object)data.toArray());
        this.tv.setCheckedElements(checkedData.toArray());
        this.updateButtons();
    }

    protected void doStore() {
        this.save();
    }

    public int getNumberOfControls() {
        return 3;
    }

    public Control getButtonControl(Composite parent) {
        if (this.buttoncomp == null) {
            this.buttoncomp = new Composite(parent, 0);
            GridData d = new GridData(3);
            d.widthHint = 1;
            this.buttoncomp.setLayoutData((Object)d);
            this.buttoncomp.setFont(parent.getFont());
            String[] stringArray = new String[5];
            stringArray[0] = MOVEUP_STR;
            stringArray[1] = MOVEDOWN_STR;
            stringArray[3] = UIMessages.getString((String)"ErrorParsTab.0");
            stringArray[4] = UIMessages.getString((String)"ErrorParsTab.1");
            this.initButtons(this.buttoncomp, stringArray);
        }
        return this.buttoncomp;
    }

    public Control getCheckboxControl(Composite parent) {
        if (this.table == null) {
            this.table = new Table(parent, 2084);
            this.table.setLayoutData((Object)new GridData(4, 4, true, true));
            this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CheckboxFieldEditor.this.updateButtons();
                }
            });
            this.tv = new CheckboxTableViewer(this.table);
            this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return (Object[])inputElement;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            this.tv.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent e) {
                }
            });
        }
        return this.table;
    }

    protected void initButtons(Composite c, String[] names) {
        this.initButtons(c, names, 80);
    }

    protected void initButtons(Composite c, String[] names, int width) {
        if (names == null || names.length == 0) {
            return;
        }
        c.setLayoutData((Object)new GridData(1040));
        c.setLayout((Layout)new GridLayout(1, false));
        this.buttons = new Button[names.length];
        int i = 0;
        while (i < names.length) {
            this.buttons[i] = new Button(c, 8);
            this.buttons[i].setFont(c.getFont());
            GridData gdb = new GridData(4);
            gdb.grabExcessHorizontalSpace = false;
            gdb.horizontalAlignment = 4;
            gdb.minimumWidth = width;
            if (names[i] != null) {
                this.buttons[i].setText(names[i]);
            } else {
                this.buttons[i].setVisible(false);
                this.buttons[i].setEnabled(false);
                gdb.heightHint = 10;
            }
            this.buttons[i].setLayoutData((Object)gdb);
            this.buttons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    CheckboxFieldEditor.this.buttonPressed(event);
                }
            });
            ++i;
        }
    }

    private void buttonPressed(SelectionEvent e) {
        int i = 0;
        while (i < this.buttons.length) {
            if (this.buttons[i].equals(e.widget)) {
                this.buttonPressed(i);
                return;
            }
            ++i;
        }
    }

    public void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.moveItem(true);
                break;
            }
            case 1: {
                this.moveItem(false);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.tv.setAllChecked(true);
                break;
            }
            case 4: {
                this.tv.setAllChecked(false);
                break;
            }
        }
    }

    private void moveItem(boolean up) {
        int n = this.table.getSelectionIndex();
        if (n < 0 || up && n == 0 || !up && n + 1 == this.table.getItemCount()) {
            return;
        }
        TableData d = (TableData)this.tv.getElementAt(n);
        boolean checked = this.tv.getChecked((Object)d);
        this.tv.remove((Object)d);
        n = up ? n - 1 : n + 1;
        this.tv.insert((Object)d, n);
        this.tv.setChecked((Object)d, checked);
        this.table.setSelection(n);
    }

    protected void buttonSetEnabled(int i, boolean state) {
        if (this.buttons == null || this.buttons.length <= i) {
            return;
        }
        this.buttons[i].setEnabled(state);
    }

    public void updateButtons() {
        int cnt = this.table.getItemCount();
        int pos = this.table.getSelectionIndex();
        this.buttonSetEnabled(0, pos > 0);
        this.buttonSetEnabled(1, pos != -1 && pos < cnt - 1);
        this.buttonSetEnabled(3, cnt > 0);
        this.buttonSetEnabled(4, cnt > 0);
    }

    private void save() {
        boolean inRange = true;
        int i = 0;
        String outString = new String();
        String del = EMPTY_STR;
        while (inRange) {
            Object obj = this.tv.getElementAt(i);
            if (obj == null) {
                inRange = false;
                continue;
            }
            ++i;
            TableData t = (TableData)obj;
            outString = String.valueOf(outString) + del + t.key + ":" + this.tv.getChecked(obj);
            del = ":";
        }
        if (outString.length() > 1) {
            this.getPreferenceStore().setValue(this.preferenceName, outString);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getCheckboxControl(parent).setEnabled(enabled);
        this.getButtonControl(parent).setEnabled(enabled);
    }

    class TableData {
        String key;
        String value;

        public TableData(String _key, String _value) {
            this.key = _key;
            this.value = _value;
        }

        public String toString() {
            return this.value;
        }
    }
}

