/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.ui.view;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.internal.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.internal.oprofile.ui.model.UiModelError;
import org.eclipse.linuxtools.internal.oprofile.ui.model.UiModelRoot;
import org.eclipse.linuxtools.internal.oprofile.ui.model.UiModelSession;
import org.eclipse.swt.widgets.Shell;

public class OprofileViewSaveDefaultSessionAction
extends Action {
    public OprofileViewSaveDefaultSessionAction() {
        super(OprofileUiMessages.getString("view.actions.savedefaultsession.label"));
    }

    public void run() {
        boolean defaultSessionExists = false;
        UiModelRoot modelRoot = UiModelRoot.getDefault();
        if (modelRoot.hasChildren()) {
            IUiModelElement[] events;
            IUiModelElement[] iUiModelElementArray = events = modelRoot.getChildren();
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                IUiModelElement[] sessions;
                IUiModelElement e = iUiModelElementArray[n2];
                if (e instanceof UiModelError) break;
                IUiModelElement[] iUiModelElementArray2 = sessions = e.getChildren();
                int n3 = sessions.length;
                int n4 = 0;
                while (n4 < n3) {
                    IUiModelElement s = iUiModelElementArray2[n4];
                    if (((UiModelSession)s).isDefaultSession()) {
                        defaultSessionExists = true;
                        break;
                    }
                    ++n4;
                }
                if (defaultSessionExists) break;
                ++n2;
            }
        }
        if (defaultSessionExists) {
            InputDialog dialog = new InputDialog(OprofileUiPlugin.getActiveWorkbenchShell(), OprofileUiMessages.getString("savedialog.title"), OprofileUiMessages.getString("savedialog.message"), OprofileUiMessages.getString("savedialog.initial"), (IInputValidator)new SaveSessionValidator());
            int result = dialog.open();
            if (result == 0) {
                try {
                    OprofileCorePlugin.getDefault().getOpcontrolProvider().saveSession(dialog.getValue());
                    OprofileUiPlugin.getDefault().getOprofileView().refreshView();
                }
                catch (OpcontrolException oe) {
                    OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)oe);
                }
            }
        } else {
            MessageDialog.openError((Shell)OprofileUiPlugin.getActiveWorkbenchShell(), (String)OprofileUiMessages.getString("defaultsessiondialog.nodefaultsession.title"), (String)OprofileUiMessages.getString("defaultsessiondialog.nodefaultsession.message"));
        }
    }

    private class SaveSessionValidator
    implements IInputValidator {
        private SaveSessionValidator() {
        }

        public String isValid(String newText) {
            if (newText.length() == 0) {
                return "";
            }
            int index = newText.indexOf(47);
            if (index == -1) {
                index = newText.indexOf(92);
            }
            if (index != -1) {
                String format = OprofileUiMessages.getString("savedialog.validator.invalidChar");
                Object[] fmtArgs = new Object[]{newText.substring(index, index + 1), newText};
                return MessageFormat.format(format, fmtArgs);
            }
            if (newText.contains(" ") || newText.contains("\t")) {
                String format = OprofileUiMessages.getString("savedialog.validator.containsWhitespace");
                Object[] fmtArgs = new Object[]{newText};
                return MessageFormat.format(format, fmtArgs);
            }
            File file = new File(Oprofile.getDefaultSamplesDirectory(), newText);
            if (file.exists()) {
                String format = OprofileUiMessages.getString("savedialog.validator.exists");
                Object[] fmtArgs = new Object[]{newText};
                return MessageFormat.format(format, fmtArgs);
            }
            return null;
        }
    }
}

