/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.cli.command;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import joptsimple.OptionSet;
import org.eclipse.iot.tiaki.cli.Command;
import org.eclipse.iot.tiaki.cli.ConsoleWriter;
import org.eclipse.iot.tiaki.cli.common.ExitCodes;
import org.eclipse.iot.tiaki.cli.console.DefaultConsoleWriter;
import org.eclipse.iot.tiaki.cli.console.LibraryObserver;
import org.eclipse.iot.tiaki.cli.exception.ExecutionException;
import org.eclipse.iot.tiaki.cli.exception.OptionsNotValidException;
import org.eclipse.iot.tiaki.cli.util.EnvironmentUtil;
import org.eclipse.iot.tiaki.cli.util.ExitCodeMapper;
import org.eclipse.iot.tiaki.cli.util.OptionUtil;
import org.eclipse.iot.tiaki.commons.StatusCode;
import org.eclipse.iot.tiaki.exceptions.DnsServiceException;
import org.eclipse.iot.tiaki.services.DnsServicesDiscovery;

public abstract class DnsSdAbstractCommand
implements Command {
    protected DnsServicesDiscovery dnsSd;
    protected ConsoleWriter consoleWriter;
    protected boolean insecureMode = false;
    protected boolean verboseMode = false;
    protected String dnsServer = null;
    protected String trustAnchorFileLocation = null;

    @Override
    public void initialize(OptionSet optionSet) throws ExecutionException, OptionsNotValidException {
        this.insecureMode = this.insecureMode || optionSet.has("insecure");
        this.insecureMode = this.insecureMode || EnvironmentUtil.isInsecureEnvironment();
        this.verboseMode = optionSet.has("verbose");
        if (optionSet.has("servers")) {
            this.dnsServer = optionSet.valueOf("servers").toString();
        }
        if (optionSet.has("trust-anchor")) {
            this.trustAnchorFileLocation = optionSet.valueOf("trust-anchor").toString();
        }
        this.consoleWriter = new DefaultConsoleWriter(this.verboseMode);
        this.dnsSd = new DnsServicesDiscovery();
        if (this.trustAnchorFileLocation != null) {
            this.dnsSd.trustAnchorFile(new File(this.trustAnchorFileLocation));
        }
        LibraryObserver libraryObserver = new LibraryObserver(this.consoleWriter);
        this.dnsSd.introspected(true);
        this.dnsSd.observer(libraryObserver);
    }

    @Override
    public void execute() throws ExecutionException {
        if (this.dnsServer != null && !this.dnsServer.trim().isEmpty()) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.dnsServer);
                this.dnsSd.dnsServer(inetAddress);
                if (OptionUtil.checkResolverAddress(this.dnsServer)) {
                    throw new UnknownHostException("Invalid Resolver Address");
                }
            }
            catch (UnknownHostException e) {
                throw new ExecutionException(String.format("Invalid DNS Server Host", this.dnsServer), ExitCodes.UNKNOWN_DNS_SRV_HOST.getExitCode());
            }
        }
        try {
            this.dnsSd.checkConfiguration(true);
            this.doExecute(this.consoleWriter);
        }
        catch (DnsServiceException e) {
            StatusCode statusCode = e.dnsError();
            ExitCodes exitCode = ExitCodeMapper.map(statusCode);
            this.consoleWriter.verbose(e.printableErrorsTrace());
            throw new ExecutionException(e.getMessage(), exitCode.getExitCode());
        }
    }

    public abstract void doExecute(ConsoleWriter var1) throws DnsServiceException;
}

