/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.iot.tiaki.cli.util;

import joptsimple.OptionSet;
import org.eclipse.iot.tiaki.cli.exception.OptionsNotValidException;

public final class OptionUtil {
    private static final String checkAddress = "^([0-9]{1,}\\.){0,2}[0-9]{1,}$";

    public static String getOptionValue(OptionSet optionSet, String option, boolean mandatory) throws OptionsNotValidException {
        boolean hasOption = optionSet.has(option);
        if (!hasOption && mandatory) {
            throw new OptionsNotValidException(String.format("A mandatory option \"%s\" is missing", option));
        }
        String value = null;
        try {
            value = optionSet.valueOf(option).toString();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (hasOption && mandatory && (value == null || value.trim().isEmpty())) {
            throw new OptionsNotValidException(String.format("Null or empty value for the option \"%s\"", option));
        }
        return value;
    }

    public static boolean checkResolverAddress(String srvAddress) {
        return srvAddress.matches(checkAddress);
    }

    private OptionUtil() {
        throw new AssertionError((Object)String.format("Class %s not instantiable", this.getClass().getName()));
    }
}

