/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.definitions;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASN1.definitions.ASN1Module;
import org.eclipse.titan.designer.AST.ASN1.definitions.SelectionOption;
import org.eclipse.titan.designer.AST.ASN1.definitions.Symbols;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.Assignments;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.ModuleImportation;
import org.eclipse.titan.designer.AST.ModuleImportationChain;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;

public final class ImportModule
extends ModuleImportation {
    public static final String MISSINGMODULE = "There is no ASN.1 module with name `{0}''";
    private static final String NOTASN1MODULE = "The module referred by `{0}'' is not an ASN.1 module";
    private static final String SYMBOLNOTEXPORTED = "Symbol `{0}'' is not exported from module `{1}''";
    private final Symbols symbols;
    private final SelectionOption selectionOption;

    public ImportModule(Identifier identifier, Symbols symbols) {
        this(identifier, symbols, SelectionOption.NONE);
    }

    public ImportModule(Identifier identifier, Symbols symbols, SelectionOption selectionOption) {
        super(identifier);
        this.identifier = identifier;
        this.symbols = null == symbols ? new Symbols() : symbols;
        this.selectionOption = selectionOption;
    }

    @Override
    public String chainedDescription() {
        return null != this.identifier ? this.identifier.getDisplayName() : null;
    }

    public Symbols getSymbols() {
        return this.symbols;
    }

    public boolean hasSymbol(Identifier identifier) {
        return this.symbols.hasSymbol(identifier.getName());
    }

    @Override
    public void checkImports(CompilationTimeStamp timestamp, ModuleImportationChain referenceChain, List<Module> moduleStack) {
        if (null != this.lastImportCheckTimeStamp && !this.lastImportCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        this.symbols.checkUniqueness(timestamp);
        ProjectSourceParser parser = GlobalParser.getProjectSourceParser(this.project);
        if (null == parser || null == this.identifier) {
            this.lastImportCheckTimeStamp = timestamp;
            this.referredModule = null;
            return;
        }
        Module temp = this.referredModule;
        this.referredModule = parser.getModuleByName(this.identifier.getName());
        if (temp != this.referredModule) {
            this.setUnhandledChange(true);
        }
        if (this.referredModule == null) {
            this.identifier.getLocation().reportSemanticError(MessageFormat.format(MISSINGMODULE, this.identifier.getDisplayName()));
        } else {
            if (!(this.referredModule instanceof ASN1Module)) {
                this.identifier.getLocation().reportSemanticError(MessageFormat.format(NOTASN1MODULE, this.identifier.getDisplayName()));
                this.lastImportCheckTimeStamp = timestamp;
                this.referredModule = null;
                return;
            }
            moduleStack.add(this.referredModule);
            if (!referenceChain.add(this)) {
                moduleStack.remove(moduleStack.size() - 1);
                this.lastImportCheckTimeStamp = timestamp;
                return;
            }
            this.referredModule.checkImports(timestamp, referenceChain, moduleStack);
            for (int i = 0; i < this.symbols.size(); ++i) {
                Identifier id = this.symbols.getNthElement(i);
                if (((ASN1Module)this.referredModule).getAssignments().hasAssignmentWithId(timestamp, id) || this.referredModule.hasImportedAssignmentWithID(timestamp, id)) {
                    if (((ASN1Module)this.referredModule).exportsSymbol(timestamp, id)) continue;
                    this.identifier.getLocation().reportSemanticError(MessageFormat.format(SYMBOLNOTEXPORTED, id.getDisplayName(), this.referredModule.getIdentifier().getDisplayName()));
                    continue;
                }
                id.getLocation().reportSemanticError(MessageFormat.format("There is no assignment or imported symbol with name `{0}'' in module `{1}''", id.getDisplayName(), this.identifier.getDisplayName()));
            }
            moduleStack.remove(moduleStack.size() - 1);
        }
        this.lastImportCheckTimeStamp = timestamp;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastImportCheckTimeStamp != null && !this.lastImportCheckTimeStamp.isLess(timestamp)) {
            return;
        }
        this.usedForImportation = false;
    }

    @Override
    public boolean hasImportedAssignmentWithID(CompilationTimeStamp timestamp, Identifier identifier) {
        if (this.referredModule == null) {
            return false;
        }
        Assignments assignments = this.referredModule.getAssignments();
        return assignments != null && assignments.hasLocalAssignmentWithID(timestamp, identifier);
    }

    @Override
    public Assignment importAssignment(CompilationTimeStamp timestamp, ModuleImportationChain referenceChain, Identifier moduleId, Reference reference, List<ModuleImportation> usedImports) {
        if (this.referredModule == null) {
            return null;
        }
        Assignment result = this.referredModule.importAssignment(timestamp, moduleId, reference);
        if (result != null) {
            usedImports.add(this);
            this.setUsedForImportation();
        }
        return result;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, Identifier targetModuleId) {
        Module savedReferredModule;
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (propCollector.getReference().getModuleIdentifier() == null && subrefs.size() == 1) {
            propCollector.addProposal(this.identifier, ImageCache.getImage(this.getOutlineIcon()), "imported module");
        }
        if ((savedReferredModule = this.referredModule) != null) {
            Assignments assignments = savedReferredModule.getAssignments();
            int size = assignments.getNofAssignments();
            for (int i = 0; i < size; ++i) {
                Assignment temporalAssignment = assignments.getAssignmentByIndex(i);
                if (!savedReferredModule.isVisible(CompilationTimeStamp.getBaseTimestamp(), targetModuleId, temporalAssignment)) continue;
                temporalAssignment.addProposal(propCollector, 0);
            }
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, Identifier targetModuleId) {
        Module savedReferredModule = this.referredModule;
        if (savedReferredModule != null) {
            Assignments assignments = savedReferredModule.getAssignments();
            for (int i = 0; i < assignments.getNofAssignments(); ++i) {
                Assignment temporalAssignment = assignments.getAssignmentByIndex(i);
                if (!savedReferredModule.isVisible(CompilationTimeStamp.getBaseTimestamp(), targetModuleId, temporalAssignment)) continue;
                temporalAssignment.addDeclaration(declarationCollector, 0);
            }
            Identifier moduleId = declarationCollector.getReference().getModuleIdentifier();
            List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
            if (moduleId == null && subrefs.size() == 1 && this.identifier.getName().equals(subrefs.get(0).getId().getName())) {
                declarationCollector.addDeclaration(savedReferredModule.getIdentifier().getDisplayName(), savedReferredModule.getIdentifier().getLocation(), (Scope)null);
            }
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.identifier != null && !this.identifier.accept(v)) {
            return false;
        }
        if (this.symbols != null && !this.symbols.accept(v)) {
            return false;
        }
        return v.leave(this) != 2;
    }
}

