/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Referenced_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public class LazyFuzzyParamData {
    private static int depth = 0;
    private static boolean used_as_lvalue = false;
    private static ArrayList<String> typeVector = null;
    private static ArrayList<String> referedVector = null;

    public static void init(boolean used_as_lvalue) {
        if (depth == 0) {
            LazyFuzzyParamData.used_as_lvalue = used_as_lvalue;
            typeVector = new ArrayList();
            referedVector = new ArrayList();
        }
        ++depth;
    }

    public static void clean() {
        if (depth == 1) {
            typeVector.clear();
            typeVector = null;
            referedVector.clear();
            referedVector = null;
        }
        --depth;
    }

    public static boolean inLazyOrFuzzy() {
        return depth > 0;
    }

    public static String addReferenceGenname(JavaGenData aData, StringBuilder source, Assignment assignment) {
        StringBuilder typeString = new StringBuilder();
        IType assignmentType = assignment.getType(CompilationTimeStamp.getBaseTimestamp());
        switch (assignment.getAssignmentType()) {
            case A_MODULEPAR_TEMPLATE: 
            case A_TEMPLATE: 
            case A_VAR_TEMPLATE: 
            case A_PAR_TEMP_IN: 
            case A_PAR_TEMP_OUT: 
            case A_PAR_TEMP_INOUT: {
                typeString.append(assignmentType.getGenNameTemplate(aData, source));
                break;
            }
            default: {
                typeString.append(assignmentType.getGenNameValue(aData, source));
            }
        }
        if (assignment.getMyScope() instanceof ComponentTypeBody) {
            switch (assignment.getAssignmentType()) {
                case A_VAR_TEMPLATE: 
                case A_VAR: 
                case A_PORT: {
                    typeString.insert(0, "ThreadLocal<");
                    typeString.append('>');
                    break;
                }
            }
        }
        boolean parIsLazyOrFuzzy = false;
        switch (assignment.getAssignmentType()) {
            case A_PAR_VAL: 
            case A_PAR_VAL_IN: {
                boolean bl = parIsLazyOrFuzzy = ((FormalParameter)assignment).getEvaluationType() != FormalParameter.parameterEvaluationType.NORMAL_EVAL;
                if (!parIsLazyOrFuzzy) break;
                typeString.insert(0, "Lazy_Fuzzy_ValueExpr<");
                typeString.append('>');
                break;
            }
            case A_PAR_TEMP_IN: {
                boolean bl = parIsLazyOrFuzzy = ((FormalParameter)assignment).getEvaluationType() != FormalParameter.parameterEvaluationType.NORMAL_EVAL;
                if (!parIsLazyOrFuzzy) break;
                typeString.insert(0, "Lazy_Fuzzy_TemplateExpr<");
                typeString.append('>');
                break;
            }
        }
        typeVector.add(typeString.toString());
        referedVector.add(assignment.getGenNameFromScope(aData, source, ""));
        if (parIsLazyOrFuzzy) {
            return LazyFuzzyParamData.getMemberName(referedVector.size() - 1) + ".evaluate()";
        }
        return LazyFuzzyParamData.getMemberName(referedVector.size() - 1);
    }

    public static String getMemberName(int index) {
        return "lpm_" + index;
    }

    private static void generateCodeForValue(JavaGenData aData, ExpressionStruct valueExpression, IValue value) {
        value.generateCodeExpression(aData, valueExpression, true);
    }

    private static void generateCodeForTemplate(JavaGenData aData, ExpressionStruct templateExpression, TemplateInstance template, TemplateRestriction.Restriction_type genRestrictionCheck) {
        template.generateCode(aData, templateExpression, genRestrictionCheck);
    }

    public static void generateCode(JavaGenData aData, ExpressionStruct expression, IValue value, boolean lazy) {
        Reference reference;
        Assignment assignment;
        if (depth > 1) {
            ExpressionStruct valueExpression = new ExpressionStruct();
            LazyFuzzyParamData.generateCodeForValue(aData, valueExpression, value);
            String paramId = aData.getTemporaryVariableName();
            if (valueExpression.preamble.length() > 0) {
                expression.preamble.append((CharSequence)valueExpression.preamble);
            }
            aData.addBuiltinTypeImport("Lazy_Fuzzy_ValueExpr");
            expression.preamble.append(MessageFormat.format("final Lazy_Fuzzy_ValueExpr<{0}> {1} = new Lazy_Fuzzy_ValueExpr<{0}>({2}, {3});\n", value.getMyGovernor().getGenNameValue(aData, expression.preamble), paramId, lazy ? "false" : "true", valueExpression.expression));
            expression.expression.append(paramId);
            return;
        }
        if (!used_as_lvalue && value.getValuetype() == IValue.Value_type.REFERENCED_VALUE && ((Referenced_Value)value).getReference().getSubreferences().size() <= 1 && (assignment = (reference = ((Referenced_Value)value).getReference()).getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false)) != null) {
            FormalParameter.parameterEvaluationType eval = FormalParameter.parameterEvaluationType.NORMAL_EVAL;
            switch (assignment.getAssignmentType()) {
                case A_PAR_TEMP_IN: 
                case A_PAR_VAL: 
                case A_PAR_VAL_IN: {
                    eval = ((FormalParameter)assignment).getEvaluationType();
                    break;
                }
            }
            if (eval != FormalParameter.parameterEvaluationType.NORMAL_EVAL) {
                String refdString = assignment.getGenNameFromScope(aData, expression.expression, "");
                if (eval == FormalParameter.parameterEvaluationType.LAZY_EVAL && !lazy || eval == FormalParameter.parameterEvaluationType.FUZZY_EVAL && lazy) {
                    expression.preamble.append(MessageFormat.format("{0}.change();\n", refdString));
                    expression.postamble.append(MessageFormat.format("{0}.revert();\n", refdString));
                }
                expression.expression.append(refdString);
                return;
            }
        }
        aData.addBuiltinTypeImport("Lazy_Fuzzy_ValueExpr");
        ExpressionStruct valueExpression = new ExpressionStruct();
        LazyFuzzyParamData.generateCodeForValue(aData, valueExpression, value);
        String param_id = aData.getTemporaryVariableName();
        String typeName = value.getMyGovernor().getGenNameValue(aData, expression.expression);
        LazyFuzzyParamData.generateCodeParameterClass(aData, expression, valueExpression, param_id, typeName, true, lazy);
    }

    public static void generateCode(JavaGenData aData, ExpressionStruct expression, TemplateInstance template, TemplateRestriction.Restriction_type genRestrictionCheck, boolean lazy) {
        Reference reference;
        Assignment assignment;
        if (depth > 1) {
            ExpressionStruct templateExpression = new ExpressionStruct();
            LazyFuzzyParamData.generateCodeForTemplate(aData, templateExpression, template, genRestrictionCheck);
            String paramId = aData.getTemporaryVariableName();
            if (templateExpression.preamble.length() > 0) {
                expression.preamble.append((CharSequence)templateExpression.preamble);
            }
            aData.addBuiltinTypeImport("Lazy_Fuzzy_TemplateExpr");
            expression.preamble.append(MessageFormat.format("final Lazy_Fuzzy_TemplateExpr<{0}> {1} = new Lazy_Fuzzy_TemplateExpr<{0}>({2}, {3});\n", template.getTemplateBody().getMyGovernor().getGenNameTemplate(aData, expression.preamble), paramId, lazy ? "false" : "true", templateExpression.expression));
            expression.expression.append(paramId);
            return;
        }
        if (!used_as_lvalue && template.getTemplateBody().getTemplatetype() == ITTCN3Template.Template_type.TEMPLATE_REFD && ((Referenced_Template)template.getTemplateBody()).getReference().getSubreferences().size() <= 1 && (assignment = (reference = ((Referenced_Template)template.getTemplateBody()).getReference()).getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false)) != null) {
            FormalParameter.parameterEvaluationType eval = FormalParameter.parameterEvaluationType.NORMAL_EVAL;
            switch (assignment.getAssignmentType()) {
                case A_PAR_TEMP_IN: 
                case A_PAR_VAL: 
                case A_PAR_VAL_IN: {
                    eval = ((FormalParameter)assignment).getEvaluationType();
                    break;
                }
            }
            if (eval != FormalParameter.parameterEvaluationType.NORMAL_EVAL) {
                String refdString = assignment.getGenNameFromScope(aData, expression.expression, "");
                if (eval == FormalParameter.parameterEvaluationType.LAZY_EVAL && !lazy || eval == FormalParameter.parameterEvaluationType.FUZZY_EVAL && lazy) {
                    expression.preamble.append(MessageFormat.format("{0}.change();\n", refdString));
                    expression.postamble.append(MessageFormat.format("{0}.revert();\n", refdString));
                }
                expression.expression.append(refdString);
                return;
            }
        }
        aData.addBuiltinTypeImport("Lazy_Fuzzy_TemplateExpr");
        ExpressionStruct templateExpression = new ExpressionStruct();
        LazyFuzzyParamData.generateCodeForTemplate(aData, templateExpression, template, genRestrictionCheck);
        String param_id = aData.getTemporaryVariableName();
        String typeName = template.getTemplateBody().getMyGovernor().getGenNameTemplate(aData, expression.expression);
        LazyFuzzyParamData.generateCodeParameterClass(aData, expression, templateExpression, param_id, typeName, false, lazy);
    }

    private static void generateCodeParameterClass(JavaGenData aData, ExpressionStruct expression, ExpressionStruct paramExpression, String param_id, String typeName, boolean isValue, boolean lazy) {
        expression.preamble.append(MessageFormat.format("Lazy_Fuzzy_{0}Expr<{1}> {2} = new Lazy_Fuzzy_{0}Expr<{1}>({3}) '{'\n", isValue ? "Value" : "Template", typeName, param_id, !lazy));
        for (int i = 0; i < typeVector.size(); ++i) {
            expression.preamble.append(MessageFormat.format("private {0} {1} = {2};\n", typeVector.get(i), LazyFuzzyParamData.getMemberName(i), referedVector.get(i)));
        }
        expression.preamble.append("@Override\n");
        expression.preamble.append("protected void evaluate_expression() {\n");
        if (paramExpression.preamble.length() > 0) {
            expression.preamble.append((CharSequence)paramExpression.preamble);
        }
        expression.preamble.append(MessageFormat.format("expr_cache = {0};\n", paramExpression.expression));
        if (paramExpression.postamble.length() > 0) {
            expression.postamble.append((CharSequence)paramExpression.postamble);
        }
        expression.preamble.append("}\n");
        expression.preamble.append("};\n");
        expression.expression.append(param_id);
    }
}

