/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import java.util.Iterator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public final class TextHover
implements ITextHover {
    private final ISourceViewer sourceViewer;

    public TextHover(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion == null) {
            return null;
        }
        IAnnotationModel annotationModel = this.sourceViewer.getAnnotationModel();
        if (annotationModel != null) {
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                MarkerAnnotation actualMarker;
                Position markerPosition;
                Object o = iterator.next();
                if (!(o instanceof MarkerAnnotation) || (markerPosition = annotationModel.getPosition((Annotation)(actualMarker = (MarkerAnnotation)o))).getOffset() > hoverRegion.getOffset() || markerPosition.getOffset() + markerPosition.getLength() < hoverRegion.getOffset()) continue;
                String message = actualMarker.getText();
                if (message != null) {
                    message = message.replaceAll("\\<([A-Z]+)\\>", "$1");
                } else {
                    ErrorReporter.INTERNAL_ERROR((String)("The marker at " + markerPosition.getOffset() + " does not seem to have any text"));
                }
                return message;
            }
        }
        return null;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.getHoverInfo(textViewer, hoverRegion);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }
}

