/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.parsers;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.text.IDocument;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.common.parsers.TITANMarker;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.OutOfMemoryCheck;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.LoadBalancingUtilities;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.editors.DocumentTracker;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.ttcn3editor.IUpdateSyntaxEventListener;
import org.eclipse.titan.designer.editors.ttcn3editor.UpdateSyntaxEvent;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ISourceAnalyzer;
import org.eclipse.titan.designer.parsers.OutdatedFileCollector;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titan.designer.parsers.asn1parser.ASN1Analyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3Analyzer;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3FileReparser;

public final class ProjectSourceSyntacticAnalyzer {
    private final IProject project;
    private final ProjectSourceParser sourceParser;
    private final Map<IFile, String> uptodateFiles;
    private final Set<IFile> highlySyntaxErroneousFiles;
    private final Map<IFile, String> fileMap;
    private final Map<String, IFile> includeFileMap;
    Map<IFile, List<TITANMarker>> unsupportedConstructMap;
    private volatile boolean syntacticallyOutdated = true;
    private static Vector<IUpdateSyntaxEventListener> eventListener = new Vector();

    public ProjectSourceSyntacticAnalyzer(IProject project, ProjectSourceParser sourceParser) {
        this.project = project;
        this.sourceParser = sourceParser;
        this.uptodateFiles = new ConcurrentHashMap<IFile, String>();
        this.highlySyntaxErroneousFiles = Collections.synchronizedSet(new HashSet());
        this.fileMap = new ConcurrentHashMap<IFile, String>();
        this.includeFileMap = new ConcurrentHashMap<String, IFile>();
        this.unsupportedConstructMap = new ConcurrentHashMap<IFile, List<TITANMarker>>();
    }

    public boolean isOutdated(IFile file) {
        return this.syntacticallyOutdated || !this.uptodateFiles.containsKey(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportOutdating(IFile outdatedFile) {
        IPreferencesService service = Platform.getPreferencesService();
        boolean useOnTheFlyParsing = service.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null);
        ProjectSourceSyntacticAnalyzer projectSourceSyntacticAnalyzer = this;
        synchronized (projectSourceSyntacticAnalyzer) {
            this.syntacticallyOutdated = true;
            if (this.uptodateFiles.containsKey(outdatedFile)) {
                this.uptodateFiles.remove(outdatedFile);
                this.unsupportedConstructMap.remove(outdatedFile);
            }
            if (this.highlySyntaxErroneousFiles.contains(outdatedFile)) {
                this.highlySyntaxErroneousFiles.remove(outdatedFile);
            }
            this.sourceParser.getSemanticAnalyzer().reportOutdating(outdatedFile, useOnTheFlyParsing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportSyntacticOutdatingOnly(IFile outdatedFile) {
        ProjectSourceSyntacticAnalyzer projectSourceSyntacticAnalyzer = this;
        synchronized (projectSourceSyntacticAnalyzer) {
            this.syntacticallyOutdated = true;
            if (this.uptodateFiles.containsKey(outdatedFile)) {
                this.uptodateFiles.remove(outdatedFile);
                this.unsupportedConstructMap.remove(outdatedFile);
            }
            if (this.highlySyntaxErroneousFiles.contains(outdatedFile)) {
                this.highlySyntaxErroneousFiles.remove(outdatedFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportOutdating(IFolder outdatedFolder) {
        IPath folderPath = outdatedFolder.getProjectRelativePath();
        IPreferencesService service = Platform.getPreferencesService();
        boolean useOnTheFlyParsing = service.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", true, null);
        ProjectSourceSyntacticAnalyzer projectSourceSyntacticAnalyzer = this;
        synchronized (projectSourceSyntacticAnalyzer) {
            IPath filepath;
            IFile tempFile;
            this.syntacticallyOutdated = true;
            Iterator<IFile> iterator = this.uptodateFiles.keySet().iterator();
            while (iterator.hasNext()) {
                tempFile = iterator.next();
                filepath = tempFile.getProjectRelativePath();
                if (!folderPath.isPrefixOf(filepath)) continue;
                this.sourceParser.getSemanticAnalyzer().reportOutdating(tempFile, useOnTheFlyParsing);
                iterator.remove();
                this.unsupportedConstructMap.remove(tempFile);
            }
            iterator = this.highlySyntaxErroneousFiles.iterator();
            while (iterator.hasNext()) {
                tempFile = iterator.next();
                filepath = tempFile.getProjectRelativePath();
                if (!folderPath.isPrefixOf(filepath)) continue;
                iterator.remove();
            }
        }
    }

    private void removedReferencestoRemovedFiles() {
        ArrayList<IFile> filesToRemove = new ArrayList<IFile>();
        for (IFile file : this.fileMap.keySet()) {
            if (file.isAccessible()) continue;
            this.uptodateFiles.remove(file);
            this.highlySyntaxErroneousFiles.remove(file);
            String moduleName = this.fileMap.get(file);
            filesToRemove.add(file);
            this.sourceParser.getSemanticAnalyzer().removedReferencestoRemovedFiles(file, moduleName);
        }
        for (IFile file : filesToRemove) {
            this.fileMap.remove(file);
            this.unsupportedConstructMap.remove(file);
            MarkerHandler.markAllMarkersForRemoval((IResource)file);
            MarkerHandler.removeAllMarkedMarkers((IResource)file);
        }
    }

    public void updateSyntax(IFile file, TTCN3ReparseUpdater reparser) {
        IUpdateSyntaxEventListener updateListener;
        for (int i = 0; i < eventListener.size(); ++i) {
            updateListener = eventListener.elementAt(i);
            updateListener.beforeSyntaxUpdate(new UpdateSyntaxEvent(this));
        }
        if (this.uptodateFiles.containsKey(file)) {
            Module module = this.sourceParser.getSemanticAnalyzer().getModulebyFile(file);
            this.sourceParser.getSemanticAnalyzer().reportSemanticOutdating(file);
            if (module != null && Module.module_type.TTCN3_MODULE.equals((Object)module.getModuletype())) {
                try {
                    reparser.setUnsupportedConstructs(this.unsupportedConstructMap);
                    try {
                        ((TTCN3Module)module).updateSyntax(reparser, this.sourceParser);
                        reparser.updateLocation(((TTCN3Module)module).getLocation());
                    }
                    catch (ReParseException e) {
                        this.syntacticallyOutdated = true;
                        this.uptodateFiles.remove(file);
                        this.sourceParser.getSemanticAnalyzer().reportSemanticOutdating(file);
                        String oldModuleName = this.fileMap.get(file);
                        if (oldModuleName != null) {
                            this.sourceParser.getSemanticAnalyzer().removeModule(oldModuleName);
                            this.fileMap.remove(file);
                        }
                        this.unsupportedConstructMap.remove(file);
                        reparser.maxDamage();
                        Ttcn3FileReparser r = new Ttcn3FileReparser(reparser, file, this.sourceParser, this.fileMap, this.uptodateFiles, this.highlySyntaxErroneousFiles);
                        this.syntacticallyOutdated = r.parse();
                    }
                    MarkerHandler.removeAllOnTheFlySyntacticMarkedMarkers((IResource)file);
                    MarkerHandler.updateMarkers((IResource)file, reparser.getFirstLine(), reparser.getLineShift(), reparser.getDamageEnd(), reparser.getShift());
                }
                catch (Exception e) {
                    ErrorReporter.logExceptionStackTrace((Exception)e);
                }
            } else {
                this.reportOutdating(file);
            }
        } else if (this.highlySyntaxErroneousFiles.contains(file)) {
            this.reportOutdating(file);
        } else {
            MarkerHandler.markAllMarkersForRemoval((IResource)file);
            TemporalParseData temp = this.fileBasedTTCN3Analysis(file);
            this.postFileBasedGeneralAnalysis(temp);
        }
        reparser.reportSyntaxErrors();
        for (int i = 0; i < eventListener.size(); ++i) {
            updateListener = eventListener.elementAt(i);
            updateListener.afterSyntaxUpdate(new UpdateSyntaxEvent(this));
        }
    }

    synchronized IStatus internalDoAnalyzeSyntactically2(IProgressMonitor monitor) {
        if (!this.project.isAccessible() || !TITANNature.hasTITANNature(this.project)) {
            return Status.CANCEL_STATUS;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        progress.setTaskName("On-the-fly syntactic checking of project: " + this.project.getName());
        IPreferencesService preferenceService = Platform.getPreferencesService();
        boolean reportDebugInformation = preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
        if (this.syntacticallyOutdated) {
            int index;
            IFile tempFile;
            this.syntacticallyOutdated = false;
            long absoluteStart = System.nanoTime();
            this.removedReferencestoRemovedFiles();
            IContainer[] workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(this.project).getWorkingDirectoryResources(false);
            OutdatedFileCollector visitor = new OutdatedFileCollector(workingDirectories, this.uptodateFiles, this.highlySyntaxErroneousFiles);
            try {
                this.project.accept((IResourceVisitor)visitor);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
            List<IFile> ttcn3FilesToCheck = visitor.getTTCN3FilesToCheck();
            List<IFile> asn1FilesToCheck = visitor.getASN1FilesToCheck();
            ArrayList<IFile> allCheckedFiles = new ArrayList<IFile>();
            allCheckedFiles.addAll(this.uptodateFiles.keySet());
            for (IFile file : ttcn3FilesToCheck) {
                MarkerHandler.markAllMarkersForRemoval((IResource)file, "org.eclipse.titan.designer.ontheflySyntacticMarker");
                MarkerHandler.markAllTaskMarkersForRemoval((IResource)file);
            }
            allCheckedFiles.addAll(ttcn3FilesToCheck);
            for (IFile file : asn1FilesToCheck) {
                MarkerHandler.markAllMarkersForRemoval((IResource)file, "org.eclipse.titan.designer.ontheflySyntacticMarker");
                MarkerHandler.markAllTaskMarkersForRemoval((IResource)file);
            }
            allCheckedFiles.addAll(asn1FilesToCheck);
            if (reportDebugInformation) {
                TITANDebugConsole.println("  **Syntax only check to be done on  " + (ttcn3FilesToCheck.size() + asn1FilesToCheck.size()) + " files.");
            }
            final SubMonitor parseProgress = SubMonitor.convert((IProgressMonitor)progress, (int)(ttcn3FilesToCheck.size() + asn1FilesToCheck.size()));
            parseProgress.setTaskName("Parse");
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            IPreferencesService prefs = Platform.getPreferencesService();
            int processingUnitsToUse = prefs.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.processingUnitsToUse", availableProcessors, null);
            boolean limitAllThreadCreation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.limitAllThreadCreation", false, null);
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setPriority(LoadBalancingUtilities.getThreadPriority());
                    return t;
                }
            };
            ExecutorService executor = limitAllThreadCreation ? Executors.newFixedThreadPool(processingUnitsToUse, threadFactory) : Executors.newCachedThreadPool(threadFactory);
            final TemporalParseData[] tempResults = new TemporalParseData[ttcn3FilesToCheck.size() + asn1FilesToCheck.size()];
            int nofFilesProcessed = 0;
            final CountDownLatch latch = new CountDownLatch(ttcn3FilesToCheck.size() + asn1FilesToCheck.size());
            for (IFile file : ttcn3FilesToCheck) {
                if (parseProgress.isCanceled()) {
                    parseProgress.done();
                    return Status.CANCEL_STATUS;
                }
                if (!file.isAccessible()) {
                    if (reportDebugInformation) {
                        TITANDebugConsole.println("The file " + file.getLocationURI() + " does not seem to exist.");
                    }
                    latch.countDown();
                    continue;
                }
                if (this.uptodateFiles.containsKey(file) || this.highlySyntaxErroneousFiles.contains(file)) continue;
                parseProgress.subTask("Syntactically analyzing file: " + file.getProjectRelativePath().toOSString());
                tempFile = file;
                index = nofFilesProcessed++;
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        TemporalParseData temp;
                        if (parseProgress.isCanceled()) {
                            latch.countDown();
                            parseProgress.worked(1);
                            return;
                        }
                        tempResults[index] = temp = ProjectSourceSyntacticAnalyzer.this.fileBasedTTCN3Analysis(tempFile);
                        latch.countDown();
                        parseProgress.worked(1);
                        LoadBalancingUtilities.syntaxAnalyzerProcessedAFile();
                    }
                });
            }
            ttcn3FilesToCheck.clear();
            for (IFile file : asn1FilesToCheck) {
                if (parseProgress.isCanceled()) {
                    parseProgress.done();
                    return Status.CANCEL_STATUS;
                }
                if (!file.isAccessible()) {
                    if (reportDebugInformation) {
                        TITANDebugConsole.println("The file " + file.getLocationURI() + " does not seem to exist.");
                    }
                    latch.countDown();
                    continue;
                }
                if (this.uptodateFiles.containsKey(file) || this.highlySyntaxErroneousFiles.contains(file)) continue;
                parseProgress.subTask("Syntactically analyzing file: " + file.getProjectRelativePath().toOSString());
                tempFile = file;
                index = nofFilesProcessed++;
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        TemporalParseData temp;
                        if (parseProgress.isCanceled()) {
                            latch.countDown();
                            parseProgress.worked(1);
                            return;
                        }
                        tempResults[index] = temp = ProjectSourceSyntacticAnalyzer.this.fileBasedASN1Analysis(tempFile);
                        latch.countDown();
                        parseProgress.worked(1);
                        LoadBalancingUtilities.syntaxAnalyzerProcessedAFile();
                    }
                });
            }
            asn1FilesToCheck.clear();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
            executor.shutdown();
            try {
                executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
            executor.shutdownNow();
            MarkerHandler.removeAllOnTheFlyMarkedMarkers((IResource)this.project);
            parseProgress.done();
            if (reportDebugInformation) {
                TITANDebugConsole.println("  **It took " + (double)(System.nanoTime() - absoluteStart) * 1.0E-9 + " seconds till the files (" + this.uptodateFiles.size() + " pieces) of project " + this.project.getName() + " got syntactically analyzed");
            }
        } else {
            if (reportDebugInformation) {
                TITANDebugConsole.println("  **The project " + this.project.getName() + " does not seem to need syntax only check.");
            }
            progress.worked(1);
            progress.done();
        }
        return Status.OK_STATUS;
    }

    void removeTTCNPPFilesIndirectlyModifiedByTTCNINFiles() {
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(this.project);
        Set<String> moduleNames = projectSourceParser.getKnownModuleNames();
        for (String moduleName : moduleNames) {
            TTCN3Module ttcnppModule;
            Set<IFile> includedFiles;
            Module module = projectSourceParser.getModuleByName(moduleName);
            if (module == null || !(module instanceof TTCN3Module) || (includedFiles = (ttcnppModule = (TTCN3Module)module).getIncludedFiles()) == null || includedFiles.isEmpty()) continue;
            boolean isTTCNPPupToDate = true;
            for (IFile f : includedFiles) {
                if (this.uptodateFiles.containsKey(f)) continue;
                isTTCNPPupToDate = false;
                break;
            }
            if (isTTCNPPupToDate) continue;
            this.uptodateFiles.remove(ttcnppModule.getLocation().getFile());
        }
    }

    synchronized IStatus internalDoAnalyzeSyntactically(IProgressMonitor monitor) {
        if (!this.project.isAccessible() || !TITANNature.hasTITANNature(this.project)) {
            return Status.CANCEL_STATUS;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        progress.setTaskName("On-the-fly syntactic checking of project: " + this.project.getName());
        IPreferencesService preferenceService = Platform.getPreferencesService();
        final boolean reportDebugInformation = preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        if (this.syntacticallyOutdated) {
            int index;
            IFile tempFile;
            this.syntacticallyOutdated = false;
            final long absoluteStart = System.nanoTime();
            this.removedReferencestoRemovedFiles();
            this.removeTTCNPPFilesIndirectlyModifiedByTTCNINFiles();
            IContainer[] workingDirectories = ProjectBasedBuilder.getProjectBasedBuilder(this.project).getWorkingDirectoryResources(false);
            OutdatedFileCollector visitor = new OutdatedFileCollector(workingDirectories, this.uptodateFiles, this.highlySyntaxErroneousFiles);
            try {
                this.project.accept((IResourceVisitor)visitor);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
            List<IFile> ttcn3FilesToCheck = visitor.getTTCN3FilesToCheck();
            List<IFile> asn1FilesToCheck = visitor.getASN1FilesToCheck();
            List<IFile> ttcninFilesModified = visitor.getTtcninFilesModified();
            for (IFile f : ttcninFilesModified) {
                this.uptodateFiles.put(f, f.getName());
                this.includeFileMap.put(f.getName(), f);
            }
            ArrayList<IFile> allCheckedFiles = new ArrayList<IFile>();
            allCheckedFiles.addAll(this.uptodateFiles.keySet());
            boolean useIncrementalParsing = preferenceService.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useIncrementalParsing", false, null);
            for (IFile file : ttcn3FilesToCheck) {
                if (useIncrementalParsing) {
                    MarkerHandler.markAllMarkersForRemoval((IResource)file, "org.eclipse.titan.designer.ontheflySyntacticMarker");
                } else {
                    MarkerHandler.markAllOnTheFlyMarkersForRemoval((IResource)file);
                }
                if (this.fileMap.containsKey(file)) continue;
                ParserMarkerSupport.removeAllCompilerMarkers((IResource)file);
                ParserMarkerSupport.removeAllOnTheFlyMarkers((IResource)file);
            }
            allCheckedFiles.addAll(ttcn3FilesToCheck);
            for (IFile file : asn1FilesToCheck) {
                if (useIncrementalParsing) {
                    MarkerHandler.markAllMarkersForRemoval((IResource)file, "org.eclipse.titan.designer.ontheflySyntacticMarker");
                } else {
                    MarkerHandler.markAllOnTheFlyMarkersForRemoval((IResource)file);
                }
                if (this.fileMap.containsKey(file)) continue;
                ParserMarkerSupport.removeAllCompilerMarkers((IResource)file);
                ParserMarkerSupport.removeAllOnTheFlyMarkers((IResource)file);
            }
            allCheckedFiles.addAll(asn1FilesToCheck);
            if (reportDebugInformation) {
                TITANDebugConsole.println("  **Syntax check to be done on  " + (ttcn3FilesToCheck.size() + asn1FilesToCheck.size()) + " files in project " + this.project.getName() + ".");
            }
            final SubMonitor parseProgress = SubMonitor.convert((IProgressMonitor)progress, (int)(ttcn3FilesToCheck.size() + asn1FilesToCheck.size()));
            parseProgress.setTaskName("Syntactically analyzing");
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            IPreferencesService prefs = Platform.getPreferencesService();
            int processingUnitsToUse = prefs.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.processingUnitsToUse", availableProcessors, null);
            boolean limitAllThreadCreation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.limitAllThreadCreation", false, null);
            ThreadFactory threadFactory = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setPriority(LoadBalancingUtilities.getThreadPriority());
                    return t;
                }
            };
            ExecutorService executor = limitAllThreadCreation ? Executors.newFixedThreadPool(processingUnitsToUse, threadFactory) : Executors.newCachedThreadPool(threadFactory);
            final TemporalParseData[] tempResults = new TemporalParseData[ttcn3FilesToCheck.size() + asn1FilesToCheck.size()];
            int nofFilesProcessed = 0;
            final CountDownLatch latch = new CountDownLatch(ttcn3FilesToCheck.size() + asn1FilesToCheck.size());
            for (IFile file : ttcn3FilesToCheck) {
                File f;
                if (parseProgress.isCanceled()) {
                    parseProgress.done();
                    return Status.CANCEL_STATUS;
                }
                if (!file.isAccessible()) {
                    if (reportDebugInformation) {
                        TITANDebugConsole.println("The file " + file.getLocationURI() + " does not seem to exist.");
                    }
                    latch.countDown();
                    continue;
                }
                if (OutOfMemoryCheck.isOutOfMemory()) {
                    latch.countDown();
                    if (OutOfMemoryCheck.isOutOfMemoryAlreadyReported()) continue;
                    OutOfMemoryCheck.outOfMemoryEvent();
                    return Status.CANCEL_STATUS;
                }
                if (this.uptodateFiles.containsKey(file) || this.highlySyntaxErroneousFiles.contains(file)) continue;
                if (file.isLinked() && !(f = new File(file.getLocation().toOSString())).exists()) {
                    if (reportDebugInformation) {
                        TITANDebugConsole.println("The file " + file.getLocationURI() + " does not seem to exist.");
                    }
                    latch.countDown();
                    continue;
                }
                parseProgress.subTask(" file: " + file.getProjectRelativePath().toOSString());
                tempFile = file;
                index = nofFilesProcessed++;
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (parseProgress.isCanceled()) {
                            latch.countDown();
                            parseProgress.worked(1);
                            return;
                        }
                        try {
                            TemporalParseData temp;
                            long absoluteStart2 = System.nanoTime();
                            tempResults[index] = temp = ProjectSourceSyntacticAnalyzer.this.fileBasedTTCN3Analysis(tempFile);
                            long now = System.nanoTime();
                            if (reportDebugInformation) {
                                TITANDebugConsole.println("  **It took (" + (absoluteStart2 - absoluteStart) + "," + (now - absoluteStart) + ") " + (double)(now - absoluteStart2) * 1.0E-9 + " seconds for Designer to syntactically check " + tempFile.getLocation());
                            }
                        }
                        finally {
                            latch.countDown();
                            parseProgress.worked(1);
                            LoadBalancingUtilities.syntaxAnalyzerProcessedAFile();
                        }
                    }
                });
            }
            ttcn3FilesToCheck.clear();
            for (IFile file : asn1FilesToCheck) {
                if (parseProgress.isCanceled()) {
                    parseProgress.done();
                    return Status.CANCEL_STATUS;
                }
                if (!file.isAccessible()) {
                    if (reportDebugInformation) {
                        TITANDebugConsole.println("The file " + file.getLocationURI() + " does not seem to exist.");
                    }
                    latch.countDown();
                    continue;
                }
                if (OutOfMemoryCheck.isOutOfMemory()) {
                    latch.countDown();
                    if (OutOfMemoryCheck.isOutOfMemoryAlreadyReported()) continue;
                    OutOfMemoryCheck.outOfMemoryEvent();
                    return Status.CANCEL_STATUS;
                }
                if (this.uptodateFiles.containsKey(file) || this.highlySyntaxErroneousFiles.contains(file)) continue;
                parseProgress.subTask(" file: " + file.getProjectRelativePath().toOSString());
                tempFile = file;
                index = nofFilesProcessed++;
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (parseProgress.isCanceled()) {
                            latch.countDown();
                            parseProgress.worked(1);
                            return;
                        }
                        try {
                            TemporalParseData temp;
                            long absoluteStart2 = System.nanoTime();
                            tempResults[index] = temp = ProjectSourceSyntacticAnalyzer.this.fileBasedASN1Analysis(tempFile);
                            long now = System.nanoTime();
                            if (reportDebugInformation) {
                                TITANDebugConsole.println("  **It took (" + (absoluteStart2 - absoluteStart) + "," + (now - absoluteStart) + ") " + (double)(now - absoluteStart2) * 1.0E-9 + " seconds for Designer to syntactically check " + tempFile.getLocation());
                            }
                        }
                        finally {
                            latch.countDown();
                            parseProgress.worked(1);
                            LoadBalancingUtilities.syntaxAnalyzerProcessedAFile();
                        }
                    }
                });
            }
            asn1FilesToCheck.clear();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
            executor.shutdown();
            try {
                executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                ErrorReporter.logExceptionStackTrace((Exception)e);
            }
            executor.shutdownNow();
            for (TemporalParseData temp : tempResults) {
                if (temp == null) continue;
                this.postFileBasedGeneralAnalysis(temp);
            }
            parseProgress.done();
            if (reportDebugInformation) {
                TITANDebugConsole.println("  **It took " + (double)(System.nanoTime() - absoluteStart) * 1.0E-9 + " seconds till the files (" + this.uptodateFiles.size() + " pieces) of project " + this.project.getName() + " got syntactically analyzed");
            }
        } else {
            if (reportDebugInformation) {
                TITANDebugConsole.println("  **The project " + this.project.getName() + " does not seem to need syntax check.");
            }
            progress.worked(1);
            progress.done();
        }
        return Status.OK_STATUS;
    }

    private TemporalParseData fileBasedTTCN3Analysis(IFile file) {
        return this.fileBasedGeneralAnalysis(file, new TTCN3Analyzer());
    }

    private TemporalParseData fileBasedASN1Analysis(IFile file) {
        return this.fileBasedGeneralAnalysis(file, new ASN1Analyzer());
    }

    private TemporalParseData fileBasedGeneralAnalysis(IFile file, ISourceAnalyzer analyzer) {
        if (analyzer == null) {
            return null;
        }
        IDocument document = DocumentTracker.get(file);
        this.unsupportedConstructMap.remove(file);
        try {
            String code = document == null ? null : document.get();
            analyzer.parse(file, code);
            Module module = analyzer.getModule();
            if (module instanceof TTCN3Module) {
                TTCN3Analyzer.md5_parser(file, code, (TTCN3Module)module);
            }
        }
        catch (FileNotFoundException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        boolean hadParseErrors = this.processParserErrors(file, analyzer);
        List<TITANMarker> warnings = analyzer.getWarnings();
        List<TITANMarker> unsupportedConstructs = analyzer.getUnsupportedConstructs();
        Module module = analyzer.getModule();
        if (warnings != null) {
            for (TITANMarker marker : warnings) {
                if (!file.isAccessible()) continue;
                Location location = new Location((IResource)file, marker.getLine(), marker.getOffset(), marker.getEndOffset());
                location.reportExternalProblem(marker.getMessage(), marker.getSeverity(), "org.eclipse.titan.designer.ontheflySyntacticMarker");
            }
        }
        if (document != null) {
            GlobalIntervalHandler.putInterval(document, analyzer.getRootInterval());
        }
        return new TemporalParseData(module, file, unsupportedConstructs, hadParseErrors, document);
    }

    private boolean processParserErrors(IFile aFile, ISourceAnalyzer aAnalyzer) {
        List<SyntacticErrorStorage> errors = null;
        errors = aAnalyzer.getErrorStorage();
        if (errors != null) {
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlySyntacticMarker(aFile, errors.get(i), 2);
            }
        }
        return errors != null && !errors.isEmpty();
    }

    private void postFileBasedGeneralAnalysis(TemporalParseData parsedData) {
        Module module = parsedData.getModule();
        if (module != null && module.getIdentifier() != null && module.getLocation() != null) {
            this.sourceParser.getSemanticAnalyzer().addModule(module);
            IFile file = parsedData.getFile();
            this.fileMap.put(file, module.getName());
            this.uptodateFiles.put(file, module.getName());
            List<TITANMarker> unsupportedConstructs = parsedData.getUnsupportedConstructs();
            if (unsupportedConstructs != null && !unsupportedConstructs.isEmpty()) {
                this.unsupportedConstructMap.put(file, unsupportedConstructs);
            }
            if (module.getLocation().getEndOffset() == -1 && parsedData.hadParseErrors()) {
                if (parsedData.getDocument() == null) {
                    module.getLocation().setEndOffset((int)new File(file.getLocationURI()).length());
                } else {
                    module.getLocation().setEndOffset(parsedData.getDocument().getLength());
                }
            }
        } else {
            this.syntacticallyOutdated = true;
            this.highlySyntaxErroneousFiles.add(parsedData.getFile());
        }
    }

    IFile internalGetTTCN3IncludeFileByName(String name) {
        if (this.includeFileMap.containsKey(name)) {
            return this.includeFileMap.get(name);
        }
        return null;
    }

    public static synchronized void addSyntaxUpdateListener(IUpdateSyntaxEventListener listener) {
        eventListener.add(listener);
    }

    public static synchronized void removeUpdateSyntaxListener(IUpdateSyntaxEventListener listener) {
        eventListener.remove(listener);
    }

    static final class TemporalParseData {
        private final Module module;
        private final IFile file;
        private final List<TITANMarker> unsupportedConstructs;
        private final boolean hadParseErrors;
        private final IDocument document;

        public TemporalParseData(Module module, IFile file, List<TITANMarker> unsupportedConstructs, boolean hadParseErrors, IDocument document) {
            this.module = module;
            this.file = file;
            this.unsupportedConstructs = unsupportedConstructs;
            this.hadParseErrors = hadParseErrors;
            this.document = document;
        }

        public Module getModule() {
            return this.module;
        }

        public IFile getFile() {
            return this.file;
        }

        public List<TITANMarker> getUnsupportedConstructs() {
            return this.unsupportedConstructs;
        }

        public boolean hadParseErrors() {
            return this.hadParseErrors;
        }

        public IDocument getDocument() {
            return this.document;
        }
    }
}

