/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.markers.export;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titanium.markers.types.TaskType;

public abstract class BaseProblemExporter {
    protected IProject project;
    protected boolean reportDebugInformation;

    public BaseProblemExporter(IProject proj) {
        this.project = proj;
        this.reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", true, null);
    }

    protected Map<TaskType, List<IMarker>> collectMarkers() throws CoreException {
        EnumMap<TaskType, List<IMarker>> markers = new EnumMap<TaskType, List<IMarker>>(TaskType.class);
        for (TaskType t : TaskType.values()) {
            markers.put(t, new ArrayList());
        }
        List projects = ProjectBasedBuilder.getProjectBasedBuilder((IProject)this.project).getAllReachableProjects();
        for (IProject tempProject : projects) {
            IMarker[] ms;
            for (IMarker m : ms = tempProject.findMarkers("org.eclipse.titan.designer.ontheflyTaskMarker", false, 2)) {
                for (TaskType t : TaskType.values()) {
                    if (!t.equalType(m)) continue;
                    ((List)markers.get(t)).add(m);
                }
            }
        }
        return markers;
    }

    public abstract void exportMarkers(IProgressMonitor var1, String var2, Date var3) throws IOException;
}

