/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core.cfgparser;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TitanOctetString;
import org.eclipse.titan.runtime.core.cfgparser.CFGListener;
import org.eclipse.titan.runtime.core.cfgparser.CfgAnalyzer;
import org.eclipse.titan.runtime.core.cfgparser.CfgPreprocessorUtils;
import org.eclipse.titan.runtime.core.cfgparser.ChainElement;
import org.eclipse.titan.runtime.core.cfgparser.CharstringExtractor;
import org.eclipse.titan.runtime.core.cfgparser.DefineSectionHandler;
import org.eclipse.titan.runtime.core.cfgparser.IOUtils;
import org.eclipse.titan.runtime.core.cfgparser.RuntimeCfgPreParser;

public class CfgPreProcessor {
    private static final int RECURSION_LIMIT = 100;
    private boolean error_flag = false;
    private Map<String, List<Token>> definitions = null;
    private final Map<String, String> resolvedDefinitions = new LinkedHashMap<String, String>();

    private void config_preproc_error(String error_str, File actualFile, Token token) {
        TTCN_Logger.begin_event(TTCN_Logger.Severity.ERROR_UNQUALIFIED);
        TTCN_Logger.log_event("Parse error while pre-processing", new Object[0]);
        if (actualFile != null) {
            TTCN_Logger.log_event(" configuration file `%s'", actualFile);
        }
        if (token != null) {
            TTCN_Logger.log_event(" in line %d", token.getLine());
        }
        TTCN_Logger.log_event(": ", new Object[0]);
        TTCN_Logger.log_event_va_list(error_str, new Object[0]);
        TTCN_Logger.end_event();
        this.error_flag = true;
    }

    private void preparseInclude(File file, StringBuilder out, AtomicBoolean modified, CFGListener listener, ChainElement<File> includeChain, int recursionDepth) {
        BufferedReader reader;
        if (recursionDepth > 100) {
            this.config_preproc_error("Maximum include recursion depth reached", file, null);
            return;
        }
        ChainElement<File> includeChain2 = new ChainElement<File>(includeChain, file);
        String dir = file.getParent();
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            this.config_preproc_error(e.toString(), file, null);
            return;
        }
        if (listener != null) {
            listener.setFilename(file.getName());
        }
        CommonTokenStream tokenStream = CfgAnalyzer.createTokenStream(reader, listener);
        tokenStream.fill();
        List tokens = tokenStream.getTokens();
        ArrayList<File> includeFiles = new ArrayList<File>();
        block7: for (Token token : tokens) {
            int tokenType = token.getType();
            String tokenText = token.getText();
            switch (tokenType) {
                case 5: 
                case 6: {
                    modified.set(true);
                    continue block7;
                }
                case 42: {
                    String includeFilename = tokenText.substring(1, tokenText.length() - 1);
                    File includeFile = new File(dir, includeFilename);
                    if (includeFiles.contains(includeFile)) continue block7;
                    if (includeChain2.contains(includeFile)) {
                        this.config_preproc_error("Circular import chain detected: " + includeChain2.dump(), file, token);
                        continue block7;
                    }
                    includeFiles.add(includeFile);
                    modified.set(true);
                    continue block7;
                }
                case 44: {
                    String orderedIncludeFilename = tokenText.substring(1, tokenText.length() - 1);
                    File orderedIncludeFile = new File(dir, orderedIncludeFilename);
                    if (includeChain2.contains(orderedIncludeFile)) {
                        this.config_preproc_error("Circular import chain detected: " + includeChain2.dump(), file, token);
                        continue block7;
                    }
                    this.preparseInclude(orderedIncludeFile, out, modified, listener, includeChain2, recursionDepth + 1);
                    modified.set(true);
                    continue block7;
                }
            }
            out.append(tokenText);
        }
        for (File includeFile : includeFiles) {
            this.preparseInclude(includeFile, out, modified, listener, includeChain2, recursionDepth + 1);
        }
        IOUtils.closeQuietly((Closeable)reader);
    }

    private StringBuilder preparseDefine(StringBuilder in, AtomicBoolean modified, CFGListener listener) {
        StringReader reader = new StringReader(in.toString());
        CommonTokenStream tokenStream = CfgAnalyzer.createTokenStream(reader, listener);
        RuntimeCfgPreParser parser = new RuntimeCfgPreParser((TokenStream)tokenStream);
        if (listener != null) {
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)listener);
        }
        parser.setBuildParseTree(false);
        parser.pr_ConfigFile();
        DefineSectionHandler defineSectionHandler = parser.getDefineSectionHandler();
        this.definitions = defineSectionHandler.getDefinitions();
        parser = null;
        this.checkCircularReferences();
        if (this.error_flag) {
            return null;
        }
        StringBuilder out = this.resolveMacros(tokenStream, modified);
        reader.close();
        return out;
    }

    private void checkCircularReferences() {
        for (Map.Entry<String, List<Token>> entry : this.definitions.entrySet()) {
            String defName = entry.getKey();
            this.checkCircularReferences(defName, defName);
        }
    }

    private void checkCircularReferences(String first, String defName) {
        List<Token> defValue = this.definitions.get(defName);
        if (defValue == null) {
            this.config_preproc_error("Unknown define " + defName, null, null);
            return;
        }
        for (Token token : defValue) {
            int tokenType = token.getType();
            switch (tokenType) {
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    String tokenText = token.getText();
                    String macroName = DefineSectionHandler.getMacroName(tokenText);
                    if (macroName == null) {
                        macroName = DefineSectionHandler.getTypedMacroName(tokenText);
                    }
                    if (macroName == null) {
                        this.config_preproc_error("Invalid macro name: " + tokenText, null, token);
                    }
                    if (first.equals(macroName)) {
                        this.config_preproc_error("Circular reference in define " + first, null, token);
                    }
                    this.checkCircularReferences(first, macroName);
                    break;
                }
            }
        }
    }

    private StringBuilder resolveMacros(CommonTokenStream tokenStream, AtomicBoolean modified) {
        boolean defineSection = false;
        StringBuilder out = new StringBuilder();
        List tokens = tokenStream.getTokens();
        block5: for (Token token : tokens) {
            CommonToken commonToken = (CommonToken)token;
            int tokenType = token.getType();
            String tokenText = token.getText();
            switch (tokenType) {
                case 8: {
                    modified.set(true);
                    defineSection = true;
                    continue block5;
                }
                case 4: 
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    defineSection = false;
                    out.append(tokenText);
                    continue block5;
                }
                case 5: 
                case 6: {
                    defineSection = false;
                    out.append(tokenText);
                    continue block5;
                }
            }
            if (defineSection || !this.resolveToken(out, (Token)commonToken)) continue;
            modified.set(true);
        }
        return out;
    }

    private boolean resolveToken(StringBuilder out, Token token) {
        int tokenType = token.getType();
        switch (tokenType) {
            case 37: {
                return this.resolveMacro(out, token);
            }
            case 51: {
                return this.resolveMacroBool(out, token);
            }
            case 39: {
                return this.resolveMacroInt(out, token);
            }
            case 41: {
                return this.resolveMacroFloat(out, token);
            }
            case 50: {
                return this.resolveMacroId(out, token);
            }
            case 40: {
                return this.resolveMacroCstr(out, token);
            }
            case 52: {
                return this.resolveMacroBstr(out, token);
            }
            case 53: {
                return this.resolveMacroHstr(out, token);
            }
            case 54: {
                return this.resolveMacroOstr(out, token);
            }
            case 38: {
                return this.resolveMacroHostname(out, token);
            }
            case 55: {
                return this.resolveMacroBinary(out, token);
            }
        }
        String tokenText = token.getText();
        out.append(tokenText);
        return false;
    }

    private boolean resolveMacro(StringBuilder out, Token token) {
        String tokenText = token.getText();
        String macroName = DefineSectionHandler.getMacroName(tokenText);
        String macroValue = this.getDefinitionValue(macroName, true);
        if (macroValue == null) {
            this.config_preproc_error(MessageFormat.format("No macro or environmental variable defined with name `{0}''", macroName), null, token);
            out.append(tokenText);
        }
        out.append(macroValue);
        return true;
    }

    private boolean resolveMacroBool(StringBuilder out, Token token) {
        String tokenText = token.getText();
        String typedMacroName = DefineSectionHandler.getTypedMacroName(tokenText);
        String typedMacroValue = this.getDefinitionValue(typedMacroName);
        if (typedMacroValue == null) {
            this.config_preproc_error(MessageFormat.format("No macro or environmental variable defined with name `{0}''", typedMacroName), null, token);
            out.append(tokenText);
            return false;
        }
        if (!CfgPreprocessorUtils.string_is_bool(typedMacroValue)) {
            this.config_preproc_error(MessageFormat.format("Macro `{0}'' cannot be interpreted as boolean value: `{1}''", typedMacroName, typedMacroValue), null, token);
            out.append("false");
            return true;
        }
        out.append(typedMacroValue);
        return true;
    }

    private boolean resolveMacroInt(StringBuilder out, Token token) {
        String tokenText = token.getText();
        String typedMacroName = DefineSectionHandler.getTypedMacroName(tokenText);
        String typedMacroValue = this.getDefinitionValue(typedMacroName);
        if (typedMacroValue == null) {
            this.config_preproc_error(MessageFormat.format("No macro or environmental variable defined with name `{0}''", typedMacroName), null, token);
            out.append(tokenText);
            return false;
        }
        if (!CfgPreprocessorUtils.string_is_int(typedMacroValue)) {
            this.config_preproc_error(MessageFormat.format("Macro `{0}'' cannot be interpreted as integer value: `{1}''", typedMacroName, typedMacroValue), null, token);
            out.append('0');
            return true;
        }
        out.append(typedMacroValue);
        return true;
    }

    private boolean resolveMacroFloat(StringBuilder out, Token token) {
        String tokenText = token.getText();
        String typedMacroName = DefineSectionHandler.getTypedMacroName(tokenText);
        String typedMacroValue = this.getDefinitionValue(typedMacroName);
        if (typedMacroValue == null) {
            this.config_preproc_error(MessageFormat.format("No macro or environmental variable defined with name `{0}''", typedMacroName), null, token);
            out.append(tokenText);
            return false;
        }
        if (!CfgPreprocessorUtils.string_is_float(typedMacroValue)) {
            this.config_preproc_error(MessageFormat.format("Macro `{0}'' cannot be interpreted as float value: `{1}''", typedMacroName, typedMacroValue), null, token);
            out.append("0.0");
            return true;
        }
        out.append(typedMacroValue);
        if (CfgPreprocessorUtils.string_is_int(typedMacroValue)) {
            out.append(".0");
        }
        return true;
    }

    private boolean resolveMacroId(StringBuilder out, Token token) {
        String tokenText = token.getText();
        String typedMacroName = DefineSectionHandler.getTypedMacroName(tokenText);
        String typedMacroValue = this.getDefinitionValue(typedMacroName);
        if (typedMacroValue == null) {
            this.config_preproc_error(MessageFormat.format("No macro or environmental variable defined with name `{0}''", typedMacroName), null, token);
            out.append(tokenText);
            return false;
        }
        if (!CfgPreprocessorUtils.string_is_id(typedMacroValue)) {
            this.config_preproc_error(MessageFormat.format("Macro `{0}'' cannot be interpreted as identifier value: `{1}''", typedMacroName, typedMacroValue), null, token);
            return true;
        }
        out.append(typedMacroValue);
        return true;
    }

    private boolean resolveMacroCstr(StringBuilder out, Token token) {
        String tokenText = token.getText();
        String typedMacroName = DefineSectionHandler.getTypedMacroName(tokenText);
        String typedMacroValue = this.getDefinitionValue(typedMacroName, true);
        if (typedMacroValue == null) {
            this.config_preproc_error(MessageFormat.format("No macro or environmental variable defined with name `{0}''", typedMacroName), null, token);
            out.append(tokenText);
            return true;
        }
        out.append(typedMacroValue);
        return true;
    }

    private boolean resolveMacroBstr(StringBuilder out, Token token) {
        String tokenText = token.getText();
        String typedMacroName = DefineSectionHandler.getTypedMacroName(tokenText);
        String typedMacroValue = this.getDefinitionValue(typedMacroName);
        if (typedMacroValue == null) {
            this.config_preproc_error(MessageFormat.format("No macro or environmental variable defined with name `{0}''", typedMacroName), null, token);
            out.append(tokenText);
            return false;
        }
        if (!CfgPreprocessorUtils.string_is_bstr(typedMacroValue)) {
            this.config_preproc_error(MessageFormat.format("Macro `{0}'' cannot be interpreted as bitstring value: `{1}''", typedMacroName, typedMacroValue), null, token);
            out.append("''B");
            return true;
        }
        out.append('\'');
        out.append(typedMacroValue);
        out.append("'B");
        return true;
    }

    private boolean resolveMacroHstr(StringBuilder out, Token token) {
        String tokenText = token.getText();
        String typedMacroName = DefineSectionHandler.getTypedMacroName(tokenText);
        String typedMacroValue = this.getDefinitionValue(typedMacroName);
        if (typedMacroValue == null) {
            this.config_preproc_error(MessageFormat.format("No macro or environmental variable defined with name `{0}''", typedMacroName), null, token);
            out.append(tokenText);
            return false;
        }
        if (!CfgPreprocessorUtils.string_is_hstr(typedMacroValue)) {
            this.config_preproc_error(MessageFormat.format("Macro `{0}'' cannot be interpreted as hexstring value: `{1}''", typedMacroName, typedMacroValue), null, token);
            out.append("''H");
            return true;
        }
        out.append('\'');
        out.append(typedMacroValue);
        out.append("'H");
        return true;
    }

    private boolean resolveMacroOstr(StringBuilder out, Token token) {
        String tokenText = token.getText();
        String typedMacroName = DefineSectionHandler.getTypedMacroName(tokenText);
        String typedMacroValue = this.getDefinitionValue(typedMacroName);
        if (typedMacroValue == null) {
            this.config_preproc_error(MessageFormat.format("No macro or environmental variable defined with name `{0}''", typedMacroName), null, token);
            out.append(tokenText);
            return false;
        }
        if (!CfgPreprocessorUtils.string_is_ostr(typedMacroValue)) {
            this.config_preproc_error(MessageFormat.format("Macro `{0}'' cannot be interpreted as octetstring value: `{1}''", typedMacroName, typedMacroValue), null, token);
            out.append("''O");
            return true;
        }
        out.append('\'');
        out.append(typedMacroValue);
        out.append("'O");
        return true;
    }

    private boolean resolveMacroHostname(StringBuilder out, Token token) {
        String tokenText = token.getText();
        String typedMacroName = DefineSectionHandler.getTypedMacroName(tokenText);
        String typedMacroValue = this.getDefinitionValue(typedMacroName);
        if (typedMacroValue == null) {
            this.config_preproc_error(MessageFormat.format("No macro or environmental variable defined with name `{0}''", typedMacroName), null, token);
            out.append(tokenText);
            return false;
        }
        if (!CfgPreprocessorUtils.string_is_hostname(typedMacroValue)) {
            this.config_preproc_error(MessageFormat.format("Macro `{0}'' cannot be interpreted as hostname value: `{1}''", typedMacroName, typedMacroValue), null, token);
            out.append(typedMacroValue);
            return true;
        }
        out.append(typedMacroValue);
        return true;
    }

    private boolean resolveMacroBinary(StringBuilder out, Token token) {
        String tokenText = token.getText();
        String typedMacroName = DefineSectionHandler.getTypedMacroName(tokenText);
        String typedMacroValue = this.getDefinitionValue(typedMacroName);
        if (typedMacroValue == null) {
            this.config_preproc_error(MessageFormat.format("No macro or environmental variable defined with name `{0}''", typedMacroName), null, token);
            out.append(tokenText);
            return false;
        }
        TitanOctetString oct = new TitanOctetString(typedMacroValue.getBytes());
        CfgPreProcessor.writeOct(out, oct);
        return true;
    }

    private static void writeOct(StringBuilder out, TitanOctetString oct) {
        out.append('\'');
        for (byte digit : oct.get_value()) {
            out.append("0123456789ABCDEF".charAt((digit & 0xF0) >> 4));
            out.append("0123456789ABCDEF".charAt(digit & 0xF));
        }
        out.append("'O");
    }

    private String getDefinitionValue(String definition) {
        return this.getDefinitionValue(definition, false);
    }

    private String getDefinitionValue(String definition, boolean needsQuote) {
        if (this.resolvedDefinitions.containsKey(definition)) {
            return this.resolvedDefinitions.get(definition);
        }
        Map<String, String> env = System.getenv();
        if (env.containsKey(definition)) {
            String definitionValue = env.get(definition);
            this.resolvedDefinitions.put(definition, definitionValue);
            return definitionValue;
        }
        if (this.definitions == null || !this.definitions.containsKey(definition)) {
            return null;
        }
        List<Token> tokenList = this.definitions.get(definition);
        boolean structured = tokenList.size() > 0 && tokenList.get(0).getType() == 46;
        StringBuilder out = new StringBuilder();
        block5: for (Token token : tokenList) {
            int tokenType = token.getType();
            switch (tokenType) {
                case 36: {
                    CharstringExtractor cse = new CharstringExtractor(token.getText(), !structured && !needsQuote);
                    String text = cse.getExtractedString();
                    if (cse.isErroneous()) {
                        this.config_preproc_error(cse.getErrorMessage(), null, token);
                    }
                    out.append(text);
                    continue block5;
                }
                case 63: {
                    CharstringExtractor cse = new CharstringExtractor(token.getText(), false);
                    String text = cse.getExtractedString();
                    if (cse.isErroneous()) {
                        this.config_preproc_error(cse.getErrorMessage(), null, token);
                    }
                    out.append(text);
                    continue block5;
                }
                case 35: {
                    if (needsQuote) {
                        out.append('\"');
                        out.append(token.getText());
                        out.append('\"');
                        continue block5;
                    }
                    out.append(token.getText());
                    continue block5;
                }
            }
            this.resolveToken(out, token);
        }
        String definitionValue = out.toString();
        this.resolvedDefinitions.put(definition, definitionValue);
        return definitionValue;
    }

    public boolean preparse(File file, File resultFile, CFGListener listener) {
        StringBuilder outDefine;
        StringBuilder outInclude = new StringBuilder();
        AtomicBoolean modified = new AtomicBoolean(false);
        this.preparseInclude(file, outInclude, modified, listener, null, 0);
        if (listener != null) {
            listener.setFilename(null);
        }
        if ((outDefine = this.preparseDefine(outInclude, modified, listener)) != null) {
            CfgPreProcessor.writeToFile(resultFile, outDefine);
        }
        return modified.get();
    }

    private static void writeToFile(File resultFile, StringBuilder sb) {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(resultFile);
            pw.append(sb);
        }
    }

    boolean get_error_flag() {
        return this.error_flag;
    }
}

