/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public final class LocationHighlighter {
    private LocationHighlighter() {
    }

    public static void jumpToLocation(Location location) {
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(location.getFile().getName());
        if (desc == null) {
            return;
        }
        try {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart editorPart = page.openEditor((IEditorInput)new FileEditorInput((IFile)location.getFile()), desc.getId());
            if (editorPart != null && editorPart instanceof AbstractTextEditor) {
                ((AbstractTextEditor)editorPart).setHighlightRange(location.getOffset(), 0, true);
            }
        }
        catch (PartInitException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while opening the editor", (Throwable)e);
        }
    }
}

