/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;

public final class RectangleDrawer {
    private RectangleDrawer() {
    }

    public static void drawBox(IGC context, Rectangle rectangle, Color backgroundColor, Color gradientColor, int shadowSize) {
        context.setBackground(backgroundColor);
        context.setGradientColor(gradientColor);
        context.fillGradientRectangle(rectangle.x, rectangle.y, rectangle.width - shadowSize, rectangle.height - shadowSize, true);
    }

    public static void drawBorder(IGC context, Rectangle rectangle, Color lineColor, int shadowSize) {
        context.setForeground(lineColor);
        context.drawRectangle(rectangle.x, rectangle.y, rectangle.width - shadowSize, rectangle.height - shadowSize);
    }

    public static void drawShadow(IGC context, Rectangle rectangle, Color shadowColor, int shadowSize) {
        context.setLineStyle(context.getLineSolidStyle());
        context.setLineWidth(1);
        context.setBackground(shadowColor);
        context.fillRectangle(rectangle.x + shadowSize, rectangle.y + shadowSize, rectangle.width, rectangle.height);
    }

    public static Color getColor(String key) {
        return (Color)Activator.getDefault().getCachedResource(key);
    }

    public static void drawText(IGC context, Rectangle rectangle, String nodeText, Color fontColor, Font font, int shadowSize) {
        context.setForeground(fontColor);
        context.setFont(font);
        context.drawTextTruncatedCentred(nodeText, rectangle.x, rectangle.y, rectangle.width - shadowSize, rectangle.width - shadowSize, true);
    }
}

