/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.PortReference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Port_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Connect_Statement
extends Statement {
    public static final String INCONSISTENTCONNECTION = "The connection between port types `{0}'' and `{1}'' is not consistent";
    private static final String FULLNAMEPART1 = ".componentreference1";
    private static final String FULLNAMEPART2 = ".portreference1";
    private static final String FULLNAMEPART3 = ".componentreference2";
    private static final String FULLNAMEPART4 = ".portreference2";
    private static final String STATEMENT_NAME = "connect";
    private final Value componentReference1;
    private final PortReference portReference1;
    private final Value componentReference2;
    private final PortReference portReference2;

    public Connect_Statement(Value componentReference1, PortReference portReference1, Value componentReference2, PortReference portReference2) {
        this.componentReference1 = componentReference1;
        this.portReference1 = portReference1;
        this.componentReference2 = componentReference2;
        this.portReference2 = portReference2;
        if (componentReference1 != null) {
            componentReference1.setFullNameParent(this);
        }
        if (portReference1 != null) {
            portReference1.setFullNameParent(this);
        }
        if (componentReference2 != null) {
            componentReference2.setFullNameParent(this);
        }
        if (portReference2 != null) {
            portReference2.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_CONNECT;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    public Value getComponentReference1() {
        return this.componentReference1;
    }

    public Value getComponentReference2() {
        return this.componentReference2;
    }

    public PortReference getPortReference1() {
        return this.portReference1;
    }

    public PortReference getPortReference2() {
        return this.portReference2;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.componentReference1 == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.portReference1 == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.componentReference2 == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.portReference2 == child) {
            return builder.append(FULLNAMEPART4);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.componentReference1 != null) {
            this.componentReference1.setMyScope(scope);
        }
        if (this.portReference1 != null) {
            this.portReference1.setSubreferencesScope(scope);
        }
        if (this.componentReference2 != null) {
            this.componentReference2.setMyScope(scope);
        }
        if (this.portReference2 != null) {
            this.portReference2.setSubreferencesScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.componentReference1 != null) {
            this.componentReference1.setCodeSection(codeSection);
        }
        if (this.portReference1 != null) {
            this.portReference1.setCodeSection(codeSection);
        }
        if (this.componentReference2 != null) {
            this.componentReference2.setCodeSection(codeSection);
        }
        if (this.portReference2 != null) {
            this.portReference2.setCodeSection(codeSection);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        IType portType1 = Port_Utility.checkConnectionEndpoint(timestamp, this, this.componentReference1, this.portReference1, false);
        PortTypeBody body1 = portType1 == null ? null : ((Port_Type)portType1).getPortBody();
        IType portType2 = Port_Utility.checkConnectionEndpoint(timestamp, this, this.componentReference2, this.portReference2, false);
        PortTypeBody body2 = portType2 == null ? null : ((Port_Type)portType2).getPortBody();
        if (portType1 == null || portType2 == null || body1 == null || body2 == null) {
            this.lastTimeChecked = timestamp;
            return;
        }
        if (!body1.isConnectable(timestamp, body2) || body1 != body2 && !body2.isConnectable(timestamp, body1)) {
            this.location.reportSemanticError(MessageFormat.format(INCONSISTENTCONNECTION, portType1.getTypename(), portType2.getTypename()));
            body1.reportConnectionErrors(timestamp, body2, this.location);
            if (body1 != body2) {
                body2.reportConnectionErrors(timestamp, body1, this.location);
            }
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.componentReference1 != null) {
            this.componentReference1.updateSyntax(reparser, false);
            reparser.updateLocation(this.componentReference1.getLocation());
        }
        if (this.portReference1 != null) {
            this.portReference1.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference1.getLocation());
        }
        if (this.componentReference2 != null) {
            this.componentReference2.updateSyntax(reparser, false);
            reparser.updateLocation(this.componentReference2.getLocation());
        }
        if (this.portReference2 != null) {
            this.portReference2.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference2.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentReference1 != null) {
            this.componentReference1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.portReference1 != null) {
            this.portReference1.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.componentReference2 != null) {
            this.componentReference2.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.portReference2 != null) {
            this.portReference2.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.componentReference1 != null && !this.componentReference1.accept(v)) {
            return false;
        }
        if (this.portReference1 != null && !this.portReference1.accept(v)) {
            return false;
        }
        if (this.componentReference2 != null && !this.componentReference2.accept(v)) {
            return false;
        }
        return this.portReference2 == null || this.portReference2.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        expression.expression.append("TTCN_Runtime.connect_port(");
        this.componentReference1.generateCodeExpression(aData, expression, true);
        expression.expression.append(", ");
        if (this.componentReference1.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_DYNAMIC_VALUE) == null) {
            Port_Utility.generate_code_portref(aData, expression, this.portReference1);
        } else {
            this.portReference1.generateCode(aData, expression);
            expression.expression.append(".get_name()");
        }
        expression.expression.append(", ");
        this.componentReference2.generateCodeExpression(aData, expression, true);
        expression.expression.append(", ");
        if (this.componentReference2.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_DYNAMIC_VALUE) == null) {
            Port_Utility.generate_code_portref(aData, expression, this.portReference2);
        } else {
            this.portReference2.generateCode(aData, expression);
            expression.expression.append(".get_name()");
        }
        expression.expression.append(")");
        expression.mergeExpression(source);
    }
}

