/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Boolean_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Boolean_Value;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class While_Statement
extends Statement {
    private static final String BOOLEANEXPECTED = "A value or expression of type boolean was expected";
    private static final String FULLNAMEPART1 = ".expr";
    private static final String FULLNAMEPART2 = ".block";
    private static final String STATEMENT_NAME = "while";
    private final Value expression;
    private final StatementBlock statementblock;
    private boolean isInfiniteLoop = false;
    private StatementBlock.ReturnStatus_type hasReturn = StatementBlock.ReturnStatus_type.RS_NO;

    public While_Statement(Value expression, StatementBlock statementblock) {
        this.expression = expression;
        this.statementblock = statementblock;
        if (expression != null) {
            expression.setFullNameParent(this);
        }
        if (statementblock != null) {
            statementblock.setFullNameParent(this);
            statementblock.setOwnerIsLoop();
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_WHILE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.expression == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.statementblock == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    public Value getExpression() {
        return this.expression;
    }

    public StatementBlock getStatementBlock() {
        return this.statementblock;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.expression != null) {
            this.expression.setMyScope(scope);
        }
        if (this.statementblock != null) {
            this.statementblock.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.expression != null) {
            this.expression.setCodeSection(codeSection);
        }
        if (this.statementblock != null) {
            this.statementblock.setCodeSection(codeSection);
        }
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        super.setMyStatementBlock(statementBlock, index);
        if (this.statementblock != null) {
            this.statementblock.setMyStatementBlock(statementBlock, index);
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
        if (this.statementblock != null) {
            this.statementblock.setMyDefinition(definition);
        }
    }

    @Override
    public void setMyAltguards(AltGuards altGuards) {
        if (this.statementblock != null) {
            this.statementblock.setMyAltguards(altGuards);
        }
    }

    @Override
    public boolean isTerminating(CompilationTimeStamp timestamp) {
        return this.isInfiniteLoop;
    }

    @Override
    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        if (this.statementblock != null) {
            if (StatementBlock.ReturnStatus_type.RS_NO.equals((Object)this.statementblock.hasReturn(timestamp))) {
                return StatementBlock.ReturnStatus_type.RS_NO;
            }
            return StatementBlock.ReturnStatus_type.RS_MAYBE;
        }
        return StatementBlock.ReturnStatus_type.RS_NO;
    }

    @Override
    public boolean hasReceivingStatement() {
        if (this.statementblock != null) {
            return this.statementblock.hasReceivingStatement(0);
        }
        return false;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.isInfiniteLoop = false;
        this.hasReturn = StatementBlock.ReturnStatus_type.RS_NO;
        boolean loopAlwaysEntered = false;
        if (this.expression != null) {
            IValue last = this.expression.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
            IType.Type_type temporalType = last.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            if (!last.getIsErroneous(timestamp)) {
                if (!IType.Type_type.TYPE_BOOL.equals((Object)temporalType)) {
                    last.getLocation().reportSemanticError(BOOLEANEXPECTED);
                    this.expression.setIsErroneous(true);
                } else if (!this.expression.isUnfoldable(timestamp) && ((Boolean_Value)last).getValue()) {
                    loopAlwaysEntered = true;
                    if (StatementBlock.ReturnStatus_type.RS_NO.equals((Object)this.hasReturn(timestamp))) {
                        this.isInfiniteLoop = true;
                    }
                }
                if (this.expression.getMyGovernor() == null) {
                    this.expression.setMyGovernor(new Boolean_Type());
                }
            }
        }
        if (this.statementblock != null) {
            StatementBlock.ReturnStatus_type blockReturnStatus = this.statementblock.hasReturn(timestamp);
            this.hasReturn = StatementBlock.ReturnStatus_type.RS_NO.equals((Object)blockReturnStatus) ? StatementBlock.ReturnStatus_type.RS_NO : (StatementBlock.ReturnStatus_type.RS_YES.equals((Object)blockReturnStatus) && loopAlwaysEntered ? StatementBlock.ReturnStatus_type.RS_YES : StatementBlock.ReturnStatus_type.RS_MAYBE);
            this.statementblock.setMyLaicStmt(null, this);
            this.statementblock.check(timestamp);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void checkAllowedInterleave() {
        if (this.statementblock != null) {
            this.statementblock.checkAllowedInterleave();
        }
    }

    @Override
    public void postCheck() {
        super.postCheck();
        if (this.statementblock != null) {
            this.statementblock.postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            if (this.expression != null && reparser.envelopsDamage(this.expression.getLocation())) {
                this.expression.updateSyntax(reparser, true);
                enveloped = true;
                reparser.updateLocation(this.expression.getLocation());
            }
            if (this.statementblock != null) {
                if (enveloped) {
                    this.statementblock.updateSyntax(reparser, false);
                    reparser.updateLocation(this.statementblock.getLocation());
                } else if (reparser.envelopsDamage(this.statementblock.getLocation())) {
                    this.statementblock.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.statementblock.getLocation());
                }
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        if (this.expression != null) {
            this.expression.updateSyntax(reparser, false);
            reparser.updateLocation(this.expression.getLocation());
        }
        if (this.statementblock != null) {
            this.statementblock.updateSyntax(reparser, false);
            reparser.updateLocation(this.statementblock.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.expression != null) {
            this.expression.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.statementblock != null) {
            this.statementblock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.expression != null && !this.expression.accept(v)) {
            return false;
        }
        return this.statementblock == null || this.statementblock.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        boolean condition_always_true = false;
        IValue last = this.expression.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
        if (!last.isUnfoldable(CompilationTimeStamp.getBaseTimestamp())) {
            if (((Boolean_Value)this.expression).getValue()) {
                condition_always_true = true;
            } else {
                source.append("/* never occurs */;\n");
                return;
            }
        }
        source.append("for ( ; ; ) {\n");
        if (!condition_always_true) {
            this.getLocation().update_location_object(aData, source);
            AtomicInteger blockCount = new AtomicInteger(0);
            if (last.returnsNative()) {
                last.generateCodeTmp(aData, source, "if (!", blockCount);
                source.append(") {\n");
            } else {
                aData.addBuiltinTypeImport("TitanBoolean");
                last.generateCodeTmp(aData, source, "if (!TitanBoolean.get_native(", blockCount);
                source.append(")) {\n");
            }
            source.append("break;\n");
            source.append("}\n");
            for (int i = 0; i < blockCount.get(); ++i) {
                source.append("}\n");
            }
        }
        this.statementblock.generateCode(aData, source);
        source.append("}\n");
    }
}

